/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.IBuildMode;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Circle;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Cube;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Cylinder;
import nl.requios.effortlessbuilding.buildmode.buildmodes.DiagonalLine;
import nl.requios.effortlessbuilding.buildmode.buildmodes.DiagonalWall;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Floor;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Line;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Normal;
import nl.requios.effortlessbuilding.buildmode.buildmodes.NormalPlus;
import nl.requios.effortlessbuilding.buildmode.buildmodes.SlopeFloor;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Sphere;
import nl.requios.effortlessbuilding.buildmode.buildmodes.Wall;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;
import nl.requios.effortlessbuilding.network.BlockBrokenMessage;
import nl.requios.effortlessbuilding.network.BlockPlacedMessage;

public class BuildModes {
    public static Dictionary<EntityPlayer, Boolean> currentlyBreakingClient = new Hashtable<EntityPlayer, Boolean>();
    public static Dictionary<EntityPlayer, Boolean> currentlyBreakingServer = new Hashtable<EntityPlayer, Boolean>();

    public static void onBlockPlacedMessage(EntityPlayer player, BlockPlacedMessage message) {
        Vec3d hitVec;
        EnumFacing sideHit;
        List<BlockPos> coordinates;
        Dictionary<EntityPlayer, Boolean> currentlyBreaking;
        Dictionary<EntityPlayer, Boolean> dictionary = currentlyBreaking = player.field_70170_p.field_72995_K ? currentlyBreakingClient : currentlyBreakingServer;
        if (currentlyBreaking.get(player) != null && currentlyBreaking.get(player).booleanValue()) {
            BuildModes.initializeMode(player);
            return;
        }
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings(player);
        BuildModeEnum buildMode = modeSettings.getBuildMode();
        BlockPos startPos = null;
        if (message.isBlockHit() && message.getBlockPos() != null) {
            startPos = message.getBlockPos();
            boolean replaceable = player.field_70170_p.func_180495_p(startPos).func_185904_a().func_76222_j();
            boolean becomesDoubleSlab = SurvivalHelper.doesBecomeDoubleSlab(player, startPos, message.getSideHit());
            if (!(modifierSettings.doQuickReplace() || replaceable || becomesDoubleSlab)) {
                startPos = startPos.func_177972_a(message.getSideHit());
            }
            if (modifierSettings.doQuickReplace() && replaceable) {
                startPos = startPos.func_177977_b();
            }
            int maxReach = ReachHelper.getMaxReach(player);
            if (buildMode != BuildModeEnum.NORMAL && player.func_180425_c().func_177951_i((Vec3i)startPos) > (double)(maxReach * maxReach)) {
                EffortlessBuilding.log(player, "Placement exceeds your reach.");
                return;
            }
        }
        if ((coordinates = buildMode.instance.onRightClick(player, startPos, message.getSideHit(), message.getHitVec(), modifierSettings.doQuickReplace())).isEmpty()) {
            currentlyBreaking.put(player, false);
            return;
        }
        int limit = ReachHelper.getMaxBlocksPlacedAtOnce(player);
        if (coordinates.size() > limit) {
            coordinates = coordinates.subList(0, limit);
        }
        if ((sideHit = buildMode.instance.getSideHit(player)) == null) {
            sideHit = message.getSideHit();
        }
        if ((hitVec = buildMode.instance.getHitVec(player)) == null) {
            hitVec = message.getHitVec();
        }
        BuildModifiers.onBlockPlaced(player, coordinates, sideHit, hitVec, message.getPlaceStartPos());
        currentlyBreaking.remove(player);
    }

    public static void onBlockBrokenMessage(EntityPlayer player, BlockBrokenMessage message) {
        BlockPos startPos = message.isBlockHit() ? message.getBlockPos() : null;
        BuildModes.onBlockBroken(player, startPos, true);
    }

    public static void onBlockBroken(EntityPlayer player, BlockPos startPos, boolean breakStartPos) {
        Dictionary<EntityPlayer, Boolean> currentlyBreaking;
        Dictionary<EntityPlayer, Boolean> dictionary = currentlyBreaking = player.field_70170_p.field_72995_K ? currentlyBreakingClient : currentlyBreakingServer;
        if (currentlyBreaking.get(player) != null && !currentlyBreaking.get(player).booleanValue()) {
            BuildModes.initializeMode(player);
            return;
        }
        if (currentlyBreaking.get(player) == null && startPos == null) {
            return;
        }
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings(player);
        BuildModeEnum buildMode = modeSettings.getBuildMode();
        List<BlockPos> coordinates = buildMode.instance.onRightClick(player, startPos, EnumFacing.UP, Vec3d.field_186680_a, true);
        if (coordinates.isEmpty()) {
            currentlyBreaking.put(player, true);
            return;
        }
        BuildModifiers.onBlockBroken(player, coordinates, breakStartPos);
        currentlyBreaking.remove(player);
    }

    public static List<BlockPos> findCoordinates(EntityPlayer player, BlockPos startPos, boolean skipRaytrace) {
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        ModeSettingsManager.ModeSettings modeSettings = ModeSettingsManager.getModeSettings(player);
        coordinates.addAll(modeSettings.getBuildMode().instance.findCoordinates(player, startPos, skipRaytrace));
        return coordinates;
    }

    public static void initializeMode(EntityPlayer player) {
        Dictionary<EntityPlayer, Boolean> currentlyBreaking = player.field_70170_p.field_72995_K ? currentlyBreakingClient : currentlyBreakingServer;
        currentlyBreaking.remove(player);
        ModeSettingsManager.getModeSettings((EntityPlayer)player).getBuildMode().instance.initialize(player);
    }

    public static boolean isCurrentlyPlacing(EntityPlayer player) {
        Dictionary<EntityPlayer, Boolean> currentlyBreaking = player.field_70170_p.field_72995_K ? currentlyBreakingClient : currentlyBreakingServer;
        return currentlyBreaking.get(player) != null && currentlyBreaking.get(player) == false;
    }

    public static boolean isCurrentlyBreaking(EntityPlayer player) {
        Dictionary<EntityPlayer, Boolean> currentlyBreaking = player.field_70170_p.field_72995_K ? currentlyBreakingClient : currentlyBreakingServer;
        return currentlyBreaking.get(player) != null && currentlyBreaking.get(player) != false;
    }

    public static boolean isActive(EntityPlayer player) {
        Dictionary<EntityPlayer, Boolean> currentlyBreaking = player.field_70170_p.field_72995_K ? currentlyBreakingClient : currentlyBreakingServer;
        return currentlyBreaking.get(player) != null;
    }

    public static Vec3d findXBound(double x, Vec3d start, Vec3d look) {
        double y = (x - start.field_72450_a) / look.field_72450_a * look.field_72448_b + start.field_72448_b;
        double z = (x - start.field_72450_a) / look.field_72450_a * look.field_72449_c + start.field_72449_c;
        return new Vec3d(x, y, z);
    }

    public static Vec3d findYBound(double y, Vec3d start, Vec3d look) {
        double x = (y - start.field_72448_b) / look.field_72448_b * look.field_72450_a + start.field_72450_a;
        double z = (y - start.field_72448_b) / look.field_72448_b * look.field_72449_c + start.field_72449_c;
        return new Vec3d(x, y, z);
    }

    public static Vec3d findZBound(double z, Vec3d start, Vec3d look) {
        double x = (z - start.field_72449_c) / look.field_72449_c * look.field_72450_a + start.field_72450_a;
        double y = (z - start.field_72449_c) / look.field_72449_c * look.field_72448_b + start.field_72448_b;
        return new Vec3d(x, y, z);
    }

    public static boolean isCriteriaValid(Vec3d start, Vec3d look, int reach, EntityPlayer player, boolean skipRaytrace, Vec3d lineBound, Vec3d planeBound, double distToPlayerSq) {
        boolean intersects = false;
        if (!skipRaytrace) {
            RayTraceResult rayTraceResult = player.field_70170_p.func_200259_a(start, lineBound, RayTraceFluidMode.NEVER, true, false);
            intersects = rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && planeBound.func_178788_d(rayTraceResult.field_72307_f).func_189985_c() > 4.0;
        }
        return planeBound.func_178788_d(start).func_72430_b(look) > 0.0 && distToPlayerSq > 2.0 && distToPlayerSq < (double)(reach * reach) && !intersects;
    }

    public static enum BuildModeEnum {
        NORMAL("effortlessbuilding.mode.normal", new Normal(), new ModeOptions.OptionEnum[0]),
        NORMAL_PLUS("effortlessbuilding.mode.normal_plus", new NormalPlus(), ModeOptions.OptionEnum.BUILD_SPEED),
        LINE("effortlessbuilding.mode.line", new Line(), new ModeOptions.OptionEnum[0]),
        WALL("effortlessbuilding.mode.wall", new Wall(), ModeOptions.OptionEnum.FILL),
        FLOOR("effortlessbuilding.mode.floor", new Floor(), ModeOptions.OptionEnum.FILL),
        DIAGONAL_LINE("effortlessbuilding.mode.diagonal_line", new DiagonalLine(), new ModeOptions.OptionEnum[0]),
        DIAGONAL_WALL("effortlessbuilding.mode.diagonal_wall", new DiagonalWall(), new ModeOptions.OptionEnum[0]),
        SLOPE_FLOOR("effortlessbuilding.mode.slope_floor", new SlopeFloor(), ModeOptions.OptionEnum.RAISED_EDGE),
        CIRCLE("effortlessbuilding.mode.circle", new Circle(), ModeOptions.OptionEnum.CIRCLE_START, ModeOptions.OptionEnum.FILL),
        CYLINDER("effortlessbuilding.mode.cylinder", new Cylinder(), ModeOptions.OptionEnum.CIRCLE_START, ModeOptions.OptionEnum.FILL),
        SPHERE("effortlessbuilding.mode.sphere", new Sphere(), ModeOptions.OptionEnum.CIRCLE_START, ModeOptions.OptionEnum.FILL),
        CUBE("effortlessbuilding.mode.cube", new Cube(), ModeOptions.OptionEnum.CUBE_FILL);

        public String name;
        public IBuildMode instance;
        public ModeOptions.OptionEnum[] options;

        private BuildModeEnum(String name, IBuildMode instance, ModeOptions.OptionEnum ... options) {
            this.name = name;
            this.instance = instance;
            this.options = options;
        }
    }
}

