/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.capability.ModeCapabilityManager;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.network.ModeSettingsMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;

@Mod.EventBusSubscriber
public class ModeSettingsManager {
    @Nonnull
    public static ModeSettings getModeSettings(EntityPlayer player) {
        LazyOptional modeCapability = player.getCapability(ModeCapabilityManager.modeCapability, null);
        if (modeCapability.isPresent()) {
            ModeCapabilityManager.IModeCapability capability = (ModeCapabilityManager.IModeCapability)modeCapability.orElse(null);
            if (capability.getModeData() == null) {
                capability.setModeData(new ModeSettings());
            }
            return capability.getModeData();
        }
        return new ModeSettings();
    }

    public static void setModeSettings(EntityPlayer player, ModeSettings modeSettings) {
        if (player == null) {
            EffortlessBuilding.log("Cannot set buildmode settings, player is null");
            return;
        }
        LazyOptional modeCapability = player.getCapability(ModeCapabilityManager.modeCapability, null);
        modeCapability.ifPresent(capability -> {
            capability.setModeData(modeSettings);
            BuildModes.initializeMode(player);
        });
        if (!modeCapability.isPresent()) {
            EffortlessBuilding.log(player, "Saving buildmode settings failed.");
        }
    }

    public static String sanitize(ModeSettings modeSettings, EntityPlayer player) {
        int maxReach = ReachHelper.getMaxReach(player);
        String error = "";
        return error;
    }

    public static void handleNewPlayer(EntityPlayer player) {
        ModeSettingsManager.getModeSettings(player);
        if (!player.field_70170_p.field_72995_K) {
            ModeSettingsMessage msg = new ModeSettingsMessage(ModeSettingsManager.getModeSettings(player));
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (EntityPlayerMP)player), (Object)msg);
        }
    }

    public static class ModeSettings {
        private BuildModes.BuildModeEnum buildMode = BuildModes.BuildModeEnum.NORMAL;

        public ModeSettings() {
        }

        public ModeSettings(BuildModes.BuildModeEnum buildMode) {
            this.buildMode = buildMode;
        }

        public BuildModes.BuildModeEnum getBuildMode() {
            return this.buildMode;
        }

        public void setBuildMode(BuildModes.BuildModeEnum buildMode) {
            this.buildMode = buildMode;
        }
    }
}

