/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nl.requios.effortlessbuilding.buildmodifier.Array;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;

@Mod.EventBusSubscriber
public class ModifierCapabilityManager {
    @CapabilityInject(value=IModifierCapability.class)
    public static final Capability<IModifierCapability> modifierCapability = null;

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        LazyOptional original = event.getOriginal().getCapability(modifierCapability, null);
        LazyOptional clone = event.getEntity().getCapability(modifierCapability, null);
        clone.ifPresent(cloneModifierCapability -> original.ifPresent(originalModifierCapability -> cloneModifierCapability.setModifierData(originalModifierCapability.getModifierData())));
    }

    public static class Provider
    implements ICapabilitySerializable<INBTBase> {
        IModifierCapability inst = (IModifierCapability)modifierCapability.getDefaultInstance();

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable EnumFacing side) {
            return modifierCapability.orEmpty(cap, LazyOptional.of(() -> this.inst));
        }

        public INBTBase serializeNBT() {
            return modifierCapability.getStorage().writeNBT(modifierCapability, (Object)this.inst, null);
        }

        public void deserializeNBT(INBTBase nbt) {
            modifierCapability.getStorage().readNBT(modifierCapability, (Object)this.inst, null, nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<IModifierCapability> {
        public INBTBase writeNBT(Capability<IModifierCapability> capability, IModifierCapability instance, EnumFacing side) {
            Mirror.MirrorSettings m;
            NBTTagCompound compound = new NBTTagCompound();
            ModifierSettingsManager.ModifierSettings modifierSettings = instance.getModifierData();
            if (modifierSettings == null) {
                modifierSettings = new ModifierSettingsManager.ModifierSettings();
            }
            if ((m = modifierSettings.getMirrorSettings()) == null) {
                m = new Mirror.MirrorSettings();
            }
            compound.func_74757_a("mirrorEnabled", m.enabled);
            compound.func_74780_a("mirrorPosX", m.position.field_72450_a);
            compound.func_74780_a("mirrorPosY", m.position.field_72448_b);
            compound.func_74780_a("mirrorPosZ", m.position.field_72449_c);
            compound.func_74757_a("mirrorX", m.mirrorX);
            compound.func_74757_a("mirrorY", m.mirrorY);
            compound.func_74757_a("mirrorZ", m.mirrorZ);
            compound.func_74768_a("mirrorRadius", m.radius);
            compound.func_74757_a("mirrorDrawLines", m.drawLines);
            compound.func_74757_a("mirrorDrawPlanes", m.drawPlanes);
            Array.ArraySettings a = modifierSettings.getArraySettings();
            if (a == null) {
                a = new Array.ArraySettings();
            }
            compound.func_74757_a("arrayEnabled", a.enabled);
            compound.func_74768_a("arrayOffsetX", a.offset.func_177958_n());
            compound.func_74768_a("arrayOffsetY", a.offset.func_177956_o());
            compound.func_74768_a("arrayOffsetZ", a.offset.func_177952_p());
            compound.func_74768_a("arrayCount", a.count);
            compound.func_74768_a("reachUpgrade", modifierSettings.getReachUpgrade());
            RadialMirror.RadialMirrorSettings r = modifierSettings.getRadialMirrorSettings();
            if (r == null) {
                r = new RadialMirror.RadialMirrorSettings();
            }
            compound.func_74757_a("radialMirrorEnabled", r.enabled);
            compound.func_74780_a("radialMirrorPosX", r.position.field_72450_a);
            compound.func_74780_a("radialMirrorPosY", r.position.field_72448_b);
            compound.func_74780_a("radialMirrorPosZ", r.position.field_72449_c);
            compound.func_74768_a("radialMirrorSlices", r.slices);
            compound.func_74757_a("radialMirrorAlternate", r.alternate);
            compound.func_74768_a("radialMirrorRadius", r.radius);
            compound.func_74757_a("radialMirrorDrawLines", r.drawLines);
            compound.func_74757_a("radialMirrorDrawPlanes", r.drawPlanes);
            return compound;
        }

        public void readNBT(Capability<IModifierCapability> capability, IModifierCapability instance, EnumFacing side, INBTBase nbt) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            boolean mirrorEnabled = compound.func_74767_n("mirrorEnabled");
            Vec3d mirrorPosition = new Vec3d(compound.func_74769_h("mirrorPosX"), compound.func_74769_h("mirrorPosY"), compound.func_74769_h("mirrorPosZ"));
            boolean mirrorX = compound.func_74767_n("mirrorX");
            boolean mirrorY = compound.func_74767_n("mirrorY");
            boolean mirrorZ = compound.func_74767_n("mirrorZ");
            int mirrorRadius = compound.func_74762_e("mirrorRadius");
            boolean mirrorDrawLines = compound.func_74767_n("mirrorDrawLines");
            boolean mirrorDrawPlanes = compound.func_74767_n("mirrorDrawPlanes");
            Mirror.MirrorSettings mirrorSettings = new Mirror.MirrorSettings(mirrorEnabled, mirrorPosition, mirrorX, mirrorY, mirrorZ, mirrorRadius, mirrorDrawLines, mirrorDrawPlanes);
            boolean arrayEnabled = compound.func_74767_n("arrayEnabled");
            BlockPos arrayOffset = new BlockPos(compound.func_74762_e("arrayOffsetX"), compound.func_74762_e("arrayOffsetY"), compound.func_74762_e("arrayOffsetZ"));
            int arrayCount = compound.func_74762_e("arrayCount");
            Array.ArraySettings arraySettings = new Array.ArraySettings(arrayEnabled, arrayOffset, arrayCount);
            int reachUpgrade = compound.func_74762_e("reachUpgrade");
            boolean radialMirrorEnabled = compound.func_74767_n("radialMirrorEnabled");
            Vec3d radialMirrorPosition = new Vec3d(compound.func_74769_h("radialMirrorPosX"), compound.func_74769_h("radialMirrorPosY"), compound.func_74769_h("radialMirrorPosZ"));
            int radialMirrorSlices = compound.func_74762_e("radialMirrorSlices");
            boolean radialMirrorAlternate = compound.func_74767_n("radialMirrorAlternate");
            int radialMirrorRadius = compound.func_74762_e("radialMirrorRadius");
            boolean radialMirrorDrawLines = compound.func_74767_n("radialMirrorDrawLines");
            boolean radialMirrorDrawPlanes = compound.func_74767_n("radialMirrorDrawPlanes");
            RadialMirror.RadialMirrorSettings radialMirrorSettings = new RadialMirror.RadialMirrorSettings(radialMirrorEnabled, radialMirrorPosition, radialMirrorSlices, radialMirrorAlternate, radialMirrorRadius, radialMirrorDrawLines, radialMirrorDrawPlanes);
            ModifierSettingsManager.ModifierSettings modifierSettings = new ModifierSettingsManager.ModifierSettings(mirrorSettings, arraySettings, radialMirrorSettings, false, reachUpgrade);
            instance.setModifierData(modifierSettings);
        }
    }

    public static class ModifierCapability
    implements IModifierCapability {
        private ModifierSettingsManager.ModifierSettings modifierSettings;

        @Override
        public ModifierSettingsManager.ModifierSettings getModifierData() {
            return this.modifierSettings;
        }

        @Override
        public void setModifierData(ModifierSettingsManager.ModifierSettings modifierSettings) {
            this.modifierSettings = modifierSettings;
        }
    }

    public static interface IModifierCapability {
        public ModifierSettingsManager.ModifierSettings getModifierData();

        public void setModifierData(ModifierSettingsManager.ModifierSettings var1);
    }
}

