/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmodifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.gui.elements.GuiCollapsibleScrollEntry;
import nl.requios.effortlessbuilding.gui.elements.GuiIconButton;
import nl.requios.effortlessbuilding.gui.elements.GuiNumberField;
import nl.requios.effortlessbuilding.gui.elements.GuiScrollPane;
import nl.requios.effortlessbuilding.helper.ReachHelper;

@OnlyIn(value=Dist.CLIENT)
public class MirrorSettingsGui
extends GuiCollapsibleScrollEntry {
    protected static final ResourceLocation BUILDING_ICONS = new ResourceLocation("effortlessbuilding", "textures/gui/building_icons.png");
    protected List<GuiButton> mirrorButtonList = new ArrayList<GuiButton>();
    protected List<GuiIconButton> mirrorIconButtonList = new ArrayList<GuiIconButton>();
    protected List<GuiNumberField> mirrorNumberFieldList = new ArrayList<GuiNumberField>();
    private GuiNumberField textMirrorPosX;
    private GuiNumberField textMirrorPosY;
    private GuiNumberField textMirrorPosZ;
    private GuiNumberField textMirrorRadius;
    private GuiCheckBox buttonMirrorEnabled;
    private GuiCheckBox buttonMirrorX;
    private GuiCheckBox buttonMirrorY;
    private GuiCheckBox buttonMirrorZ;
    private GuiIconButton buttonCurrentPosition;
    private GuiIconButton buttonToggleOdd;
    private GuiIconButton buttonDrawPlanes;
    private GuiIconButton buttonDrawLines;
    private boolean drawPlanes;
    private boolean drawLines;
    private boolean toggleOdd;

    public MirrorSettingsGui(GuiScrollPane scrollPane) {
        super(scrollPane);
    }

    @Override
    public int initGui(int id, List<GuiButton> buttonList) {
        id = super.initGui(id, buttonList);
        int y = this.top - 2;
        this.buttonMirrorEnabled = new GuiCheckBox(id++, this.left - 15 + 8, y, "", false){

            public void func_194829_a(double mouseX, double mouseY) {
                super.func_194829_a(mouseX, mouseY);
                MirrorSettingsGui.this.setCollapsed(!MirrorSettingsGui.this.buttonMirrorEnabled.isChecked());
            }
        };
        buttonList.add((GuiButton)this.buttonMirrorEnabled);
        y = this.top + 18;
        this.textMirrorPosX = new GuiNumberField(id++, id++, id++, this.fontRenderer, buttonList, this.left + 58, y, 62, 18);
        this.textMirrorPosX.setNumber(0.0);
        this.textMirrorPosX.setTooltip(Arrays.asList("The position of the mirror.", TextFormatting.GRAY + "For odd numbered builds add 0.5."));
        this.mirrorNumberFieldList.add(this.textMirrorPosX);
        this.textMirrorPosY = new GuiNumberField(id++, id++, id++, this.fontRenderer, buttonList, this.left + 138, y, 62, 18);
        this.textMirrorPosY.setNumber(64.0);
        this.textMirrorPosY.setTooltip(Arrays.asList("The position of the mirror.", TextFormatting.GRAY + "For odd numbered builds add 0.5."));
        this.mirrorNumberFieldList.add(this.textMirrorPosY);
        this.textMirrorPosZ = new GuiNumberField(id++, id++, id++, this.fontRenderer, buttonList, this.left + 218, y, 62, 18);
        this.textMirrorPosZ.setNumber(0.0);
        this.textMirrorPosZ.setTooltip(Arrays.asList("The position of the mirror.", TextFormatting.GRAY + "For odd numbered builds add 0.5."));
        this.mirrorNumberFieldList.add(this.textMirrorPosZ);
        y = this.top + 50;
        this.buttonMirrorX = new GuiCheckBox(id++, this.left + 60, y, " X", true);
        this.mirrorButtonList.add((GuiButton)this.buttonMirrorX);
        this.buttonMirrorY = new GuiCheckBox(id++, this.left + 100, y, " Y", false);
        this.mirrorButtonList.add((GuiButton)this.buttonMirrorY);
        this.buttonMirrorZ = new GuiCheckBox(id++, this.left + 140, y, " Z", false);
        this.mirrorButtonList.add((GuiButton)this.buttonMirrorZ);
        y = this.top + 47;
        this.textMirrorRadius = new GuiNumberField(id++, id++, id++, this.fontRenderer, buttonList, this.left + 218, y, 62, 18);
        this.textMirrorRadius.setNumber(50.0);
        this.textMirrorRadius.setTooltip(Arrays.asList("How far the mirror reaches in any direction.", TextFormatting.GRAY + "Max: " + TextFormatting.GOLD + ReachHelper.getMaxReach((EntityPlayer)this.mc.field_71439_g) / 2, TextFormatting.GRAY + "Upgradeable in survival with reach upgrades."));
        this.mirrorNumberFieldList.add(this.textMirrorRadius);
        y = this.top + 72;
        this.buttonCurrentPosition = new GuiIconButton(id++, this.left + 5, y, 0, 0, BUILDING_ICONS){

            public void func_194829_a(double mouseX, double mouseY) {
                super.func_194829_a(mouseX, mouseY);
                Vec3d pos = new Vec3d(Math.floor(((MirrorSettingsGui)MirrorSettingsGui.this).mc.field_71439_g.field_70165_t) + 0.5, Math.floor(((MirrorSettingsGui)MirrorSettingsGui.this).mc.field_71439_g.field_70163_u) + 0.5, Math.floor(((MirrorSettingsGui)MirrorSettingsGui.this).mc.field_71439_g.field_70161_v) + 0.5);
                MirrorSettingsGui.this.textMirrorPosX.setNumber(pos.field_72450_a);
                MirrorSettingsGui.this.textMirrorPosY.setNumber(pos.field_72448_b);
                MirrorSettingsGui.this.textMirrorPosZ.setNumber(pos.field_72449_c);
            }
        };
        this.buttonCurrentPosition.setTooltip("Set mirror position to current player position");
        this.mirrorIconButtonList.add(this.buttonCurrentPosition);
        this.buttonToggleOdd = new GuiIconButton(id++, this.left + 35, y, 0, 20, BUILDING_ICONS){

            public void func_194829_a(double mouseX, double mouseY) {
                super.func_194829_a(mouseX, mouseY);
                MirrorSettingsGui.this.toggleOdd = !MirrorSettingsGui.this.toggleOdd;
                MirrorSettingsGui.this.buttonToggleOdd.setUseAlternateIcon(MirrorSettingsGui.this.toggleOdd);
                if (MirrorSettingsGui.this.toggleOdd) {
                    MirrorSettingsGui.this.buttonToggleOdd.setTooltip(Arrays.asList("Set mirror position to corner of block", "for even numbered builds"));
                    MirrorSettingsGui.this.textMirrorPosX.setNumber(MirrorSettingsGui.this.textMirrorPosX.getNumber() + 0.5);
                    MirrorSettingsGui.this.textMirrorPosY.setNumber(MirrorSettingsGui.this.textMirrorPosY.getNumber() + 0.5);
                    MirrorSettingsGui.this.textMirrorPosZ.setNumber(MirrorSettingsGui.this.textMirrorPosZ.getNumber() + 0.5);
                } else {
                    MirrorSettingsGui.this.buttonToggleOdd.setTooltip(Arrays.asList("Set mirror position to middle of block", "for odd numbered builds"));
                    MirrorSettingsGui.this.textMirrorPosX.setNumber(Math.floor(MirrorSettingsGui.this.textMirrorPosX.getNumber()));
                    MirrorSettingsGui.this.textMirrorPosY.setNumber(Math.floor(MirrorSettingsGui.this.textMirrorPosY.getNumber()));
                    MirrorSettingsGui.this.textMirrorPosZ.setNumber(Math.floor(MirrorSettingsGui.this.textMirrorPosZ.getNumber()));
                }
            }
        };
        this.buttonToggleOdd.setTooltip(Arrays.asList("Set mirror position to middle of block", "for odd numbered builds"));
        this.mirrorIconButtonList.add(this.buttonToggleOdd);
        this.buttonDrawLines = new GuiIconButton(id++, this.left + 65, y, 0, 40, BUILDING_ICONS){

            public void func_194829_a(double mouseX, double mouseY) {
                super.func_194829_a(mouseX, mouseY);
                MirrorSettingsGui.this.drawLines = !MirrorSettingsGui.this.drawLines;
                MirrorSettingsGui.this.buttonDrawLines.setUseAlternateIcon(MirrorSettingsGui.this.drawLines);
                MirrorSettingsGui.this.buttonDrawLines.setTooltip(MirrorSettingsGui.this.drawLines ? "Hide lines" : "Show lines");
            }
        };
        this.buttonDrawLines.setTooltip("Show lines");
        this.mirrorIconButtonList.add(this.buttonDrawLines);
        this.buttonDrawPlanes = new GuiIconButton(id++, this.left + 95, y, 0, 60, BUILDING_ICONS){

            public void func_194829_a(double mouseX, double mouseY) {
                super.func_194829_a(mouseX, mouseY);
                MirrorSettingsGui.this.drawPlanes = !MirrorSettingsGui.this.drawPlanes;
                MirrorSettingsGui.this.buttonDrawPlanes.setUseAlternateIcon(MirrorSettingsGui.this.drawPlanes);
                MirrorSettingsGui.this.buttonDrawPlanes.setTooltip(MirrorSettingsGui.this.drawPlanes ? "Hide area" : "Show area");
            }
        };
        this.buttonDrawPlanes.setTooltip("Show area");
        this.mirrorIconButtonList.add(this.buttonDrawPlanes);
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((EntityPlayer)this.mc.field_71439_g);
        if (modifierSettings != null) {
            Mirror.MirrorSettings m = modifierSettings.getMirrorSettings();
            this.buttonMirrorEnabled.setIsChecked(m.enabled);
            this.textMirrorPosX.setNumber(m.position.field_72450_a);
            this.textMirrorPosY.setNumber(m.position.field_72448_b);
            this.textMirrorPosZ.setNumber(m.position.field_72449_c);
            this.buttonMirrorX.setIsChecked(m.mirrorX);
            this.buttonMirrorY.setIsChecked(m.mirrorY);
            this.buttonMirrorZ.setIsChecked(m.mirrorZ);
            this.textMirrorRadius.setNumber(m.radius);
            this.drawLines = m.drawLines;
            this.drawPlanes = m.drawPlanes;
            this.buttonDrawLines.setUseAlternateIcon(this.drawLines);
            this.buttonDrawPlanes.setUseAlternateIcon(this.drawPlanes);
            this.buttonDrawLines.setTooltip(this.drawLines ? "Hide lines" : "Show lines");
            this.buttonDrawPlanes.setTooltip(this.drawPlanes ? "Hide area" : "Show area");
            if (this.textMirrorPosX.getNumber() == Math.floor(this.textMirrorPosX.getNumber())) {
                this.toggleOdd = false;
                this.buttonToggleOdd.setTooltip(Arrays.asList("Set mirror position to middle of block", "for odd numbered builds"));
            } else {
                this.toggleOdd = true;
                this.buttonToggleOdd.setTooltip(Arrays.asList("Set mirror position to corner of block", "for even numbered builds"));
            }
            this.buttonToggleOdd.setUseAlternateIcon(this.toggleOdd);
        }
        buttonList.addAll(this.mirrorButtonList);
        buttonList.addAll(this.mirrorIconButtonList);
        this.setCollapsed(!this.buttonMirrorEnabled.isChecked());
        return id;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.mirrorNumberFieldList.forEach(GuiNumberField::update);
    }

    @Override
    public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        int yy = y;
        int offset = 8;
        this.buttonMirrorEnabled.func_194828_a(mouseX, mouseY, partialTicks);
        if (this.buttonMirrorEnabled.isChecked()) {
            this.buttonMirrorEnabled.field_146129_i = yy;
            this.fontRenderer.func_211126_b("Mirror enabled", (float)(this.left + offset), (float)(yy + 2), 0xFFFFFF);
            yy = y + 18;
            this.fontRenderer.func_211126_b("Position", (float)(this.left + offset), (float)(yy + 5), 0xFFFFFF);
            this.fontRenderer.func_211126_b("X", (float)(this.left + 40 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textMirrorPosX.y = yy;
            this.fontRenderer.func_211126_b("Y", (float)(this.left + 120 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textMirrorPosY.y = yy;
            this.fontRenderer.func_211126_b("Z", (float)(this.left + 200 + offset), (float)(yy + 5), 0xFFFFFF);
            this.textMirrorPosZ.y = yy;
            yy = y + 50;
            this.fontRenderer.func_211126_b("Direction", (float)(this.left + offset), (float)(yy + 2), 0xFFFFFF);
            this.buttonMirrorX.field_146129_i = yy;
            this.buttonMirrorY.field_146129_i = yy;
            this.buttonMirrorZ.field_146129_i = yy;
            this.fontRenderer.func_211126_b("Radius", (float)(this.left + 176 + offset), (float)(yy + 2), 0xFFFFFF);
            this.textMirrorRadius.y = yy - 3;
            this.buttonCurrentPosition.field_146129_i = yy = y + 72;
            this.buttonToggleOdd.field_146129_i = yy;
            this.buttonDrawLines.field_146129_i = yy;
            this.buttonDrawPlanes.field_146129_i = yy;
            this.mirrorButtonList.forEach(button -> button.func_194828_a(mouseX, mouseY, partialTicks));
            this.mirrorIconButtonList.forEach(button -> button.func_194828_a(mouseX, mouseY, partialTicks));
            this.mirrorNumberFieldList.forEach(numberField -> numberField.drawNumberField(mouseX, mouseY, partialTicks));
        } else {
            this.buttonMirrorEnabled.field_146129_i = yy;
            this.fontRenderer.func_211126_b("Mirror disabled", (float)(this.left + offset), (float)(yy + 2), 0x999999);
        }
    }

    @Override
    public void drawTooltip(GuiScreen guiScreen, int mouseX, int mouseY) {
        if (this.buttonMirrorEnabled.isChecked()) {
            this.mirrorIconButtonList.forEach(iconButton -> iconButton.drawTooltip(this.scrollPane.parent, mouseX, mouseY));
            this.mirrorNumberFieldList.forEach(numberField -> numberField.drawTooltip(this.scrollPane.parent, mouseX, mouseY));
        }
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        super.charTyped(typedChar, keyCode);
        for (GuiNumberField numberField : this.mirrorNumberFieldList) {
            numberField.charTyped(typedChar, keyCode);
        }
        return true;
    }

    @Override
    public boolean mousePressed(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        boolean insideMirrorEnabledLabel;
        this.mirrorNumberFieldList.forEach(numberField -> numberField.mouseClicked(mouseX, mouseY, mouseEvent));
        boolean bl = insideMirrorEnabledLabel = mouseX >= this.left && mouseX < this.right && relativeY >= -2 && relativeY < 12;
        if (insideMirrorEnabledLabel) {
            this.buttonMirrorEnabled.func_146113_a(this.mc.func_147118_V());
            this.buttonMirrorEnabled.func_194829_a((double)mouseX, (double)mouseY);
        }
        return true;
    }

    public Mirror.MirrorSettings getMirrorSettings() {
        boolean mirrorEnabled = this.buttonMirrorEnabled.isChecked();
        Vec3d mirrorPos = new Vec3d(0.0, 64.0, 0.0);
        try {
            mirrorPos = new Vec3d(this.textMirrorPosX.getNumber(), this.textMirrorPosY.getNumber(), this.textMirrorPosZ.getNumber());
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((EntityPlayer)this.mc.field_71439_g, "Mirror position not a valid number.");
        }
        boolean mirrorX = this.buttonMirrorX.isChecked();
        boolean mirrorY = this.buttonMirrorY.isChecked();
        boolean mirrorZ = this.buttonMirrorZ.isChecked();
        int mirrorRadius = 50;
        try {
            mirrorRadius = (int)this.textMirrorRadius.getNumber();
        }
        catch (NullPointerException | NumberFormatException ex) {
            EffortlessBuilding.log((EntityPlayer)this.mc.field_71439_g, "Mirror radius not a valid number.");
        }
        return new Mirror.MirrorSettings(mirrorEnabled, mirrorPos, mirrorX, mirrorY, mirrorZ, mirrorRadius, this.drawLines, this.drawPlanes);
    }

    @Override
    protected String getName() {
        return "Mirror";
    }

    @Override
    protected int getExpandedHeight() {
        return 100;
    }
}

