/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.elements;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class GuiScrollPane
extends GuiSlot {
    public GuiScreen parent;
    public FontRenderer fontRenderer;
    private List<IScrollEntry> listEntries;
    private float scrollMultiplier = 1.0f;
    private int mouseX;
    private int mouseY;

    public GuiScrollPane(GuiScreen parent, FontRenderer fontRenderer, int top, int bottom) {
        super(parent.field_146297_k, parent.field_146294_l, parent.field_146295_m, top, bottom, 100);
        this.parent = parent;
        this.fontRenderer = fontRenderer;
        this.func_193651_b(false);
        this.listEntries = new ArrayList<IScrollEntry>();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public IScrollEntry getListEntry(int index) {
        return this.listEntries.get(index);
    }

    public void AddListEntry(IScrollEntry listEntry) {
        this.listEntries.add(listEntry);
    }

    protected int func_148127_b() {
        return this.listEntries.size();
    }

    protected boolean func_148131_a(int slotIndex) {
        return false;
    }

    protected int func_148137_d() {
        return this.field_148155_a - 15;
    }

    public int func_148139_c() {
        return 280;
    }

    public void func_148128_a(int mouseXIn, int mouseYIn, float partialTicks) {
        if (this.field_178041_q) {
            this.mouseX = mouseXIn;
            this.mouseY = mouseYIn;
            int scrollBarLeft = this.func_148137_d();
            int scrollBarRight = scrollBarLeft + 6;
            this.func_148121_k();
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            int insideLeft = this.field_148152_e + this.field_148155_a / 2 - this.func_148139_c() / 2 + 2;
            int insideTop = this.field_148153_b + 4 - (int)this.field_148169_q;
            if (this.field_148165_u) {
                this.func_148129_a(insideLeft, insideTop, tessellator);
            }
            this.func_192638_a(insideLeft, insideTop, mouseXIn, mouseYIn, partialTicks);
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179118_c();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179090_x();
            int maxScroll = this.func_148135_f();
            if (maxScroll > 0) {
                int k1 = (this.field_148154_c - this.field_148153_b) * (this.field_148154_c - this.field_148153_b) / this.func_148138_e();
                int l1 = (int)this.field_148169_q * (this.field_148154_c - this.field_148153_b - (k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.field_148154_c - this.field_148153_b - 8)))) / maxScroll + this.field_148153_b;
                if (l1 < this.field_148153_b) {
                    l1 = this.field_148153_b;
                }
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)scrollBarLeft, (double)this.field_148154_c, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)scrollBarRight, (double)this.field_148154_c, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)scrollBarRight, (double)this.field_148153_b, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)scrollBarLeft, (double)this.field_148153_b, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)scrollBarLeft, (double)(l1 + k1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)scrollBarRight, (double)(l1 + k1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)scrollBarRight, (double)l1, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)scrollBarLeft, (double)l1, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)scrollBarLeft, (double)(l1 + k1 - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(scrollBarRight - 1), (double)(l1 + k1 - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(scrollBarRight - 1), (double)l1, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)scrollBarLeft, (double)l1, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                tessellator.func_78381_a();
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
        }
    }

    protected int func_148138_e() {
        int height = this.field_148160_j;
        for (IScrollEntry entry : this.listEntries) {
            height += entry.getHeight();
        }
        return height;
    }

    protected void func_148123_a() {
    }

    protected void func_192637_a(int slotIndex, int xPos, int yPos, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
        this.getListEntry(slotIndex).drawEntry(slotIndex, xPos, yPos, this.func_148139_c(), heightIn, mouseXIn, mouseYIn, this.getSlotIndexFromScreenCoords(mouseXIn, mouseYIn) == slotIndex, partialTicks);
    }

    public int getContentHeight(int count) {
        int height = this.field_148160_j;
        for (int i = 0; i < count; ++i) {
            IScrollEntry entry = this.listEntries.get(i);
            height += entry.getHeight();
        }
        return height;
    }

    public int getSlotIndexFromScreenCoords(double posX, double posY) {
        int left = this.field_148152_e + (this.field_148155_a - this.func_148139_c()) / 2;
        int right = this.field_148152_e + (this.field_148155_a + this.func_148139_c()) / 2;
        double relativeMouseY = this.getRelativeMouseY(this.mouseY, 0);
        for (int i = 0; i < this.listEntries.size(); ++i) {
            IScrollEntry entry = this.listEntries.get(i);
            if (relativeMouseY <= (double)entry.getHeight()) {
                return posX < (double)this.func_148137_d() && posX >= (double)left && posX <= (double)right && i >= 0 && relativeMouseY >= 0.0 && i < this.func_148127_b() ? i : -1;
            }
            relativeMouseY -= (double)entry.getHeight();
        }
        return -1;
    }

    protected boolean func_195078_a(int index, int button, double mouseX, double mouseY) {
        int selectedSlot = this.getSlotIndexFromScreenCoords(mouseX, mouseY);
        double relativeX = this.getRelativeMouseX(mouseX);
        for (int i = 0; i < this.listEntries.size(); ++i) {
            double relativeY = this.getRelativeMouseY(mouseY, i);
            this.getListEntry(i).mousePressed(selectedSlot, (int)mouseX, (int)mouseY, button, (int)relativeX, (int)relativeY);
        }
        return false;
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        for (int i = 0; i < this.func_148127_b(); ++i) {
            double relativeX = this.getRelativeMouseX(this.mouseX);
            double relativeY = this.getRelativeMouseY(this.mouseY, i);
            this.getListEntry(i).mouseReleased(i, (int)p_mouseReleased_1_, (int)p_mouseReleased_3_, p_mouseReleased_5_, (int)relativeX, (int)relativeY);
        }
        this.field_178041_q = true;
        return false;
    }

    public void handleMouseInput() {
        if (this.func_195079_b(this.mouseX, this.mouseY)) {
            if (this.field_148161_k.field_71417_B.func_198030_b() && this.mouseY >= this.field_148153_b && this.mouseY <= this.field_148154_c) {
                int i = this.field_148152_e + (this.field_148155_a - this.func_148139_c()) / 2;
                int j = this.field_148152_e + (this.field_148155_a + this.func_148139_c()) / 2;
                int slotIndex = this.getSlotIndexFromScreenCoords(this.mouseX, this.mouseY);
                double relativeMouseY = this.getRelativeMouseY(this.mouseY, slotIndex);
                if (slotIndex > -1) {
                    this.func_195078_a(slotIndex, 0, this.mouseX, this.mouseY);
                    this.field_148168_r = slotIndex;
                } else if (this.mouseX >= i && this.mouseX <= j && relativeMouseY < 0.0) {
                    this.func_148132_a(this.mouseX - i, this.mouseY - this.field_148153_b + (int)this.field_148169_q - 4);
                }
            }
            if (this.field_148161_k.field_71417_B.func_198030_b() && this.func_195082_l()) {
                if (this.field_148157_o == -1) {
                    boolean flag1 = true;
                    if (this.mouseY >= this.field_148153_b && this.mouseY <= this.field_148154_c) {
                        int i2 = this.field_148152_e + (this.field_148155_a - this.func_148139_c()) / 2;
                        int j2 = this.field_148152_e + (this.field_148155_a + this.func_148139_c()) / 2;
                        int slotIndex = this.getSlotIndexFromScreenCoords(this.mouseX, this.mouseY);
                        double relativeMouseY = this.getRelativeMouseY(this.mouseY, slotIndex);
                        if (slotIndex > -1) {
                            boolean flag = slotIndex == this.field_148168_r && Util.func_211177_b() - this.field_148167_s < 250L;
                            this.mouseClicked(slotIndex, this.mouseX, this.mouseY);
                            this.field_148168_r = slotIndex;
                            this.field_148167_s = Util.func_211177_b();
                        } else if (this.mouseX >= i2 && this.mouseX <= j2 && relativeMouseY < 0.0) {
                            this.func_148132_a(this.mouseX - i2, this.mouseY - this.field_148153_b + (int)this.field_148169_q - 4);
                            flag1 = false;
                        }
                        int i3 = this.func_148137_d();
                        int j1 = i3 + 6;
                        if (this.mouseX >= i3 && this.mouseX <= j1) {
                            this.scrollMultiplier = -1.0f;
                            int maxScroll = this.func_148135_f();
                            if (maxScroll < 1) {
                                maxScroll = 1;
                            }
                            int l1 = (int)((float)((this.field_148154_c - this.field_148153_b) * (this.field_148154_c - this.field_148153_b)) / (float)this.func_148138_e());
                            l1 = MathHelper.func_76125_a((int)l1, (int)32, (int)(this.field_148154_c - this.field_148153_b - 8));
                            this.scrollMultiplier /= (float)(this.field_148154_c - this.field_148153_b - l1) / (float)maxScroll;
                        } else {
                            this.scrollMultiplier = 1.0f;
                        }
                        this.field_148157_o = flag1 ? this.mouseY : -2;
                    } else {
                        this.field_148157_o = -2;
                    }
                } else if (this.field_148157_o >= 0) {
                    this.field_148169_q -= (double)((float)(this.mouseY - this.field_148157_o) * this.scrollMultiplier);
                    this.field_148157_o = this.mouseY;
                }
            } else {
                this.field_148157_o = -1;
            }
        }
    }

    @SubscribeEvent
    public void mouseScrolled(GuiScreenEvent.MouseScrollEvent.Pre event) {
        double scrollDelta = event.getScrollDelta();
        if (scrollDelta != 0.0) {
            if (scrollDelta > 0.0) {
                scrollDelta = -1.0;
            } else if (scrollDelta < 0.0) {
                scrollDelta = 1.0;
            }
            this.field_148169_q += (double)((float)(scrollDelta * (double)this.field_148149_f / 2.0));
        }
    }

    protected void func_192638_a(int insideLeft, int insideTop, int mouseXIn, int mouseYIn, float partialTicks) {
        int insideHeight;
        int size = this.func_148127_b();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        int y = this.field_148160_j + insideTop;
        int contentHeight = this.func_148138_e();
        if (contentHeight < (insideHeight = this.field_148154_c - this.field_148153_b - 4)) {
            y += (insideHeight - contentHeight) / 2;
        }
        for (int i = 0; i < size; ++i) {
            int entryHeight = this.listEntries.get(i).getHeight();
            int entryHeight2 = entryHeight - 4;
            if (y > this.field_148154_c || y + entryHeight2 < this.field_148153_b) {
                this.func_192639_a(i, insideLeft, y, partialTicks);
            }
            if (this.field_148166_t && this.func_148131_a(i)) {
                int i1 = this.field_148152_e + this.field_148155_a / 2 - this.func_148139_c() / 2;
                int j1 = this.field_148152_e + this.field_148155_a / 2 + this.func_148139_c() / 2;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179090_x();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)i1, (double)(y + entryHeight2 + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j1, (double)(y + entryHeight2 + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)j1, (double)(y - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)i1, (double)(y - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(i1 + 1), (double)(y + entryHeight2 + 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(j1 - 1), (double)(y + entryHeight2 + 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(j1 - 1), (double)(y - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(i1 + 1), (double)(y - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
            }
            this.func_192637_a(i, insideLeft, y, entryHeight2, mouseXIn, mouseYIn, partialTicks);
            y += entryHeight;
        }
    }

    private double getRelativeMouseX(double mouseX) {
        int j = this.field_148152_e + this.field_148155_a / 2 - this.func_148139_c() / 2 + 2;
        return mouseX - (double)j;
    }

    private double getRelativeMouseY(double mouseY, int contentIndex) {
        int insideHeight;
        int k = this.field_148153_b + 4 - this.func_148148_g() + this.getContentHeight(contentIndex) + this.field_148160_j;
        double relativeMouseY = mouseY - (double)k;
        int contentHeight = this.func_148138_e();
        if (contentHeight < (insideHeight = this.field_148154_c - this.field_148153_b - 4)) {
            relativeMouseY -= (double)((insideHeight - contentHeight) / 2);
        }
        return relativeMouseY;
    }

    public int initGui(int id, List<GuiButton> buttonList) {
        for (IScrollEntry entry : this.listEntries) {
            id = entry.initGui(id, buttonList);
        }
        return id;
    }

    public void updateScreen() {
        for (IScrollEntry entry : this.listEntries) {
            entry.updateScreen();
        }
    }

    public void drawTooltip(GuiScreen guiScreen, int mouseX, int mouseY) {
        for (IScrollEntry entry : this.listEntries) {
            entry.drawTooltip(guiScreen, mouseX, mouseY);
        }
    }

    public boolean charTyped(char eventChar, int eventKey) {
        for (IScrollEntry entry : this.listEntries) {
            entry.charTyped(eventChar, eventKey);
        }
        return false;
    }

    public void onGuiClosed() {
        for (IScrollEntry entry : this.listEntries) {
            entry.onGuiClosed();
        }
    }

    public static interface IScrollEntry {
        public int initGui(int var1, List<GuiButton> var2);

        public void updateScreen();

        public void drawTooltip(GuiScreen var1, int var2, int var3);

        public boolean charTyped(char var1, int var2);

        public void onGuiClosed();

        public int getHeight();

        public void updatePosition(int var1, int var2, int var3, float var4);

        public void drawEntry(int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public boolean mousePressed(int var1, int var2, int var3, int var4, int var5, int var6);

        public void mouseReleased(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

