/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.helper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;

public class SurvivalHelper {
    public static boolean placeBlock(World world, EntityPlayer player, BlockPos pos, IBlockState blockState, ItemStack origstack, EnumFacing facing, Vec3d hitVec, boolean skipPlaceCheck, boolean skipCollisionCheck, boolean playSound) {
        if (!world.func_175668_a(pos, true)) {
            return false;
        }
        ItemStack itemstack = origstack;
        if (blockState.func_177230_c().isAir(blockState, (IBlockReader)world, pos) || itemstack.func_190926_b()) {
            SurvivalHelper.dropBlock(world, player, pos);
            world.func_175698_g(pos);
            return true;
        }
        if (CompatHelper.isItemBlockProxy(itemstack)) {
            itemstack = CompatHelper.getItemBlockByState(itemstack, blockState);
        }
        if (!(itemstack.func_77973_b() instanceof ItemBlock)) {
            return false;
        }
        Block block = ((ItemBlock)itemstack.func_77973_b()).func_179223_d();
        if (skipPlaceCheck || SurvivalHelper.canPlace(world, player, pos, blockState, itemstack, skipCollisionCheck, facing.func_176734_d())) {
            SurvivalHelper.dropBlock(world, player, pos);
            world.func_180501_a(pos, blockState, 3);
            IBlockState afterState = world.func_180495_p(pos);
            if (playSound) {
                SoundType soundtype = afterState.func_177230_c().getSoundType(afterState, (IWorldReader)world, pos, (Entity)player);
                world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            }
            if (!player.func_184812_l_() && Block.func_149634_a((Item)itemstack.func_77973_b()) == block) {
                CompatHelper.shrinkStack(origstack, itemstack, player);
            }
            return true;
        }
        return false;
    }

    public static boolean breakBlock(World world, EntityPlayer player, BlockPos pos, boolean skipChecks) {
        if (!world.func_175668_a(pos, false)) {
            return false;
        }
        if (skipChecks || SurvivalHelper.canBreak(world, player, pos)) {
            SurvivalHelper.dropBlock(world, player, pos);
            player.func_184614_ca().func_179548_a(world, world.func_180495_p(pos), pos, player);
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    public static void dropBlock(World world, EntityPlayer player, BlockPos pos) {
        if (player.func_184812_l_()) {
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        block.func_180657_a(world, player, pos, blockState, world.func_175625_s(pos), player.func_184614_ca());
    }

    public static boolean canPlace(World world, EntityPlayer player, BlockPos pos, IBlockState newBlockState, ItemStack itemStack, boolean skipCollisionCheck, EnumFacing sidePlacedOn) {
        if (!(itemStack.func_77973_b() instanceof ItemBlock) || Block.func_149634_a((Item)itemStack.func_77973_b()) != newBlockState.func_177230_c()) {
            return false;
        }
        Block block = ((ItemBlock)itemStack.func_77973_b()).func_179223_d();
        return !itemStack.func_190926_b() && SurvivalHelper.canPlayerEdit(player, world, pos, itemStack) && SurvivalHelper.mayPlace(world, block, newBlockState, pos, skipCollisionCheck, sidePlacedOn, (Entity)player) && SurvivalHelper.canReplace(world, player, pos);
    }

    private static boolean canReplace(World world, EntityPlayer player, BlockPos pos) {
        if (player.func_184812_l_()) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        switch ((Integer)BuildConfig.survivalBalancers.quickReplaceMiningLevel.get()) {
            case -1: {
                return state.func_185904_a().func_76229_l();
            }
            case 0: {
                return state.func_177230_c().getHarvestLevel(state) <= 0;
            }
            case 1: {
                return state.func_177230_c().getHarvestLevel(state) <= 1;
            }
            case 2: {
                return state.func_177230_c().getHarvestLevel(state) <= 2;
            }
            case 3: {
                return state.func_177230_c().getHarvestLevel(state) <= 3;
            }
        }
        return false;
    }

    private static boolean canPlayerEdit(EntityPlayer player, World world, BlockPos pos, ItemStack stack) {
        if (!world.func_175660_a(player, pos)) {
            return false;
        }
        if (player.field_71075_bZ.field_75099_e) {
            return true;
        }
        BlockWorldState blockworldstate = new BlockWorldState((IWorldReaderBase)world, pos, false);
        return stack.func_206847_b(world.func_205772_D(), blockworldstate);
    }

    private static boolean mayPlace(World world, Block blockIn, IBlockState newBlockState, BlockPos pos, boolean skipCollisionCheck, EnumFacing sidePlacedOn, @Nullable Entity placer) {
        VoxelShape voxelShape;
        IBlockState iblockstate1 = world.func_180495_p(pos);
        VoxelShape voxelShape2 = voxelShape = skipCollisionCheck ? null : blockIn.func_176223_P().func_196952_d((IBlockReader)world, pos);
        if (voxelShape != null && !world.func_195584_a(iblockstate1, pos)) {
            return false;
        }
        if (placer != null && SurvivalHelper.doesBecomeDoubleSlab((EntityPlayer)placer, pos, sidePlacedOn)) {
            return true;
        }
        if (iblockstate1 == newBlockState) {
            return false;
        }
        if (iblockstate1.func_185904_a() == Material.field_151594_q && blockIn == Blocks.field_150467_bQ) {
            return true;
        }
        if (placer instanceof EntityPlayer && ModifierSettingsManager.getModifierSettings((EntityPlayer)placer).doQuickReplace()) {
            return true;
        }
        return iblockstate1.func_185904_a().func_76222_j();
    }

    public static boolean canBreak(World world, EntityPlayer player, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        if (!world.func_204610_c(pos).func_206888_e()) {
            return false;
        }
        if (player.func_184812_l_()) {
            return true;
        }
        return SurvivalHelper.canHarvestBlock(blockState.func_177230_c(), player, world, pos);
    }

    public static boolean canHarvestBlock(@Nonnull Block block, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185887_b((IBlockReader)world, pos) < 0.0f) {
            return false;
        }
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        ToolType tool = block.getHarvestTool(state);
        if (stack.func_190926_b() || tool == null) {
            return player.func_184823_b(state);
        }
        if (stack.func_77952_i() >= stack.func_77958_k()) {
            return false;
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.func_184823_b(state);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    public static boolean doesBecomeDoubleSlab(EntityPlayer player, BlockPos pos, EnumFacing facing) {
        IBlockState placedBlockState = player.field_70170_p.func_180495_p(pos);
        ItemStack itemstack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (CompatHelper.isItemBlockProxy(itemstack)) {
            itemstack = CompatHelper.getItemBlockFromStack(itemstack);
        }
        if (itemstack.func_190926_b() || !(itemstack.func_77973_b() instanceof ItemBlock) || !(((ItemBlock)itemstack.func_77973_b()).func_179223_d() instanceof BlockSlab)) {
            return false;
        }
        BlockSlab heldSlab = (BlockSlab)((ItemBlock)itemstack.func_77973_b()).func_179223_d();
        if (placedBlockState.func_177230_c() == heldSlab) {
            // empty if block
        }
        return false;
    }
}

