/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.item;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.capability.ItemHandlerCapabilityProvider;
import nl.requios.effortlessbuilding.gui.RandomizerBagGuiHandler;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;

public class ItemRandomizerBag
extends Item {
    public static final int INV_SIZE = 5;
    private static long currentSeed = 1337L;
    private static Random rand = new Random(currentSeed);

    public ItemRandomizerBag() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200917_a(1));
        this.setRegistryName("effortlessbuilding", "randomizer_bag");
    }

    public EnumActionResult func_195939_a(ItemUseContext ctx) {
        EntityPlayer player = ctx.func_195999_j();
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        EnumFacing facing = ctx.func_196000_l();
        ItemStack item = ctx.func_195996_i();
        if (player == null) {
            return EnumActionResult.FAIL;
        }
        if (ctx.func_195998_g()) {
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new RandomizerBagGuiHandler());
        } else {
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            BuildModes.BuildModeEnum buildMode = ModeSettingsManager.getModeSettings(player).getBuildMode();
            ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings(player);
            if (buildMode != BuildModes.BuildModeEnum.NORMAL || modifierSettings.doQuickReplace()) {
                return EnumActionResult.FAIL;
            }
            ItemStack bag = player.func_184586_b(EnumHand.MAIN_HAND);
            IItemHandler bagInventory = ItemRandomizerBag.getBagInventory(bag);
            if (bagInventory == null) {
                return EnumActionResult.FAIL;
            }
            ItemStack toPlace = ItemRandomizerBag.pickRandomStack(bagInventory);
            if (toPlace.func_190926_b()) {
                return EnumActionResult.FAIL;
            }
            if (!world.func_180495_p(pos).func_177230_c().func_149688_o(world.func_180495_p(pos)).func_76222_j()) {
                pos = pos.func_177972_a(facing);
            }
            BlockItemUseContext blockItemUseContext = new BlockItemUseContext(world, player, item, pos, facing, ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o());
            IBlockState blockState = Block.func_149634_a((Item)toPlace.func_77973_b()).func_196258_a(blockItemUseContext);
            SurvivalHelper.placeBlock(world, player, pos, blockState, toPlace, facing, new Vec3d((double)ctx.func_195997_m(), (double)ctx.func_195993_n(), (double)ctx.func_195994_o()), false, false, true);
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack bag = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (world.field_72995_K) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)bag);
            }
        } else {
            IItemHandler bagInventory = ItemRandomizerBag.getBagInventory(bag);
            if (bagInventory == null) {
                return new ActionResult(EnumActionResult.FAIL, (Object)bag);
            }
            ItemStack toUse = ItemRandomizerBag.pickRandomStack(bagInventory);
            if (toUse.func_190926_b()) {
                return new ActionResult(EnumActionResult.FAIL, (Object)bag);
            }
            return toUse.func_77957_a(world, player, hand);
        }
        NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new RandomizerBagGuiHandler());
        return new ActionResult(EnumActionResult.PASS, (Object)bag);
    }

    public static IItemHandler getBagInventory(ItemStack bag) {
        return (IItemHandler)bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
    }

    public static ItemStack pickRandomStack(IItemHandler bagInventory) {
        int nonempty = 0;
        ArrayList<ItemStack> nonEmptyStacks = new ArrayList<ItemStack>(5);
        ArrayList<Integer> originalSlots = new ArrayList<Integer>(5);
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack stack = bagInventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ++nonempty;
            nonEmptyStacks.add(stack);
            originalSlots.add(i);
        }
        if (nonEmptyStacks.size() != originalSlots.size()) {
            throw new Error("NonEmptyStacks and OriginalSlots not same size");
        }
        if (nonempty == 0) {
            return ItemStack.field_190927_a;
        }
        int randomSlot = rand.nextInt(nonempty);
        if (randomSlot < 0 || randomSlot > bagInventory.getSlots()) {
            return ItemStack.field_190927_a;
        }
        int originalSlot = (Integer)originalSlots.get(randomSlot);
        if (originalSlot < 0 || originalSlot > bagInventory.getSlots()) {
            return ItemStack.field_190927_a;
        }
        return bagInventory.getStackInSlot(originalSlot);
    }

    public static ItemStack findStack(IItemHandler bagInventory, Item item) {
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack stack = bagInventory.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 1;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ItemHandlerCapabilityProvider();
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TextComponentString(TextFormatting.BLUE + "Rightclick" + TextFormatting.GRAY + " to place a random block"));
        tooltip.add((ITextComponent)new TextComponentString(TextFormatting.BLUE + "Sneak + rightclick" + TextFormatting.GRAY + " to open inventory"));
    }

    public String func_77658_a() {
        return this.getRegistryName().toString();
    }

    public static void resetRandomness() {
        rand.setSeed(currentSeed);
    }

    public static void renewRandomness() {
        currentSeed = Calendar.getInstance().getTimeInMillis();
        rand.setSeed(currentSeed);
    }
}

