/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmodifier.BlockSet;
import nl.requios.effortlessbuilding.buildmodifier.UndoRedo;

public class AddUndoMessage {
    private BlockPos coordinate;
    private IBlockState previousBlockState;
    private IBlockState newBlockState;

    public AddUndoMessage() {
        this.coordinate = BlockPos.field_177992_a;
        this.previousBlockState = null;
        this.newBlockState = null;
    }

    public AddUndoMessage(BlockPos coordinate, IBlockState previousBlockState, IBlockState newBlockState) {
        this.coordinate = coordinate;
        this.previousBlockState = previousBlockState;
        this.newBlockState = newBlockState;
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public IBlockState getPreviousBlockState() {
        return this.previousBlockState;
    }

    public IBlockState getNewBlockState() {
        return this.newBlockState;
    }

    public static void encode(AddUndoMessage message, PacketBuffer buf) {
        buf.writeInt(message.coordinate.func_177958_n());
        buf.writeInt(message.coordinate.func_177956_o());
        buf.writeInt(message.coordinate.func_177952_p());
        buf.writeInt(Block.func_196246_j((IBlockState)message.previousBlockState));
        buf.writeInt(Block.func_196246_j((IBlockState)message.newBlockState));
    }

    public static AddUndoMessage decode(PacketBuffer buf) {
        BlockPos coordinate = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        IBlockState previousBlockState = Block.func_196257_b((int)buf.readInt());
        IBlockState newBlockState = Block.func_196257_b((int)buf.readInt());
        return new AddUndoMessage(coordinate, previousBlockState, newBlockState);
    }

    public static class Handler {
        public static void handle(final AddUndoMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    EntityPlayer player = EffortlessBuilding.proxy.getPlayerEntityFromContext(ctx);
                    UndoRedo.addUndo((EntityPlayer)((NetworkEvent.Context)ctx.get()).getSender(), new BlockSet((List<BlockPos>)new ArrayList<BlockPos>(){
                        {
                            this.add(message.getCoordinate());
                        }
                    }, (List<IBlockState>)new ArrayList<IBlockState>(){
                        {
                            this.add(message.getPreviousBlockState());
                        }
                    }, (List<IBlockState>)new ArrayList<IBlockState>(){
                        {
                            this.add(message.getNewBlockState());
                        }
                    }, new Vec3d(0.0, 0.0, 0.0), message.getCoordinate(), message.getCoordinate()));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

