/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import nl.requios.effortlessbuilding.buildmode.BuildModes;

public class BlockBrokenMessage {
    private boolean blockHit;
    private BlockPos blockPos;
    private EnumFacing sideHit;
    private Vec3d hitVec;

    public BlockBrokenMessage() {
        this.blockHit = false;
        this.blockPos = BlockPos.field_177992_a;
        this.sideHit = EnumFacing.UP;
        this.hitVec = new Vec3d(0.0, 0.0, 0.0);
    }

    public BlockBrokenMessage(RayTraceResult result) {
        this.blockHit = result.field_72313_a == RayTraceResult.Type.BLOCK;
        this.blockPos = result.func_178782_a();
        this.sideHit = result.field_178784_b;
        this.hitVec = result.field_72307_f;
    }

    public BlockBrokenMessage(boolean blockHit, BlockPos blockPos, EnumFacing sideHit, Vec3d hitVec) {
        this.blockHit = blockHit;
        this.blockPos = blockPos;
        this.sideHit = sideHit;
        this.hitVec = hitVec;
    }

    public boolean isBlockHit() {
        return this.blockHit;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public EnumFacing getSideHit() {
        return this.sideHit;
    }

    public Vec3d getHitVec() {
        return this.hitVec;
    }

    public static void encode(BlockBrokenMessage message, PacketBuffer buf) {
        buf.writeBoolean(message.blockHit);
        buf.writeInt(message.blockPos.func_177958_n());
        buf.writeInt(message.blockPos.func_177956_o());
        buf.writeInt(message.blockPos.func_177952_p());
        buf.writeInt(message.sideHit.func_176745_a());
        buf.writeDouble(message.hitVec.field_72450_a);
        buf.writeDouble(message.hitVec.field_72448_b);
        buf.writeDouble(message.hitVec.field_72449_c);
    }

    public static BlockBrokenMessage decode(PacketBuffer buf) {
        boolean blockHit = buf.readBoolean();
        BlockPos blockPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        EnumFacing sideHit = EnumFacing.func_82600_a((int)buf.readInt());
        Vec3d hitVec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        return new BlockBrokenMessage(blockHit, blockPos, sideHit, hitVec);
    }

    public static class Handler {
        public static void handle(BlockBrokenMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.SERVER) {
                    BuildModes.onBlockBrokenMessage((EntityPlayer)((NetworkEvent.Context)ctx.get()).getSender(), message);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

