/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;

public class ModeSettingsMessage {
    private ModeSettingsManager.ModeSettings modeSettings;

    public ModeSettingsMessage() {
    }

    public ModeSettingsMessage(ModeSettingsManager.ModeSettings modeSettings) {
        this.modeSettings = modeSettings;
    }

    public static void encode(ModeSettingsMessage message, PacketBuffer buf) {
        buf.writeInt(message.modeSettings.getBuildMode().ordinal());
    }

    public static ModeSettingsMessage decode(PacketBuffer buf) {
        BuildModes.BuildModeEnum buildMode = BuildModes.BuildModeEnum.values()[buf.readInt()];
        return new ModeSettingsMessage(new ModeSettingsManager.ModeSettings(buildMode));
    }

    public static class Handler {
        public static void handle(ModeSettingsMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                EntityPlayer player = EffortlessBuilding.proxy.getPlayerEntityFromContext(ctx);
                ModeSettingsManager.sanitize(message.modeSettings, player);
                ModeSettingsManager.setModeSettings(player, message.modeSettings);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

