/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.network.BlockPlacedMessage;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.proxy.ClientProxy;

public class RequestLookAtMessage {
    private boolean placeStartPos;

    public RequestLookAtMessage() {
        this.placeStartPos = false;
    }

    public RequestLookAtMessage(boolean placeStartPos) {
        this.placeStartPos = placeStartPos;
    }

    public boolean getPlaceStartPos() {
        return this.placeStartPos;
    }

    public static void encode(RequestLookAtMessage message, PacketBuffer buf) {
        buf.writeBoolean(message.placeStartPos);
    }

    public static RequestLookAtMessage decode(PacketBuffer buf) {
        boolean placeStartPos = buf.readBoolean();
        return new RequestLookAtMessage(placeStartPos);
    }

    public static class Handler {
        public static void handle(RequestLookAtMessage message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    EntityPlayer player = EffortlessBuilding.proxy.getPlayerEntityFromContext(ctx);
                    PacketHandler.INSTANCE.sendToServer((Object)new BlockPlacedMessage(ClientProxy.previousLookAt, message.getPlaceStartPos()));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

