/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.BuildConfig;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.IBuildMode;
import nl.requios.effortlessbuilding.buildmode.ModeSettingsManager;
import nl.requios.effortlessbuilding.buildmodifier.BuildModifiers;
import nl.requios.effortlessbuilding.buildmodifier.ModifierSettingsManager;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.helper.ReachHelper;
import nl.requios.effortlessbuilding.helper.SurvivalHelper;
import nl.requios.effortlessbuilding.item.ItemRandomizerBag;
import nl.requios.effortlessbuilding.proxy.ClientProxy;
import nl.requios.effortlessbuilding.render.RenderHandler;
import nl.requios.effortlessbuilding.render.ShaderHandler;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class BlockPreviewRenderer {
    private static List<BlockPos> previousCoordinates;
    private static List<IBlockState> previousBlockStates;
    private static List<ItemStack> previousItemStacks;
    private static BlockPos previousFirstPos;
    private static BlockPos previousSecondPos;
    private static int soundTime;
    private static List<PlacedData> placedDataList;
    private static final int primaryTextureUnit = 0;
    private static final int secondaryTextureUnit = 2;

    public static void render(EntityPlayer player, ModifierSettingsManager.ModifierSettings modifierSettings, ModeSettingsManager.ModeSettings modeSettings) {
        ItemStack mainhand;
        if (((Boolean)BuildConfig.visuals.useShaders.get()).booleanValue()) {
            RenderHandler.beginBlockPreviews();
            for (int i = 0; i < placedDataList.size(); ++i) {
                PlacedData placed2 = placedDataList.get(i);
                if (placed2.coordinates == null || placed2.coordinates.isEmpty()) continue;
                double totalTime = MathHelper.func_151238_b((double)30.0, (double)60.0, (double)(placed2.firstPos.func_177951_i((Vec3i)placed2.secondPos) / 100.0)) * (Double)BuildConfig.visuals.dissolveTimeMultiplier.get();
                float dissolve = ((float)ClientProxy.ticksInGame - placed2.time) / (float)totalTime;
                BlockPreviewRenderer.renderBlockPreviews(placed2.coordinates, placed2.blockStates, placed2.itemStacks, dissolve, placed2.firstPos, placed2.secondPos, false, placed2.breaking);
            }
            RenderHandler.endBlockPreviews();
        }
        placedDataList.removeIf(placed -> {
            double totalTime = MathHelper.func_151238_b((double)30.0, (double)60.0, (double)(placed.firstPos.func_177951_i((Vec3i)placed.secondPos) / 100.0)) * (Double)BuildConfig.visuals.dissolveTimeMultiplier.get();
            return (double)placed.time + totalTime < (double)ClientProxy.ticksInGame;
        });
        RayTraceResult lookingAt = ClientProxy.getLookingAt(player);
        if (modeSettings.getBuildMode() == BuildModes.BuildModeEnum.NORMAL) {
            lookingAt = Minecraft.func_71410_x().field_71476_x;
        }
        boolean toolInHand = (mainhand = player.func_184614_ca()).func_190926_b() || !CompatHelper.isItemBlockProxy(mainhand);
        BlockPos startPos = null;
        EnumFacing sideHit = null;
        Vec3d hitVec = null;
        if (lookingAt != null && lookingAt.field_72313_a == RayTraceResult.Type.BLOCK) {
            startPos = lookingAt.func_178782_a();
            boolean replaceable = player.field_70170_p.func_180495_p(startPos).func_177230_c().func_149688_o(player.field_70170_p.func_180495_p(startPos)).func_76222_j();
            boolean becomesDoubleSlab = SurvivalHelper.doesBecomeDoubleSlab(player, startPos, lookingAt.field_178784_b);
            if (!(modifierSettings.doQuickReplace() || toolInHand || replaceable || becomesDoubleSlab)) {
                startPos = startPos.func_177972_a(lookingAt.field_178784_b);
            }
            if (modifierSettings.doQuickReplace() && !toolInHand && replaceable) {
                startPos = startPos.func_177977_b();
            }
            sideHit = lookingAt.field_178784_b;
            hitVec = lookingAt.field_72307_f;
        }
        if (BlockPreviewRenderer.doRenderBlockPreviews(modifierSettings, modeSettings, startPos)) {
            RayTraceResult breakingRaytrace;
            if (BuildModes.isActive(player)) {
                IBuildMode buildModeInstance = modeSettings.getBuildMode().instance;
                if (buildModeInstance.getSideHit(player) != null) {
                    sideHit = buildModeInstance.getSideHit(player);
                }
                if (buildModeInstance.getHitVec(player) != null) {
                    hitVec = buildModeInstance.getHitVec(player);
                }
            }
            if (sideHit != null) {
                boolean breaking = BuildModes.currentlyBreakingClient.get(player) != null && BuildModes.currentlyBreakingClient.get(player) != false;
                List<BlockPos> startCoordinates = BuildModes.findCoordinates(player, startPos, breaking || modifierSettings.doQuickReplace());
                BlockPos firstPos = BlockPos.field_177992_a;
                BlockPos secondPos = BlockPos.field_177992_a;
                if (!startCoordinates.isEmpty()) {
                    firstPos = startCoordinates.get(0);
                    secondPos = startCoordinates.get(startCoordinates.size() - 1);
                }
                int limit = ReachHelper.getMaxBlocksPlacedAtOnce(player);
                if (startCoordinates.size() > limit) {
                    startCoordinates = startCoordinates.subList(0, limit);
                }
                List<BlockPos> newCoordinates = BuildModifiers.findCoordinates(player, startCoordinates);
                BlockPreviewRenderer.sortOnDistanceToPlayer(newCoordinates, player);
                hitVec = new Vec3d(Math.abs(hitVec.field_72450_a - (double)((int)hitVec.field_72450_a)), Math.abs(hitVec.field_72448_b - (double)((int)hitVec.field_72448_b)), Math.abs(hitVec.field_72449_c - (double)((int)hitVec.field_72449_c)));
                ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
                List<Object> blockStates = new ArrayList();
                if (breaking) {
                    for (BlockPos coordinate : newCoordinates) {
                        blockStates.add(player.field_70170_p.func_180495_p(coordinate));
                    }
                } else {
                    blockStates = BuildModifiers.findBlockStates(player, startCoordinates, hitVec, sideHit, itemStacks);
                }
                if (!BuildModifiers.compareCoordinates(previousCoordinates, newCoordinates)) {
                    previousCoordinates = newCoordinates;
                    previousBlockStates = blockStates;
                    previousItemStacks = itemStacks;
                    previousFirstPos = firstPos;
                    previousSecondPos = secondPos;
                    ItemRandomizerBag.renewRandomness();
                    if (newCoordinates.size() > 1 && blockStates.size() > 1 && soundTime < ClientProxy.ticksInGame - 0) {
                        soundTime = ClientProxy.ticksInGame;
                        if (blockStates.get(0) != null) {
                            SoundType soundType = ((IBlockState)blockStates.get(0)).func_177230_c().getSoundType((IBlockState)blockStates.get(0), (IWorldReader)player.field_70170_p, newCoordinates.get(0), (Entity)player);
                            player.field_70170_p.func_184133_a(player, player.func_180425_c(), breaking ? soundType.func_185845_c() : soundType.func_185841_e(), SoundCategory.BLOCKS, 0.3f, 0.8f);
                        }
                    }
                }
                if (blockStates.size() != 0 && newCoordinates.size() == blockStates.size()) {
                    int blockCount;
                    if (((Boolean)BuildConfig.visuals.useShaders.get()).booleanValue() && newCoordinates.size() < (Integer)BuildConfig.visuals.shaderTreshold.get()) {
                        RenderHandler.beginBlockPreviews();
                        blockCount = BlockPreviewRenderer.renderBlockPreviews(newCoordinates, blockStates, itemStacks, 0.0f, firstPos, secondPos, !breaking, breaking);
                        RenderHandler.endBlockPreviews();
                    } else {
                        RenderHandler.beginLines();
                        Vec3d color = new Vec3d(1.0, 1.0, 1.0);
                        if (breaking) {
                            color = new Vec3d(1.0, 0.0, 0.0);
                        }
                        for (int i = newCoordinates.size() - 1; i >= 0; --i) {
                            VoxelShape collisionShape = ((IBlockState)blockStates.get(i)).func_196952_d((IBlockReader)player.field_70170_p, newCoordinates.get(i));
                            RenderHandler.renderBlockOutline(newCoordinates.get(i), collisionShape, color);
                        }
                        RenderHandler.endLines();
                        blockCount = newCoordinates.size();
                    }
                    if (BuildModes.isActive(player)) {
                        int minX = Integer.MAX_VALUE;
                        int maxX = Integer.MIN_VALUE;
                        int minY = Integer.MAX_VALUE;
                        int maxY = Integer.MIN_VALUE;
                        int minZ = Integer.MAX_VALUE;
                        int maxZ = Integer.MIN_VALUE;
                        for (BlockPos pos : startCoordinates) {
                            if (pos.func_177958_n() < minX) {
                                minX = pos.func_177958_n();
                            }
                            if (pos.func_177958_n() > maxX) {
                                maxX = pos.func_177958_n();
                            }
                            if (pos.func_177956_o() < minY) {
                                minY = pos.func_177956_o();
                            }
                            if (pos.func_177956_o() > maxY) {
                                maxY = pos.func_177956_o();
                            }
                            if (pos.func_177952_p() < minZ) {
                                minZ = pos.func_177952_p();
                            }
                            if (pos.func_177952_p() <= maxZ) continue;
                            maxZ = pos.func_177952_p();
                        }
                        BlockPos dim = new BlockPos(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
                        String dimensions = "(";
                        if (dim.func_177958_n() > 1) {
                            dimensions = dimensions + dim.func_177958_n() + "x";
                        }
                        if (dim.func_177952_p() > 1) {
                            dimensions = dimensions + dim.func_177952_p() + "x";
                        }
                        if (dim.func_177956_o() > 1) {
                            dimensions = dimensions + dim.func_177956_o() + "x";
                        }
                        if ((dimensions = dimensions.substring(0, dimensions.length() - 1)).length() > 1) {
                            dimensions = dimensions + ")";
                        }
                        EffortlessBuilding.log(player, blockCount + " blocks " + dimensions, true);
                    }
                }
            }
            RenderHandler.beginLines();
            RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
            RayTraceResult rayTraceResult = breakingRaytrace = ReachHelper.canBreakFar(player) ? lookingAt : objectMouseOver;
            if (toolInHand && breakingRaytrace != null && breakingRaytrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                int i;
                List<BlockPos> breakCoordinates = BuildModifiers.findCoordinates(player, breakingRaytrace.func_178782_a());
                boolean excludeFirst = objectMouseOver != null && objectMouseOver.field_72313_a == RayTraceResult.Type.BLOCK;
                int n = i = excludeFirst ? 1 : 0;
                while (i < breakCoordinates.size()) {
                    BlockPos coordinate = breakCoordinates.get(i);
                    IBlockState blockState = player.field_70170_p.func_180495_p(coordinate);
                    if (!blockState.func_177230_c().isAir(blockState, (IBlockReader)player.field_70170_p, coordinate) && (SurvivalHelper.canBreak(player.field_70170_p, player, coordinate) || i == 0)) {
                        VoxelShape collisionShape = blockState.func_196952_d((IBlockReader)player.field_70170_p, coordinate);
                        RenderHandler.renderBlockOutline(coordinate, collisionShape, new Vec3d(0.0, 0.0, 0.0));
                    }
                    ++i;
                }
            }
            RenderHandler.endLines();
        }
    }

    public static boolean doRenderBlockPreviews(ModifierSettingsManager.ModifierSettings modifierSettings, ModeSettingsManager.ModeSettings modeSettings, BlockPos startPos) {
        return modeSettings.getBuildMode() != BuildModes.BuildModeEnum.NORMAL || startPos != null && BuildModifiers.isEnabled(modifierSettings, startPos) || (Boolean)BuildConfig.visuals.alwaysShowBlockPreview.get() != false;
    }

    protected static int renderBlockPreviews(List<BlockPos> coordinates, List<IBlockState> blockStates, List<ItemStack> itemStacks, float dissolve, BlockPos firstPos, BlockPos secondPos, boolean checkCanPlace, boolean red) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((EntityPlayer)player);
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        int blocksValid = 0;
        if (coordinates.isEmpty()) {
            return blocksValid;
        }
        for (int i = coordinates.size() - 1; i >= 0; --i) {
            ItemStack itemstack;
            BlockPos blockPos = coordinates.get(i);
            IBlockState blockState = blockStates.get(i);
            ItemStack itemStack = itemstack = itemStacks.isEmpty() ? ItemStack.field_190927_a : itemStacks.get(i);
            if (CompatHelper.isItemBlockProxy(itemstack)) {
                itemstack = CompatHelper.getItemBlockByState(itemstack, blockState);
            }
            if (checkCanPlace && !SurvivalHelper.canPlace(player.field_70170_p, (EntityPlayer)player, blockPos, blockState, itemstack, modifierSettings.doQuickReplace(), EnumFacing.UP)) continue;
            ShaderHandler.useShader(ShaderHandler.dissolve, BlockPreviewRenderer.generateShaderCallback(dissolve, new Vec3d((Vec3i)blockPos), new Vec3d((Vec3i)firstPos), new Vec3d((Vec3i)secondPos), blockPos == secondPos, red));
            RenderHandler.renderBlockPreview(dispatcher, blockPos, blockState);
            ++blocksValid;
        }
        return blocksValid;
    }

    public static void onBlocksPlaced() {
        BlockPreviewRenderer.onBlocksPlaced(previousCoordinates, previousItemStacks, previousBlockStates, previousFirstPos, previousSecondPos);
    }

    public static void onBlocksPlaced(List<BlockPos> coordinates, List<ItemStack> itemStacks, List<IBlockState> blockStates, BlockPos firstPos, BlockPos secondPos) {
        ModeSettingsManager.ModeSettings modeSettings;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((EntityPlayer)player);
        if (BlockPreviewRenderer.doRenderBlockPreviews(modifierSettings, modeSettings = ModeSettingsManager.getModeSettings((EntityPlayer)player), firstPos) && !coordinates.isEmpty() && blockStates.size() == coordinates.size() && coordinates.size() > 1 && coordinates.size() < (Integer)BuildConfig.visuals.shaderTreshold.get()) {
            placedDataList.add(new PlacedData(ClientProxy.ticksInGame, coordinates, blockStates, itemStacks, firstPos, secondPos, false));
        }
    }

    public static void onBlocksBroken() {
        BlockPreviewRenderer.onBlocksBroken(previousCoordinates, previousItemStacks, previousBlockStates, previousFirstPos, previousSecondPos);
    }

    public static void onBlocksBroken(List<BlockPos> coordinates, List<ItemStack> itemStacks, List<IBlockState> blockStates, BlockPos firstPos, BlockPos secondPos) {
        ModeSettingsManager.ModeSettings modeSettings;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ModifierSettingsManager.ModifierSettings modifierSettings = ModifierSettingsManager.getModifierSettings((EntityPlayer)player);
        if (BlockPreviewRenderer.doRenderBlockPreviews(modifierSettings, modeSettings = ModeSettingsManager.getModeSettings((EntityPlayer)player), firstPos) && !coordinates.isEmpty() && blockStates.size() == coordinates.size() && coordinates.size() > 1 && coordinates.size() < (Integer)BuildConfig.visuals.shaderTreshold.get()) {
            BlockPreviewRenderer.sortOnDistanceToPlayer(coordinates, (EntityPlayer)player);
            placedDataList.add(new PlacedData(ClientProxy.ticksInGame, coordinates, blockStates, itemStacks, firstPos, secondPos, true));
        }
    }

    private static Consumer<Integer> generateShaderCallback(float dissolve, Vec3d blockpos, Vec3d firstpos, Vec3d secondpos, boolean highlight, boolean red) {
        Minecraft mc = Minecraft.func_71410_x();
        return shader -> {
            int percentileUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"dissolve");
            int highlightUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"highlight");
            int redUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"red");
            int blockposUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"blockpos");
            int firstposUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"firstpos");
            int secondposUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"secondpos");
            int imageUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"image");
            int maskUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"mask");
            GlStateManager.func_179098_w();
            GL11.glGetInteger((int)32873);
            ARBShaderObjects.glUniform1iARB((int)maskUniform, (int)2);
            OpenGlHelper.func_77473_a((int)33986);
            GL11.glBindTexture((int)3553, (int)mc.func_110434_K().func_110581_b(ShaderHandler.shaderMaskTextureLocation).func_110552_b());
            ARBShaderObjects.glUniform1iARB((int)imageUniform, (int)0);
            OpenGlHelper.func_77473_a((int)33984);
            GL11.glBindTexture((int)3553, (int)mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_110552_b());
            ARBShaderObjects.glUniform3fARB((int)blockposUniform, (float)((float)blockpos.field_72450_a), (float)((float)blockpos.field_72448_b), (float)((float)blockpos.field_72449_c));
            ARBShaderObjects.glUniform3fARB((int)firstposUniform, (float)((float)firstpos.field_72450_a), (float)((float)firstpos.field_72448_b), (float)((float)firstpos.field_72449_c));
            ARBShaderObjects.glUniform3fARB((int)secondposUniform, (float)((float)secondpos.field_72450_a), (float)((float)secondpos.field_72448_b), (float)((float)secondpos.field_72449_c));
            ARBShaderObjects.glUniform1fARB((int)percentileUniform, (float)dissolve);
            ARBShaderObjects.glUniform1iARB((int)highlightUniform, (int)(highlight ? 1 : 0));
            ARBShaderObjects.glUniform1iARB((int)redUniform, (int)(red ? 1 : 0));
        };
    }

    private static void sortOnDistanceToPlayer(List<BlockPos> coordinates, EntityPlayer player) {
        Collections.sort(coordinates, (lhs, rhs) -> {
            double lhsDistanceToPlayer = new Vec3d((Vec3i)lhs).func_178788_d(player.func_174824_e(1.0f)).func_189985_c();
            double rhsDistanceToPlayer = new Vec3d((Vec3i)rhs).func_178788_d(player.func_174824_e(1.0f)).func_189985_c();
            return (int)Math.signum(lhsDistanceToPlayer - rhsDistanceToPlayer);
        });
    }

    static {
        soundTime = 0;
        placedDataList = new ArrayList<PlacedData>();
    }

    static class PlacedData {
        float time;
        List<BlockPos> coordinates;
        List<IBlockState> blockStates;
        List<ItemStack> itemStacks;
        BlockPos firstPos;
        BlockPos secondPos;
        boolean breaking;

        public PlacedData(float time, List<BlockPos> coordinates, List<IBlockState> blockStates, List<ItemStack> itemStacks, BlockPos firstPos, BlockPos secondPos, boolean breaking) {
            this.time = time;
            this.coordinates = coordinates;
            this.blockStates = blockStates;
            this.itemStacks = itemStacks;
            this.firstPos = firstPos;
            this.secondPos = secondPos;
            this.breaking = breaking;
        }
    }
}

