/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import electroblob.wizardry.EnumElement;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryRegistry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.EntityShield;
import electroblob.wizardry.entity.living.EntitySummonedCreature;
import electroblob.wizardry.packet.PacketCastContinuousSpell;
import electroblob.wizardry.packet.PacketPlayerSync;
import electroblob.wizardry.packet.PacketTransportation;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.spell.None;
import electroblob.wizardry.spell.Spell;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedPlayer
implements IExtendedEntityProperties {
    public static final String name = "WizardryExtendedPlayer";
    private final EntityPlayer player;
    public int damageToApply;
    public int conjuredSwordDuration;
    public int conjuredPickaxeDuration;
    public int conjuredBowDuration;
    public int conjuredArmourDuration;
    public int flamingAxeDuration;
    public int frostAxeDuration;
    public int magicWeaponDuration;
    public int flamingWeaponDuration;
    public int freezingWeaponDuration;
    public boolean hasSpiritWolf;
    public boolean hasSpiritHorse;
    private Spell currentlyCasting;
    private int castingTick;
    private float spellDamageMultiplier;
    private float spellRangeMultiplier;
    private float spellDurationMultiplier;
    private float spellBlastMultiplier;
    public int transportX;
    public int transportY;
    public int transportZ;
    public int transportDimension;
    public int tpTimer;
    public int clairvoyanceX;
    public int clairvoyanceY;
    public int clairvoyanceZ;
    public int clairvoyanceDimension;
    public EntityShield shield;
    public WeakReference<EntitySummonedCreature> selectedMinion;
    public HashSet<Spell> spellsDiscovered;
    private HashSet<UUID> allies;
    public HashSet<String> allyNames;
    private HashSet<UUID> soulboundCreatures;

    public ExtendedPlayer(EntityPlayer player) {
        this.player = player;
        this.damageToApply = 0;
        this.conjuredSwordDuration = 0;
        this.conjuredPickaxeDuration = 0;
        this.conjuredBowDuration = 0;
        this.conjuredArmourDuration = 0;
        this.flamingAxeDuration = 0;
        this.frostAxeDuration = 0;
        this.magicWeaponDuration = 0;
        this.flamingWeaponDuration = 0;
        this.freezingWeaponDuration = 0;
        this.spellsDiscovered = new HashSet();
        this.discoverSpell(WizardryRegistry.magicMissile);
        this.hasSpiritWolf = false;
        this.hasSpiritHorse = false;
        this.currentlyCasting = WizardryRegistry.none;
        this.spellDamageMultiplier = 1.0f;
        this.spellRangeMultiplier = 1.0f;
        this.spellDurationMultiplier = 1.0f;
        this.spellBlastMultiplier = 1.0f;
        this.castingTick = 0;
        this.transportX = -1;
        this.transportY = -1;
        this.transportZ = -1;
        this.transportDimension = 0;
        this.clairvoyanceX = -1;
        this.clairvoyanceY = -1;
        this.clairvoyanceZ = -1;
        this.clairvoyanceDimension = 0;
        this.tpTimer = 0;
        this.allies = new HashSet();
        this.allyNames = new HashSet();
        this.soulboundCreatures = new HashSet();
    }

    public boolean hasSpellBeenDiscovered(Spell spell) {
        return this.spellsDiscovered.contains(spell) || spell instanceof None;
    }

    public void discoverSpell(Spell spell) {
        if (this.spellsDiscovered == null) {
            this.spellsDiscovered = new HashSet();
        }
        if (!(spell instanceof None)) {
            this.spellsDiscovered.add(spell);
        }
        if (this.spellsDiscovered.containsAll(Spell.getSpells(Spell.enabledSpells))) {
            this.player.func_71029_a((StatBase)Wizardry.allSpells);
        }
        for (EnumElement element : EnumElement.values()) {
            if (element == EnumElement.MAGIC || !this.spellsDiscovered.containsAll(Spell.getSpells(new Spell.TierElementFilter(null, element)))) continue;
            this.player.func_71029_a((StatBase)Wizardry.elementMaster);
        }
    }

    public void setStoneLocation(int x, int y, int z, int dimensionID) {
        this.transportX = x;
        this.transportY = y;
        this.transportZ = z;
        this.transportDimension = dimensionID;
    }

    public void setClairvoyancePoint(int x, int y, int z, int dimensionID) {
        this.clairvoyanceX = x;
        this.clairvoyanceY = y;
        this.clairvoyanceZ = z;
        this.clairvoyanceDimension = dimensionID;
    }

    public boolean toggleAlly(EntityPlayer player) {
        if (this.isPlayerAlly(player)) {
            this.allies.remove(player.func_110124_au());
            this.allyNames.remove(player.func_70005_c_());
            return false;
        }
        this.allies.add(player.func_110124_au());
        this.allyNames.add(player.func_70005_c_());
        return true;
    }

    public boolean isPlayerAlly(EntityPlayer player) {
        return this.allies.contains(player.func_110124_au()) || this.player.func_142014_c((EntityLivingBase)player);
    }

    public boolean soulbind(EntityLivingBase target) {
        return this.soulboundCreatures.add(target.func_110124_au());
    }

    public boolean isCreatureSoulbound(EntityPlayer target) {
        return this.soulboundCreatures.contains(target.func_110124_au());
    }

    public void damageAllSoulboundCreatures(float damage) {
        Iterator<UUID> iterator = this.soulboundCreatures.iterator();
        while (iterator.hasNext()) {
            Entity entity = WizardryUtilities.getEntityByUUID(this.player.field_70170_p, iterator.next());
            if (entity == null) {
                iterator.remove();
            }
            if (!(entity instanceof EntityLivingBase) || !entity.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)this.player, MagicDamage.DamageType.MAGIC), damage)) continue;
            this.player.field_70170_p.func_72956_a(entity, "mob.wither.hurt", 1.0f, this.player.field_70170_p.field_73012_v.nextFloat() * 0.2f + 1.0f);
        }
    }

    public void startCastingContinuousSpell(Spell spell, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        this.currentlyCasting = spell;
        this.spellDamageMultiplier = damageMultiplier;
        this.spellRangeMultiplier = rangeMultiplier;
        this.spellDurationMultiplier = durationMultiplier;
        this.spellBlastMultiplier = blastMultiplier;
        if (!this.player.field_70170_p.field_72995_K) {
            PacketCastContinuousSpell.Message message = new PacketCastContinuousSpell.Message(this.player.func_145782_y(), spell.id(), damageMultiplier, rangeMultiplier, blastMultiplier);
            WizardryPacketHandler.net.sendToDimension((IMessage)message, this.player.field_70170_p.field_73011_w.field_76574_g);
        }
    }

    public void stopCastingContinuousSpell() {
        this.currentlyCasting = WizardryRegistry.none;
        this.castingTick = 0;
        this.spellDamageMultiplier = 1.0f;
        this.spellRangeMultiplier = 1.0f;
        this.spellDurationMultiplier = 1.0f;
        this.spellBlastMultiplier = 1.0f;
        if (!this.player.field_70170_p.field_72995_K) {
            PacketCastContinuousSpell.Message message = new PacketCastContinuousSpell.Message(this.player.func_145782_y(), WizardryRegistry.none.id(), 1.0f, 1.0f, 1.0f);
            WizardryPacketHandler.net.sendToDimension((IMessage)message, this.player.field_70170_p.field_73011_w.field_76574_g);
        }
    }

    public boolean isCasting() {
        return this.currentlyCasting != null && this.currentlyCasting != WizardryRegistry.none;
    }

    public Spell currentlyCasting() {
        return this.currentlyCasting;
    }

    public void update(EntityPlayer entityplayer) {
        if (this.selectedMinion != null && this.selectedMinion.get() == null) {
            this.selectedMinion = null;
        }
        Random random = entityplayer.field_70170_p.field_73012_v;
        this.conjuredArmourDuration = entityplayer.field_71071_by.func_146028_b(Wizardry.spectralHelmet) || entityplayer.field_71071_by.func_146028_b(Wizardry.spectralChestplate) || entityplayer.field_71071_by.func_146028_b(Wizardry.spectralLeggings) || entityplayer.field_71071_by.func_146028_b(Wizardry.spectralBoots) || entityplayer.field_71071_by.field_70460_b[3] != null && entityplayer.field_71071_by.field_70460_b[3].func_77973_b() == Wizardry.spectralHelmet || entityplayer.field_71071_by.field_70460_b[2] != null && entityplayer.field_71071_by.field_70460_b[2].func_77973_b() == Wizardry.spectralChestplate || entityplayer.field_71071_by.field_70460_b[1] != null && entityplayer.field_71071_by.field_70460_b[1].func_77973_b() == Wizardry.spectralLeggings || entityplayer.field_71071_by.field_70460_b[0] != null && entityplayer.field_71071_by.field_70460_b[0].func_77973_b() == Wizardry.spectralBoots ? ++this.conjuredArmourDuration : 0;
        if (!entityplayer.field_70170_p.field_72995_K) {
            if (this.tpTimer == 1) {
                entityplayer.func_70634_a((double)this.transportX + 0.5, (double)this.transportY, (double)this.transportZ + 0.5);
                entityplayer.field_70170_p.func_72956_a((Entity)entityplayer, "portal.travel", 1.0f, 1.0f);
                entityplayer.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 50, 0));
                PacketTransportation.Message msg = new PacketTransportation.Message(entityplayer.func_145782_y());
                WizardryPacketHandler.net.sendToDimension((IMessage)msg, entityplayer.field_70170_p.field_73011_w.field_76574_g);
            }
            if (this.tpTimer > 0) {
                --this.tpTimer;
            }
        }
        if (this.currentlyCasting != null && this.currentlyCasting.isContinuous) {
            this.currentlyCasting.cast(this.player.field_70170_p, this.player, this.castingTick++, this.spellDamageMultiplier, this.spellRangeMultiplier, this.spellDurationMultiplier, this.spellBlastMultiplier);
        } else {
            this.castingTick = 0;
        }
    }

    public void onPlayerDeath() {
        this.conjuredSwordDuration = 0;
        this.conjuredPickaxeDuration = 0;
        this.conjuredBowDuration = 0;
        this.conjuredArmourDuration = 0;
        this.flamingAxeDuration = 0;
        this.frostAxeDuration = 0;
        this.magicWeaponDuration = 0;
        this.flamingWeaponDuration = 0;
        this.freezingWeaponDuration = 0;
        this.tpTimer = 0;
        this.soulboundCreatures = new HashSet();
        this.currentlyCasting = WizardryRegistry.none;
        this.castingTick = 0;
        this.spellDamageMultiplier = 1.0f;
        this.spellRangeMultiplier = 1.0f;
        this.spellDurationMultiplier = 1.0f;
        this.spellBlastMultiplier = 1.0f;
    }

    public static String getSaveKey(EntityPlayer player) {
        return player.func_110124_au().toString() + ":" + name;
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(name, (IExtendedEntityProperties)new ExtendedPlayer(player));
    }

    public static final ExtendedPlayer get(EntityPlayer player) {
        return (ExtendedPlayer)player.getExtendedProperties(name);
    }

    public void sync() {
        if (this.player instanceof EntityPlayerMP) {
            int id = -1;
            if (this.selectedMinion != null && this.selectedMinion.get() != null) {
                id = ((EntitySummonedCreature)((Object)this.selectedMinion.get())).func_145782_y();
            }
            PacketPlayerSync.Message msg = new PacketPlayerSync.Message(this.spellsDiscovered, id);
            WizardryPacketHandler.net.sendTo((IMessage)msg, (EntityPlayerMP)this.player);
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a("conjuredSwordDuration", this.conjuredSwordDuration);
        properties.func_74768_a("conjuredPickaxeDuration", this.conjuredPickaxeDuration);
        properties.func_74768_a("conjuredBowDuration", this.conjuredBowDuration);
        properties.func_74768_a("conjuredArmourDuration", this.conjuredArmourDuration);
        properties.func_74768_a("flamingAxeDuration", this.flamingAxeDuration);
        properties.func_74768_a("frostAxeDuration", this.frostAxeDuration);
        properties.func_74768_a("magicWeaponDuration", this.magicWeaponDuration);
        properties.func_74768_a("flamingWeaponDuration", this.flamingWeaponDuration);
        properties.func_74768_a("freezingWeaponDuration", this.freezingWeaponDuration);
        properties.func_74757_a("hasSpiritWolf", this.hasSpiritWolf);
        properties.func_74757_a("hasSpiritHorse", this.hasSpiritHorse);
        properties.func_74768_a("x", this.transportX);
        properties.func_74768_a("y", this.transportY);
        properties.func_74768_a("z", this.transportZ);
        properties.func_74768_a("dimension", this.transportDimension);
        properties.func_74768_a("x2", this.clairvoyanceX);
        properties.func_74768_a("y2", this.clairvoyanceY);
        properties.func_74768_a("z2", this.clairvoyanceZ);
        properties.func_74768_a("dimension2", this.clairvoyanceDimension);
        properties.func_74768_a("tpTimer", this.tpTimer);
        NBTTagList tagList = new NBTTagList();
        for (UUID id : this.allies) {
            tagList.func_74742_a((NBTBase)new NBTTagString(id.toString()));
        }
        properties.func_74782_a("allies", (NBTBase)tagList);
        NBTTagList tagList2 = new NBTTagList();
        for (String name : this.allyNames) {
            tagList2.func_74742_a((NBTBase)new NBTTagString(name));
        }
        properties.func_74782_a("allyNames", (NBTBase)tagList2);
        NBTTagList tagList3 = new NBTTagList();
        for (UUID id : this.soulboundCreatures) {
            tagList3.func_74742_a((NBTBase)new NBTTagString(id.toString()));
        }
        properties.func_74782_a("soulboundCreatures", (NBTBase)tagList3);
        int[] spells = new int[this.spellsDiscovered.size()];
        int i = 0;
        for (Spell spell : this.spellsDiscovered) {
            spells[i] = spell.id();
            ++i;
        }
        properties.func_74783_a("discoveredSpells", spells);
        compound.func_74782_a(name, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(name);
        if (properties != null) {
            this.conjuredSwordDuration = properties.func_74762_e("conjuredSwordDuration");
            this.conjuredPickaxeDuration = properties.func_74762_e("conjuredPickaxeDuration");
            this.conjuredBowDuration = properties.func_74762_e("conjuredBowDuration");
            this.conjuredArmourDuration = properties.func_74762_e("conjuredArmourDuration");
            this.flamingAxeDuration = properties.func_74762_e("flamingAxeDuration");
            this.frostAxeDuration = properties.func_74762_e("frostAxeDuration");
            this.magicWeaponDuration = properties.func_74762_e("magicWeaponDuration");
            this.flamingWeaponDuration = properties.func_74762_e("flamingWeaponDuration");
            this.freezingWeaponDuration = properties.func_74762_e("freezingWeaponDuration");
            this.hasSpiritWolf = properties.func_74767_n("hasSpiritWolf");
            this.hasSpiritHorse = properties.func_74767_n("hasSpiritHorse");
            this.transportX = properties.func_74762_e("x");
            this.transportY = properties.func_74762_e("y");
            this.transportZ = properties.func_74762_e("z");
            this.transportDimension = properties.func_74762_e("dimension");
            this.clairvoyanceX = properties.func_74762_e("x2");
            this.clairvoyanceY = properties.func_74762_e("y2");
            this.clairvoyanceZ = properties.func_74762_e("z2");
            this.clairvoyanceDimension = properties.func_74762_e("dimension2");
            this.tpTimer = properties.func_74762_e("tpTimer");
            this.allies = new HashSet();
            NBTTagList tagList = properties.func_150295_c("allies", 8);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.allies.add(UUID.fromString(tagList.func_150307_f(i)));
            }
            this.allyNames = new HashSet();
            NBTTagList tagList2 = properties.func_150295_c("allyNames", 8);
            for (int i = 0; i < tagList2.func_74745_c(); ++i) {
                this.allyNames.add(tagList2.func_150307_f(i));
            }
            this.soulboundCreatures = new HashSet();
            NBTTagList tagList3 = properties.func_150295_c("soulboundCreatures", 8);
            for (int i = 0; i < tagList3.func_74745_c(); ++i) {
                this.soulboundCreatures.add(UUID.fromString(tagList3.func_150307_f(i)));
            }
            this.spellsDiscovered = new HashSet();
            for (int id : properties.func_74759_k("discoveredSpells")) {
                this.spellsDiscovered.add(Spell.get(id));
            }
        }
    }

    public void init(Entity entity, World world) {
    }
}

