/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import electroblob.wizardry.CommonProxy;
import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.WizardryGuiHandler;
import electroblob.wizardry.WizardryKeyHandler;
import electroblob.wizardry.WizardryRegistry;
import electroblob.wizardry.WizardryWorldGenerator;
import electroblob.wizardry.block.BlockArcaneWorkbench;
import electroblob.wizardry.block.BlockCrystal;
import electroblob.wizardry.block.BlockCrystalFlower;
import electroblob.wizardry.block.BlockCrystalOre;
import electroblob.wizardry.block.BlockMagicLight;
import electroblob.wizardry.block.BlockSnare;
import electroblob.wizardry.block.BlockSpectral;
import electroblob.wizardry.block.BlockStatue;
import electroblob.wizardry.block.BlockTransportationStone;
import electroblob.wizardry.block.BlockVanishingCobweb;
import electroblob.wizardry.command.CommandCastSpell;
import electroblob.wizardry.command.CommandDiscoverSpell;
import electroblob.wizardry.command.CommandSetAlly;
import electroblob.wizardry.command.CommandViewAllies;
import electroblob.wizardry.enchantment.EnchantmentMagicSword;
import electroblob.wizardry.enchantment.EnchantmentTimed;
import electroblob.wizardry.item.ItemArcaneTome;
import electroblob.wizardry.item.ItemArmourUpgrade;
import electroblob.wizardry.item.ItemFirebomb;
import electroblob.wizardry.item.ItemFlamingAxe;
import electroblob.wizardry.item.ItemFrostAxe;
import electroblob.wizardry.item.ItemIdentificationScroll;
import electroblob.wizardry.item.ItemPoisonBomb;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSmokeBomb;
import electroblob.wizardry.item.ItemSpawnWizard;
import electroblob.wizardry.item.ItemSpectralArmour;
import electroblob.wizardry.item.ItemSpectralBow;
import electroblob.wizardry.item.ItemSpectralPickaxe;
import electroblob.wizardry.item.ItemSpectralSword;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.ItemWizardHandbook;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.potion.PotionDecay;
import electroblob.wizardry.potion.PotionFrost;
import electroblob.wizardry.potion.PotionMagicEffect;
import electroblob.wizardry.spell.Spell;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.util.EnumHelper;

@Mod(modid="wizardry", name="Electroblob's Wizardry", version="1.1.4", guiFactory="electroblob.wizardry.WizardryGuiFactory")
public class Wizardry {
    public static final String MODID = "wizardry";
    public static final String NAME = "Electroblob's Wizardry";
    public static final String VERSION = "1.1.4";
    public static final int MANA_PER_CRYSTAL = 100;
    public static final int MANA_PER_FLASK = 700;
    public static final int UPGRADE_STACK_LIMIT = 3;
    public static final float COOLDOWN_REDUCTION_PER_LEVEL = 0.15f;
    public static final float STORAGE_INCREASE_PER_LEVEL = 0.15f;
    public static final float DAMAGE_INCREASE_PER_TIER = 0.15f;
    public static final float COST_REDUCTION_PER_ARMOUR = 0.2f;
    public static final float DURATION_INCREASE_PER_LEVEL = 0.25f;
    public static final float RANGE_INCREASE_PER_LEVEL = 0.25f;
    public static final float BLAST_RADIUS_INCREASE_PER_LEVEL = 0.25f;
    public static final double FROST_SLOWNESS_PER_LEVEL = 0.5;
    public static final double DECAY_SLOWNESS_PER_LEVEL = 0.2;
    public static final float FROST_FATIGUE_PER_LEVEL = 0.45f;
    public static final int CONDENSER_TICK_INTERVAL = 50;
    public static final int SIPHON_MANA_PER_LEVEL = 3;
    public static final int DECAY_SPREAD_INTERVAL = 8;
    public static final String SPELLS_CATEGORY = "spells";
    public static final String IDS_CATEGORY = "ids";
    public static final String RESISTANCES_CATEGORY = "resistances";
    public static final int SPELL_BOOK_FREQUENCY = 20;
    public static final int WAND_FREQUENCY = 3;
    public static final int ARMOUR_FREQUENCY = 6;
    public static final int SCROLL_FREQUENCY = 10;
    public static final int WAND_UPGRADE_FREQUENCY = 2;
    public static final int CRYSTAL_FREQUENCY = 5;
    public static final int APPRENTICE_TOME_FREQUENCY = 3;
    public static final int ADVANCED_TOME_FREQUENCY = 2;
    public static final int MASTER_TOME_FREQUENCY = 1;
    public static final int ARMOUR_UPGRADE_FREQUENCY = 1;
    public static final int FIREBOMB_FREQUENCY = 4;
    public static final int POISON_BOMB_FREQUENCY = 4;
    public static final int SMOKE_BOMB_FREQUENCY = 4;
    public static final int IDENTIFICATION_SCROLL_FREQUENCY = 3;
    public static int towerRarity = 8;
    public static int[] oreDimensions = new int[]{0};
    public static int[] flowerDimensions = new int[]{0};
    public static int[] towerDimensions = new int[]{0};
    public static int spellBookDropChance = 3;
    public static boolean generateLoot = true;
    public static boolean firebombIsCraftable = true;
    public static boolean poisonBombIsCraftable = true;
    public static boolean smokeBombIsCraftable = true;
    public static boolean useAlternateScrollRecipe = false;
    public static boolean teleportThroughUnbreakableBlocks = false;
    public static boolean showSummonedCreatureNames = true;
    public static boolean friendlyFire = true;
    public static boolean telekineticDisarmament = true;
    public static boolean discoveryMode = true;
    public static boolean enableShiftScrolling = true;
    public static boolean minionRevengeTargeting = true;
    public static double playerDamageScale = 1.0;
    public static double npcDamageScale = 1.0;
    public static double maxSpellCommandMultiplier = 20.0;
    public static String[] summonedCreatureTargetsWhitelist = new String[0];
    public static String[] summonedCreatureTargetsBlacklist = new String[]{"creeper"};
    public static String spellHUDPosition = "Bottom left";
    public static String castCommandName = "cast";
    public static String discoverspellCommandName = "discoverspell";
    public static String allyCommandName = "ally";
    public static String alliesCommandName = "allies";
    private static int frostPotionID = 31;
    private static int transiencePotionID = 32;
    private static int fireskinPotionID = 33;
    private static int iceShroudPotionID = 34;
    private static int staticAuraPotionID = 35;
    private static int decayPotionID = 36;
    private static int sixthSensePotionID = 37;
    private static int arcaneJammerPotionID = 38;
    private static int mindTrickPotionID = 39;
    private static int mindControlPotionID = 40;
    private static int fontOfManaPotionID = 41;
    private static int fearPotionID = 42;
    private static int magicSwordEnchantmentID = 100;
    private static int magicBowEnchantmentID = 101;
    private static int flamingWeaponEnchantmentID = 102;
    private static int freezingWeaponEnchantmentID = 103;
    private static Comparator<ItemStack> itemSorter;
    private static Comparator<ItemStack> spellItemSorter;
    public static CreativeTabs tabWizardry;
    public static CreativeTabs tabSpells;
    public static Configuration config;
    public static final Block arcaneWorkbench;
    public static final Block crystalOre;
    public static final Block petrifiedStone;
    public static final Block iceStatue;
    public static final Block magicLight;
    public static final Block crystalFlower;
    public static final Block snare;
    public static final Block transportationStone;
    public static final Block spectralBlock;
    public static final Block crystalBlock;
    public static final Block meteor;
    public static final Block vanishingCobweb;
    public static final Item magicCrystal;
    public static final Item magicWand;
    public static final Item apprenticeWand;
    public static final Item advancedWand;
    public static final Item masterWand;
    public static final Item arcaneTome;
    public static final Item wizardHandbook;
    public static final Item spellBook;
    public static final Item basicFireWand;
    public static final Item basicIceWand;
    public static final Item basicLightningWand;
    public static final Item basicNecromancyWand;
    public static final Item basicEarthWand;
    public static final Item basicSorceryWand;
    public static final Item basicHealingWand;
    public static final Item apprenticeFireWand;
    public static final Item apprenticeIceWand;
    public static final Item apprenticeLightningWand;
    public static final Item apprenticeNecromancyWand;
    public static final Item apprenticeEarthWand;
    public static final Item apprenticeSorceryWand;
    public static final Item apprenticeHealingWand;
    public static final Item advancedFireWand;
    public static final Item advancedIceWand;
    public static final Item advancedLightningWand;
    public static final Item advancedNecromancyWand;
    public static final Item advancedEarthWand;
    public static final Item advancedSorceryWand;
    public static final Item advancedHealingWand;
    public static final Item masterFireWand;
    public static final Item masterIceWand;
    public static final Item masterLightningWand;
    public static final Item masterNecromancyWand;
    public static final Item masterEarthWand;
    public static final Item masterSorceryWand;
    public static final Item masterHealingWand;
    public static final Item spectralSword;
    public static final Item spectralPickaxe;
    public static final Item spectralBow;
    public static final Item manaFlask;
    public static final Item storageUpgrade;
    public static final Item siphonUpgrade;
    public static final Item condenserUpgrade;
    public static final Item rangeUpgrade;
    public static final Item durationUpgrade;
    public static final Item cooldownUpgrade;
    public static final Item blastUpgrade;
    public static final Item attunementUpgrade;
    public static final Item magicSilk;
    public static final Item.ToolMaterial MAGICAL;
    public static final Item flamingAxe;
    public static final Item frostAxe;
    public static final Item firebomb;
    public static final Item poisonBomb;
    public static final Item blankScroll;
    public static final Item scroll;
    public static final Item armourUpgrade;
    public static final ItemArmor.ArmorMaterial SILK;
    public static final Item wizardHat;
    public static final Item wizardRobe;
    public static final Item wizardLeggings;
    public static final Item wizardBoots;
    public static final Item wizardHatFire;
    public static final Item wizardRobeFire;
    public static final Item wizardLeggingsFire;
    public static final Item wizardBootsFire;
    public static final Item wizardHatIce;
    public static final Item wizardRobeIce;
    public static final Item wizardLeggingsIce;
    public static final Item wizardBootsIce;
    public static final Item wizardHatLightning;
    public static final Item wizardRobeLightning;
    public static final Item wizardLeggingsLightning;
    public static final Item wizardBootsLightning;
    public static final Item wizardHatNecromancy;
    public static final Item wizardRobeNecromancy;
    public static final Item wizardLeggingsNecromancy;
    public static final Item wizardBootsNecromancy;
    public static final Item wizardHatEarth;
    public static final Item wizardRobeEarth;
    public static final Item wizardLeggingsEarth;
    public static final Item wizardBootsEarth;
    public static final Item wizardHatSorcery;
    public static final Item wizardRobeSorcery;
    public static final Item wizardLeggingsSorcery;
    public static final Item wizardBootsSorcery;
    public static final Item wizardHatHealing;
    public static final Item wizardRobeHealing;
    public static final Item wizardLeggingsHealing;
    public static final Item wizardBootsHealing;
    public static final Item spawnWizard;
    public static final Item spectralHelmet;
    public static final Item spectralChestplate;
    public static final Item spectralLeggings;
    public static final Item spectralBoots;
    public static final Item smokeBomb;
    public static final Item identificationScroll;
    public static Potion frost;
    public static Potion transience;
    public static Potion fireskin;
    public static Potion iceShroud;
    public static Potion staticAura;
    public static Potion decay;
    public static Potion sixthSense;
    public static Potion arcaneJammer;
    public static Potion mindTrick;
    public static Potion mindControl;
    public static Potion fontOfMana;
    public static Potion fear;
    public static Enchantment magicSword;
    public static Enchantment magicBow;
    public static Enchantment flamingWeapon;
    public static Enchantment freezingWeapon;
    public static final Achievement crystal;
    public static final Achievement arcaneInitiate;
    public static final Achievement apprentice;
    public static final Achievement master;
    public static final Achievement allSpells;
    public static final Achievement wizardTrade;
    public static final Achievement buyMasterSpell;
    public static final Achievement freezeBlaze;
    public static final Achievement chargeCreeper;
    public static final Achievement frankenstein;
    public static final Achievement specialUpgrade;
    public static final Achievement craftFlask;
    public static final Achievement elemental;
    public static final Achievement armourSet;
    public static final Achievement legendary;
    public static final Achievement selfDestruct;
    public static final Achievement pigTornado;
    public static final Achievement jamWizard;
    public static final Achievement slimeSkeleton;
    public static final Achievement angerWizard;
    public static final Achievement defeatEvilWizard;
    public static final Achievement maxOutWand;
    public static final Achievement elementMaster;
    public static final Achievement identifySpell;
    private static final Achievement[] achievementsList;
    public static final AchievementPage wizardryAchievementTab;
    WizardryWorldGenerator oreManager = new WizardryWorldGenerator();
    @Mod.Instance(value="wizardry")
    public static Wizardry instance;
    @SidedProxy(clientSide="electroblob.wizardry.client.ClientProxy", serverSide="electroblob.wizardry.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Wizardry.expandPotionTypesArray();
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        Wizardry.setupGeneralConfig();
        config.save();
        WizardryRegistry.registerBlocks();
        WizardryRegistry.registerItems();
        WizardryRegistry.registerTileEntities();
        WizardryRegistry.registerEntities(this);
        WizardryRegistry.registerSpells();
        WizardryRegistry.registerLoot();
        frost = new PotionFrost(frostPotionID, true, 3726828);
        transience = new PotionMagicEffect(transiencePotionID, false, 16771227, 0).func_76390_b("potion.transience");
        fireskin = new PotionMagicEffect(fireskinPotionID, false, 0xFF2F02, 1).func_76390_b("potion.fireskin");
        iceShroud = new PotionMagicEffect(iceShroudPotionID, false, 5435903, 2).func_76390_b("potion.ice_shroud");
        staticAura = new PotionMagicEffect(staticAuraPotionID, false, 28927, 3).func_76390_b("potion.static_aura");
        decay = new PotionDecay(decayPotionID, true, 3932268);
        sixthSense = new PotionMagicEffect(sixthSensePotionID, false, 13041409, 4).func_76390_b("potion.sixth_sense");
        arcaneJammer = new PotionMagicEffect(arcaneJammerPotionID, false, 13585058, 5).func_76390_b("potion.arcane_jammer");
        mindTrick = new PotionMagicEffect(mindTrickPotionID, true, 6297219, 6).func_76390_b("potion.mind_trick");
        mindControl = new PotionMagicEffect(mindControlPotionID, true, 3279684, 7).func_76390_b("potion.mind_control");
        fontOfMana = new PotionMagicEffect(fontOfManaPotionID, false, 16770491, 8).func_76390_b("potion.font_of_mana");
        fear = new PotionMagicEffect(fearPotionID, true, 12386560, 9).func_76390_b("potion.fear");
        magicSword = new EnchantmentMagicSword(magicSwordEnchantmentID);
        magicBow = new EnchantmentTimed(magicBowEnchantmentID).func_77322_b("magic_bow");
        flamingWeapon = new EnchantmentTimed(flamingWeaponEnchantmentID).func_77322_b("flaming_weapon");
        freezingWeapon = new EnchantmentTimed(freezingWeaponEnchantmentID).func_77322_b("freezing_weapon");
        List<Item> orderedItemList = Arrays.asList(Item.func_150898_a((Block)arcaneWorkbench), Item.func_150898_a((Block)crystalOre), Item.func_150898_a((Block)crystalBlock), Item.func_150898_a((Block)crystalFlower), Item.func_150898_a((Block)transportationStone), magicCrystal, magicWand, apprenticeWand, advancedWand, masterWand, arcaneTome, wizardHandbook, spawnWizard, basicFireWand, basicIceWand, basicLightningWand, basicNecromancyWand, basicEarthWand, basicSorceryWand, basicHealingWand, smokeBomb, firebomb, poisonBomb, blankScroll, identificationScroll, manaFlask, storageUpgrade, siphonUpgrade, condenserUpgrade, rangeUpgrade, durationUpgrade, cooldownUpgrade, blastUpgrade, attunementUpgrade, magicSilk, armourUpgrade, wizardHat, wizardRobe, wizardLeggings, wizardBoots, wizardHatFire, wizardRobeFire, wizardLeggingsFire, wizardBootsFire, wizardHatIce, wizardRobeIce, wizardLeggingsIce, wizardBootsIce, wizardHatLightning, wizardRobeLightning, wizardLeggingsLightning, wizardBootsLightning, wizardHatNecromancy, wizardRobeNecromancy, wizardLeggingsNecromancy, wizardBootsNecromancy, wizardHatEarth, wizardRobeEarth, wizardLeggingsEarth, wizardBootsEarth, wizardHatSorcery, wizardRobeSorcery, wizardLeggingsSorcery, wizardBootsSorcery, wizardHatHealing, wizardRobeHealing, wizardLeggingsHealing, wizardBootsHealing);
        itemSorter = Ordering.explicit(orderedItemList).onResultOf((Function)new Function<ItemStack, Item>(){

            public Item apply(ItemStack input) {
                return input.func_77973_b();
            }
        });
        spellItemSorter = new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack stack1, ItemStack stack2) {
                if (stack1.func_77973_b() instanceof ItemSpellBook && stack2.func_77973_b() instanceof ItemSpellBook || stack1.func_77973_b() instanceof ItemScroll && stack2.func_77973_b() instanceof ItemScroll) {
                    Spell spell1 = Spell.get(stack1.func_77960_j());
                    Spell spell2 = Spell.get(stack2.func_77960_j());
                    return spell1.compareTo(spell2);
                }
                if (stack1.func_77973_b() instanceof ItemScroll) {
                    return 1;
                }
                if (stack2.func_77973_b() instanceof ItemScroll) {
                    return -1;
                }
                return 0;
            }
        };
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Wizardry.setupSpellsConfig();
        config.save();
        proxy.registerKeyBindings();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.oreManager, (int)0);
        FMLCommonHandler.instance().bus().register((Object)new WizardryKeyHandler());
        FMLCommonHandler.instance().bus().register((Object)instance);
        proxy.registerEventHandlers();
        proxy.registerSpellHUD();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new WizardryGuiHandler());
        WizardryPacketHandler.initPackets();
        AchievementPage.registerAchievementPage((AchievementPage)wizardryAchievementTab);
        WizardryRegistry.registerRecipes();
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCastSpell());
        event.registerServerCommand((ICommand)new CommandSetAlly());
        event.registerServerCommand((ICommand)new CommandViewAllies());
        event.registerServerCommand((ICommand)new CommandDiscoverSpell());
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals(MODID)) {
            Wizardry.syncConfig();
        }
    }

    public static void syncConfig() {
        Wizardry.setupGeneralConfig();
        Wizardry.setupSpellsConfig();
        config.save();
    }

    private static void setupSpellsConfig() {
        config.addCustomCategoryComment(SPELLS_CATEGORY, "Set a spell to false to disable it. Disabled spells will still have their associated spell book (mainly so the spell books don't all change) and can still be bound to wands, but cannot be cast in game, will not appear in any subsequently generated chests or wizard trades and will not drop from mobs. Disable a spell if it is causing problems, conflicts with another mod or creates an unintended exploit.");
        for (Spell spell : Spell.getSpells(Spell.allSpells)) {
            Property property = config.get(SPELLS_CATEGORY, spell.getUnlocalisedName(), true, spell.getDescription());
            property.setLanguageKey("spell." + spell.getUnlocalisedName());
            spell.setEnabled(property.getBoolean());
        }
    }

    private static void setupGeneralConfig() {
        int i;
        int i2;
        ArrayList<String> propOrder = new ArrayList<String>();
        config.addCustomCategoryComment("general", "Please note that changing some of these settings may make the mod very difficult to play.");
        Property property = config.get("general", "towerRarity", 8, "Rarity of wizard towers. Higher numbers are rarer. Set to 0 to disable wizard towers completely.", 0, 50);
        property.setLanguageKey("config.tower_rarity");
        property.setRequiresWorldRestart(true);
        proxy.setToNumberSliderEntry(property);
        towerRarity = property.getInt();
        propOrder.add(property.getName());
        property = config.get("general", "spellBookDropChance", 3, "The chance for mobs to drop a spell book when killed. The greater this number, the more often they will drop. Set to 0 to disable spell book drops. Set to 200 for guaranteed drops.", 0, 200);
        property.setLanguageKey("config.spell_book_drop_chance");
        proxy.setToNumberSliderEntry(property);
        spellBookDropChance = property.getInt();
        propOrder.add(property.getName());
        property = config.get("general", "oreDimensions", oreDimensions, "List of dimension ids in which crystal ore will generate. Note that removing the overworld (id 0) from this list will make the mod VERY difficult to play!");
        property.setLanguageKey("config.ore_dimensions");
        property.setRequiresWorldRestart(true);
        oreDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = config.get("general", "flowerDimensions", flowerDimensions, "List of dimension ids in which crystal flowers will generate.");
        property.setLanguageKey("config.flower_dimensions");
        property.setRequiresWorldRestart(true);
        flowerDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = config.get("general", "towerDimensions", towerDimensions, "List of dimension ids in which wizard towers will generate.");
        property.setLanguageKey("config.tower_dimensions");
        property.setRequiresWorldRestart(true);
        towerDimensions = property.getIntList();
        propOrder.add(property.getName());
        property = config.get("general", "generateLoot", true, "Whether to generate wizardry loot in dungeon chests.");
        property.setLanguageKey("config.generate_loot");
        property.setRequiresWorldRestart(true);
        generateLoot = property.getBoolean();
        propOrder.add(property.getName());
        property = config.get("general", "firebombIsCraftable", true, "Whether firebombs can be crafted or not.");
        property.setLanguageKey("config.firebomb_is_craftable");
        property.setRequiresMcRestart(true);
        firebombIsCraftable = property.getBoolean();
        propOrder.add(property.getName());
        property = config.get("general", "poisonBombIsCraftable", true, "Whether poison bombs can be crafted or not.");
        property.setLanguageKey("config.poison_bomb_is_craftable");
        property.setRequiresMcRestart(true);
        poisonBombIsCraftable = property.getBoolean();
        propOrder.add(property.getName());
        property = config.get("general", "smokeBombIsCraftable", true, "Whether smoke bombs can be crafted or not.");
        property.setLanguageKey("config.smoke_bomb_is_craftable");
        property.setRequiresMcRestart(true);
        smokeBombIsCraftable = property.getBoolean();
        propOrder.add(property.getName());
        property = config.get("general", "useAlternateScrollRecipe", false, "Whether to require a magic crystal in the shapeless crafting recipe for blank scrolls. Set to true if another mod adds a conflicting recipe.");
        property.setLanguageKey("config.use_alternate_scroll_recipe");
        property.setRequiresMcRestart(true);
        useAlternateScrollRecipe = property.getBoolean();
        propOrder.add(property.getName());
        property = config.get("general", "teleportThroughUnbreakableBlocks", false, "Whether players are allowed to teleport through unbreakable blocks (e.g. bedrock) using the phase step spell.");
        property.setLanguageKey("config.teleport_through_unbreakable_blocks");
        teleportThroughUnbreakableBlocks = property.getBoolean();
        propOrder.add(property.getName());
        property = config.get("general", "showSummonedCreatureNames", true, "Whether to show summoned creatures' names and owners above their heads.");
        property.setLanguageKey("config.show_summoned_creature_names");
        showSummonedCreatureNames = property.getBoolean();
        propOrder.add(property.getName());
        property = config.get("general", "friendlyFire", true, "Whether to allow players to damage their designated allies using magic.");
        property.setLanguageKey("config.friendly_fire");
        friendlyFire = property.getBoolean();
        propOrder.add(property.getName());
        property = config.get("general", "telekineticDisarmament", true, "Whether to allow players to disarm other players using the telekinesis spell. Set to false to prevent stealing of items.");
        property.setLanguageKey("config.telekinetic_disarmament");
        telekineticDisarmament = property.getBoolean();
        propOrder.add(property.getName());
        property = config.get("general", "discoveryMode", true, "For those who like a sense of mystery! When set to true, spells you haven't cast yet will be unreadable until you cast them (on a per-world basis). Has no effect when in creative mode. Spells of identification will be unobtainable in survival mode if this is false.");
        property.setLanguageKey("config.discovery_mode");
        property.setRequiresWorldRestart(true);
        discoveryMode = property.getBoolean();
        propOrder.add(property.getName());
        property = config.get("general", "enableShiftScrolling", true, "Whether you can switch between spells on a wand by scrolling with the mouse wheel while sneaking. Note that this will only affect you; other players connected to the same server obey their own settings.");
        property.setLanguageKey("config.enable_shift_scrolling");
        property.setRequiresWorldRestart(false);
        enableShiftScrolling = property.getBoolean();
        propOrder.add(property.getName());
        property = config.get("general", "minionRevengeTargeting", true, "Whether summoned creatures can revenge attack their owner if their owner attacks them.");
        property.setLanguageKey("config.minion_revenge_targeting");
        property.setRequiresWorldRestart(false);
        minionRevengeTargeting = property.getBoolean();
        propOrder.add(property.getName());
        property = config.get("general", "playerDamageScaling", 1.0, "Global damage scaling factor for the damage dealt by players casting spells, relative to 1.", 0.0, 20.0);
        property.setLanguageKey("config.player_damage_scaling");
        playerDamageScale = property.getDouble();
        propOrder.add(property.getName());
        property = config.get("general", "npcDamageScaling", 1.0, "Global damage scaling factor for the damage dealt by NPCs casting spells, relative to 1.", 0.0, 20.0);
        property.setLanguageKey("config.npc_damage_scaling");
        npcDamageScale = property.getDouble();
        propOrder.add(property.getName());
        property = config.get("general", "castCommandMultiplierLimit", 20.0, "Upper limit for the multipliers passed into the /cast command. This is here to stop players from accidentally breaking a world/server. Large blast mutipliers can cause extreme lag - you have been warned!", 1.0, 255.0);
        property.setLanguageKey("config.cast_command_multiplier_limit");
        maxSpellCommandMultiplier = property.getDouble();
        propOrder.add(property.getName());
        property = config.get("general", "summonedCreatureTargetsWhitelist", summonedCreatureTargetsWhitelist, "List of names of entities which summoned creatures and wizards are allowed to attack, in addition to the defaults. Add mod creatures to this list if you want summoned creatures to attack them and they aren't already doing so. Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. wizardry:Wizard).");
        property.setLanguageKey("config.summoned_creature_targets_whitelist");
        property.setRequiresWorldRestart(true);
        summonedCreatureTargetsWhitelist = property.getStringList();
        for (i2 = 0; i2 < summonedCreatureTargetsWhitelist.length; ++i2) {
            Wizardry.summonedCreatureTargetsWhitelist[i2] = summonedCreatureTargetsWhitelist[i2].toLowerCase(Locale.ROOT).trim();
        }
        propOrder.add(property.getName());
        property = config.get("general", "summonedCreatureTargetsBlacklist", summonedCreatureTargetsBlacklist, "List of names of entities which summoned creatures and wizards are specifically not allowed to attack, overriding the defaults and the whitelist. Add creatures to this list if allowing them to be attacked causes problems or is too destructive (removing creepers from this list is done at your own risk!). Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. wizardry:Wizard).");
        property.setLanguageKey("config.summoned_creature_targets_blacklist");
        property.setRequiresWorldRestart(true);
        summonedCreatureTargetsBlacklist = property.getStringList();
        for (i2 = 0; i2 < summonedCreatureTargetsBlacklist.length; ++i2) {
            Wizardry.summonedCreatureTargetsBlacklist[i2] = summonedCreatureTargetsBlacklist[i2].toLowerCase(Locale.ROOT).trim();
        }
        propOrder.add(property.getName());
        property = config.get("general", "spellHUDPosition", spellHUDPosition, "The position of the spell HUD.", new String[]{"Bottom left", "Top left", "Top right", "Bottom right"});
        property.setLanguageKey("config.spell_hud_position");
        spellHUDPosition = property.getString();
        propOrder.add(property.getName());
        property = config.get("general", "castCommandName", castCommandName, "The name of the /cast command. This is what you type directly after the /; for example if this was set to 'magic' then instead of typing /cast you would type /magic instead.");
        property.setLanguageKey("config.cast_command_name");
        castCommandName = property.getString();
        propOrder.add(property.getName());
        property = config.get("general", "discoverspellCommandName", discoverspellCommandName, "The name of the /discoverspell command. This is what you type directly after the /; for example if this was set to 'magic' then instead of typing /discoverspell you would type /magic instead.");
        property.setLanguageKey("config.discoverspell_command_name");
        discoverspellCommandName = property.getString();
        propOrder.add(property.getName());
        property = config.get("general", "allyCommandName", allyCommandName, "The name of the /ally command. This is what you type directly after the /; for example if this was set to 'magic' then instead of typing /ally you would type /magic instead.");
        property.setLanguageKey("config.ally_command_name");
        allyCommandName = property.getString();
        propOrder.add(property.getName());
        property = config.get("general", "alliesCommandName", alliesCommandName, "The name of the /allies command. This is what you type directly after the /; for example if this was set to 'magic' then instead of typing /allies you would type /magic instead.");
        property.setLanguageKey("config.allies_command_name");
        alliesCommandName = property.getString();
        propOrder.add(property.getName());
        config.setCategoryPropertyOrder("general", propOrder);
        ArrayList<String> propOrder1 = new ArrayList<String>();
        config.addCustomCategoryComment(RESISTANCES_CATEGORY, "These options allow entities to be made immune to certain types of magic.");
        property = config.get(RESISTANCES_CATEGORY, "mobsImmuneToFire", new String[0], "List of names of entities that are immune to fire, in addition to the defaults. Add mod creatures to this list if you want them to be immune to fire magic and they aren't already. Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. wizardry:Wizard).");
        property.setLanguageKey("config.mobs_immune_to_fire");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity((Class)EntityList.field_75625_b.get(property.getStringList()[i]), MagicDamage.DamageType.FIRE);
        }
        propOrder1.add(property.getName());
        property = config.get(RESISTANCES_CATEGORY, "mobsImmuneToIce", new String[0], "List of names of entities that are immune to ice, in addition to the defaults. Add mod creatures to this list if you want them to be immune to ice magic and they aren't already. Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. wizardry:Wizard).");
        property.setLanguageKey("config.mobs_immune_to_ice");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity((Class)EntityList.field_75625_b.get(property.getStringList()[i]), MagicDamage.DamageType.FROST);
        }
        propOrder1.add(property.getName());
        property = config.get(RESISTANCES_CATEGORY, "mobsImmuneToLightning", new String[0], "List of names of entities that are immune to lightning, in addition to the defaults. Add mod creatures to this list if you want them to be immune to lightning magic and they aren't already. Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. wizardry:Wizard).");
        property.setLanguageKey("config.mobs_immune_to_lightning");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity((Class)EntityList.field_75625_b.get(property.getStringList()[i]), MagicDamage.DamageType.SHOCK);
        }
        propOrder1.add(property.getName());
        property = config.get(RESISTANCES_CATEGORY, "mobsImmuneToWither", new String[0], "List of names of entities that are immune to wither effects, in addition to the defaults. Add mod creatures to this list if you want them to be immune to withering magic and they aren't already. Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. wizardry:Wizard).");
        property.setLanguageKey("config.mobs_immune_to_wither");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity((Class)EntityList.field_75625_b.get(property.getStringList()[i]), MagicDamage.DamageType.WITHER);
        }
        propOrder1.add(property.getName());
        property = config.get(RESISTANCES_CATEGORY, "mobsImmuneToPoison", new String[0], "List of names of entities that are immune to poison, in addition to the defaults. Add mod creatures to this list if you want them to be immune to poison magic and they aren't already. Entity names are not case sensitive. For mod entities, prefix with the mod ID (e.g. wizardry:Wizard).");
        property.setLanguageKey("config.mobs_immune_to_poison");
        property.setRequiresMcRestart(true);
        for (i = 0; i < property.getStringList().length; ++i) {
            property.getStringList()[i] = property.getStringList()[i].toLowerCase(Locale.ROOT).trim();
            MagicDamage.addEntityImmunity((Class)EntityList.field_75625_b.get(property.getStringList()[i]), MagicDamage.DamageType.POISON);
        }
        propOrder1.add(property.getName());
        config.setCategoryPropertyOrder(RESISTANCES_CATEGORY, propOrder1);
        ArrayList<String> propOrder2 = new ArrayList<String>();
        config.addCustomCategoryComment(IDS_CATEGORY, "Change these IDs if they conflict with another mod.");
        property = config.get(IDS_CATEGORY, "frostPotionID", 31, "The ID of the frost potion effect. Change if this conflicts with another mod.", 24, 255);
        property.setLanguageKey("config.frost_potion_id");
        property.setRequiresMcRestart(true);
        frostPotionID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "transiencePotionID", 32, "The ID of the transience potion effect. Change if this conflicts with another mod.", 24, 255);
        property.setLanguageKey("config.transience_potion_id");
        property.setRequiresMcRestart(true);
        transiencePotionID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "fireskinPotionID", 33, "The ID of the fireskin potion effect. Change if this conflicts with another mod.", 24, 255);
        property.setLanguageKey("config.fireskin_potion_id");
        property.setRequiresMcRestart(true);
        fireskinPotionID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "iceShroudPotionID", 34, "The ID of the ice shroud potion effect. Change if this conflicts with another mod.", 24, 255);
        property.setLanguageKey("config.ice_shroud_potion_id");
        property.setRequiresMcRestart(true);
        iceShroudPotionID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "staticAuraPotionID", 35, "The ID of the static aura potion effect. Change if this conflicts with another mod.", 24, 255);
        property.setLanguageKey("config.static_aura_potion_id");
        property.setRequiresMcRestart(true);
        staticAuraPotionID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "decayPotionID", 36, "The ID of the decay potion effect. Change if this conflicts with another mod.", 24, 255);
        property.setLanguageKey("config.decay_potion_id");
        property.setRequiresMcRestart(true);
        decayPotionID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "sixthSensePotionID", 37, "The ID of the sixth sense potion effect. Change if this conflicts with another mod.", 24, 255);
        property.setLanguageKey("config.sixth_sense_potion_id");
        property.setRequiresMcRestart(true);
        sixthSensePotionID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "arcaneJammerPotionID", 38, "The ID of the arcane jammer potion effect. Change if this conflicts with another mod.", 24, 255);
        property.setLanguageKey("config.arcane_jammer_potion_id");
        property.setRequiresMcRestart(true);
        arcaneJammerPotionID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "mindTrickPotionID", 39, "The ID of the mind trick potion effect. Change if this conflicts with another mod.", 24, 255);
        property.setLanguageKey("config.mind_trick_potion_id");
        property.setRequiresMcRestart(true);
        mindTrickPotionID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "mindControlPotionID", 40, "The ID of the mind control potion effect. Change if this conflicts with another mod.", 24, 255);
        property.setLanguageKey("config.mind_control_potion_id");
        property.setRequiresMcRestart(true);
        mindControlPotionID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "fontOfManaPotionID", 41, "The ID of the font of mana potion effect. Change if this conflicts with another mod.", 24, 255);
        property.setLanguageKey("config.font_of_mana_potion_id");
        property.setRequiresMcRestart(true);
        fontOfManaPotionID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "fearPotionID", 42, "The ID of the fear potion effect. Change if this conflicts with another mod.", 24, 255);
        property.setLanguageKey("config.fear_potion_id");
        property.setRequiresMcRestart(true);
        fearPotionID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "magicSwordEnchantmentID", 100, "The ID of the magic sword enchantment. Change if this conflicts with another mod.", 63, 255);
        property.setLanguageKey("config.magic_sword_enchantment_id");
        property.setRequiresMcRestart(true);
        magicSwordEnchantmentID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "magicBowEnchantmentID", 101, "The ID of the magic bow enchantment. Change if this conflicts with another mod.", 63, 255);
        property.setLanguageKey("config.magic_bow_enchantment_id");
        property.setRequiresMcRestart(true);
        magicBowEnchantmentID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "flamingWeaponEnchantmentID", 102, "The ID of the flaming weapon enchantment. Change if this conflicts with another mod.", 63, 255);
        property.setLanguageKey("config.flaming_weapon_enchantment_id");
        property.setRequiresMcRestart(true);
        flamingWeaponEnchantmentID = property.getInt();
        propOrder2.add(property.getName());
        property = config.get(IDS_CATEGORY, "freezingWeaponEnchantmentID", 103, "The ID of the freezing weapon enchantment. Change if this conflicts with another mod.", 63, 255);
        property.setLanguageKey("config.freezing_weapon_enchantment_id");
        property.setRequiresMcRestart(true);
        freezingWeaponEnchantmentID = property.getInt();
        propOrder2.add(property.getName());
        config.setCategoryPropertyOrder(IDS_CATEGORY, propOrder2);
    }

    private static void expandPotionTypesArray() {
        Potion[] potionTypes = null;
        for (Field f : Potion.class.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                if (!f.getName().equals("potionTypes") && !f.getName().equals("field_76425_a")) continue;
                Field modfield = Field.class.getDeclaredField("modifiers");
                modfield.setAccessible(true);
                modfield.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                potionTypes = (Potion[])f.get(null);
                Potion[] newPotionTypes = new Potion[256];
                System.arraycopy(potionTypes, 0, newPotionTypes, 0, potionTypes.length);
                f.set(null, newPotionTypes);
            }
            catch (Exception e) {
                System.err.println("Something went very wrong! Error while expanding potion types array:");
                e.printStackTrace();
            }
        }
    }

    static {
        tabWizardry = new CreativeTabs(MODID){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return wizardHandbook;
            }

            @SideOnly(value=Side.CLIENT)
            public void func_78018_a(List items) {
                super.func_78018_a(items);
                Collections.sort(items, itemSorter);
            }
        };
        tabSpells = new CreativeTabs("wizardryspells"){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return spellBook;
            }

            @SideOnly(value=Side.CLIENT)
            public void func_78018_a(List items) {
                super.func_78018_a(items);
                Collections.sort(items, spellItemSorter);
            }
        };
        arcaneWorkbench = new BlockArcaneWorkbench().func_149711_c(1.0f).func_149663_c("arcaneWorkbench").func_149647_a(tabWizardry);
        crystalOre = new BlockCrystalOre(Material.field_151576_e).func_149711_c(3.0f).func_149663_c("crystalOre").func_149647_a(tabWizardry).func_149658_d("wizardry:crystal_ore");
        petrifiedStone = new BlockStatue(Material.field_151576_e).func_149711_c(1.5f).func_149752_b(10.0f).func_149663_c("petrifiedStone").func_149658_d("minecraft:stone");
        iceStatue = new BlockStatue(Material.field_151588_w).func_149711_c(0.5f).func_149713_g(3).func_149672_a(Block.field_149778_k).func_149663_c("iceStatue").func_149658_d("minecraft:ice");
        magicLight = new BlockMagicLight(Material.field_151594_q).func_149663_c("magicLight").func_149658_d("minecraft:beacon");
        crystalFlower = new BlockCrystalFlower(Material.field_151585_k).func_149711_c(0.0f).func_149663_c("crystalFlower").func_149672_a(Block.field_149779_h).func_149658_d("wizardry:crystal_flower").func_149647_a(tabWizardry);
        snare = new BlockSnare(Material.field_151585_k).func_149711_c(0.0f).func_149663_c("snare").func_149672_a(Block.field_149779_h).func_149658_d("wizardry:snare");
        transportationStone = new BlockTransportationStone(Material.field_151576_e).func_149711_c(0.0f).func_149715_a(0.5f).func_149713_g(0).func_149663_c("transportationStone").func_149647_a(tabWizardry).func_149658_d("wizardry:transportation_stone");
        spectralBlock = new BlockSpectral(Material.field_151592_s).func_149663_c("spectralBlock").func_149672_a(Block.field_149778_k).func_149658_d("wizardry:spectral_block").func_149715_a(0.7f).func_149713_g(0).func_149722_s().func_149752_b(6000000.0f);
        crystalBlock = new BlockCrystal(Material.field_151573_f).func_149711_c(5.0f).func_149752_b(10.0f).func_149663_c("crystalBlock").func_149658_d("wizardry:crystal_block").func_149647_a(tabWizardry);
        meteor = new Block(Material.field_151576_e){}.func_149658_d("wizardry:meteor").func_149715_a(1.0f);
        vanishingCobweb = new BlockVanishingCobweb(Material.field_151569_G).func_149663_c("vanishingCobweb").func_149658_d("minecraft:web").func_149713_g(1).func_149711_c(4.0f);
        magicCrystal = new Item().func_111206_d("wizardry:magic_crystal").func_77655_b("magicCrystal").func_77637_a(tabWizardry);
        magicWand = new ItemWand(EnumTier.BASIC, null).func_111206_d("wizardry:wand_basic").func_77655_b("magicWand");
        apprenticeWand = new ItemWand(EnumTier.APPRENTICE, null).func_111206_d("wizardry:wand_apprentice").func_77655_b("apprenticeWand");
        advancedWand = new ItemWand(EnumTier.ADVANCED, null).func_111206_d("wizardry:wand_advanced").func_77655_b("advancedWand");
        masterWand = new ItemWand(EnumTier.MASTER, null).func_111206_d("wizardry:wand_master").func_77655_b("masterWand");
        arcaneTome = new ItemArcaneTome();
        wizardHandbook = new ItemWizardHandbook();
        spellBook = new ItemSpellBook();
        basicFireWand = new ItemWand(EnumTier.BASIC, EnumElement.FIRE).func_111206_d("wizardry:wand_basic_fire").func_77655_b("basicFireWand");
        basicIceWand = new ItemWand(EnumTier.BASIC, EnumElement.ICE).func_111206_d("wizardry:wand_basic_ice").func_77655_b("basicIceWand");
        basicLightningWand = new ItemWand(EnumTier.BASIC, EnumElement.LIGHTNING).func_111206_d("wizardry:wand_basic_lightning").func_77655_b("basicLightningWand");
        basicNecromancyWand = new ItemWand(EnumTier.BASIC, EnumElement.NECROMANCY).func_111206_d("wizardry:wand_basic_necromancy").func_77655_b("basicNecromancyWand");
        basicEarthWand = new ItemWand(EnumTier.BASIC, EnumElement.EARTH).func_111206_d("wizardry:wand_basic_earth").func_77655_b("basicEarthWand");
        basicSorceryWand = new ItemWand(EnumTier.BASIC, EnumElement.SORCERY).func_111206_d("wizardry:wand_basic_sorcery").func_77655_b("basicSorceryWand");
        basicHealingWand = new ItemWand(EnumTier.BASIC, EnumElement.HEALING).func_111206_d("wizardry:wand_basic_healing").func_77655_b("basicHealingWand");
        apprenticeFireWand = new ItemWand(EnumTier.APPRENTICE, EnumElement.FIRE).func_111206_d("wizardry:wand_apprentice_fire").func_77655_b("apprenticeFireWand");
        apprenticeIceWand = new ItemWand(EnumTier.APPRENTICE, EnumElement.ICE).func_111206_d("wizardry:wand_apprentice_ice").func_77655_b("apprenticeIceWand");
        apprenticeLightningWand = new ItemWand(EnumTier.APPRENTICE, EnumElement.LIGHTNING).func_111206_d("wizardry:wand_apprentice_lightning").func_77655_b("apprenticeLightningWand");
        apprenticeNecromancyWand = new ItemWand(EnumTier.APPRENTICE, EnumElement.NECROMANCY).func_111206_d("wizardry:wand_apprentice_necromancy").func_77655_b("apprenticeNecromancyWand");
        apprenticeEarthWand = new ItemWand(EnumTier.APPRENTICE, EnumElement.EARTH).func_111206_d("wizardry:wand_apprentice_earth").func_77655_b("apprenticeEarthWand");
        apprenticeSorceryWand = new ItemWand(EnumTier.APPRENTICE, EnumElement.SORCERY).func_111206_d("wizardry:wand_apprentice_sorcery").func_77655_b("apprenticeSorceryWand");
        apprenticeHealingWand = new ItemWand(EnumTier.APPRENTICE, EnumElement.HEALING).func_111206_d("wizardry:wand_apprentice_healing").func_77655_b("apprenticeHealingWand");
        advancedFireWand = new ItemWand(EnumTier.ADVANCED, EnumElement.FIRE).func_111206_d("wizardry:wand_advanced_fire").func_77655_b("advancedFireWand");
        advancedIceWand = new ItemWand(EnumTier.ADVANCED, EnumElement.ICE).func_111206_d("wizardry:wand_advanced_ice").func_77655_b("advancedIceWand");
        advancedLightningWand = new ItemWand(EnumTier.ADVANCED, EnumElement.LIGHTNING).func_111206_d("wizardry:wand_advanced_lightning").func_77655_b("advancedLightningWand");
        advancedNecromancyWand = new ItemWand(EnumTier.ADVANCED, EnumElement.NECROMANCY).func_111206_d("wizardry:wand_advanced_necromancy").func_77655_b("advancedNecromancyWand");
        advancedEarthWand = new ItemWand(EnumTier.ADVANCED, EnumElement.EARTH).func_111206_d("wizardry:wand_advanced_earth").func_77655_b("advancedEarthWand");
        advancedSorceryWand = new ItemWand(EnumTier.ADVANCED, EnumElement.SORCERY).func_111206_d("wizardry:wand_advanced_sorcery").func_77655_b("advancedSorceryWand");
        advancedHealingWand = new ItemWand(EnumTier.ADVANCED, EnumElement.HEALING).func_111206_d("wizardry:wand_advanced_healing").func_77655_b("advancedHealingWand");
        masterFireWand = new ItemWand(EnumTier.MASTER, EnumElement.FIRE).func_111206_d("wizardry:wand_master_fire").func_77655_b("masterFireWand");
        masterIceWand = new ItemWand(EnumTier.MASTER, EnumElement.ICE).func_111206_d("wizardry:wand_master_ice").func_77655_b("masterIceWand");
        masterLightningWand = new ItemWand(EnumTier.MASTER, EnumElement.LIGHTNING).func_111206_d("wizardry:wand_master_lightning").func_77655_b("masterLightningWand");
        masterNecromancyWand = new ItemWand(EnumTier.MASTER, EnumElement.NECROMANCY).func_111206_d("wizardry:wand_master_necromancy").func_77655_b("masterNecromancyWand");
        masterEarthWand = new ItemWand(EnumTier.MASTER, EnumElement.EARTH).func_111206_d("wizardry:wand_master_earth").func_77655_b("masterEarthWand");
        masterSorceryWand = new ItemWand(EnumTier.MASTER, EnumElement.SORCERY).func_111206_d("wizardry:wand_master_sorcery").func_77655_b("masterSorceryWand");
        masterHealingWand = new ItemWand(EnumTier.MASTER, EnumElement.HEALING).func_111206_d("wizardry:wand_master_healing").func_77655_b("masterHealingWand");
        spectralSword = new ItemSpectralSword(Item.ToolMaterial.IRON).func_111206_d("wizardry:spectral_sword").func_77655_b("spectralSword");
        spectralPickaxe = new ItemSpectralPickaxe(Item.ToolMaterial.IRON).func_111206_d("wizardry:spectral_pickaxe").func_77655_b("spectralPickaxe");
        spectralBow = new ItemSpectralBow().func_77655_b("spectralBow");
        manaFlask = new Item(){

            public void func_77622_d(ItemStack par1ItemStack, World par2World, EntityPlayer entityplayer) {
                entityplayer.func_71029_a((StatBase)craftFlask);
            }
        }.func_111206_d("wizardry:mana_flask").func_77655_b("manaFlask").func_77637_a(tabWizardry);
        storageUpgrade = new Item().func_111206_d("wizardry:upgrade_storage").func_77655_b("storageUpgrade").func_77637_a(tabWizardry);
        siphonUpgrade = new Item().func_111206_d("wizardry:upgrade_siphon").func_77655_b("siphonUpgrade").func_77637_a(tabWizardry);
        condenserUpgrade = new Item().func_111206_d("wizardry:upgrade_condenser").func_77655_b("condenserUpgrade").func_77637_a(tabWizardry);
        rangeUpgrade = new Item().func_111206_d("wizardry:upgrade_range").func_77655_b("rangeUpgrade").func_77637_a(tabWizardry);
        durationUpgrade = new Item().func_111206_d("wizardry:upgrade_duration").func_77655_b("durationUpgrade").func_77637_a(tabWizardry);
        cooldownUpgrade = new Item().func_111206_d("wizardry:upgrade_cooldown").func_77655_b("cooldownUpgrade").func_77637_a(tabWizardry);
        blastUpgrade = new Item().func_111206_d("wizardry:upgrade_blast").func_77655_b("blastUpgrade").func_77637_a(tabWizardry);
        attunementUpgrade = new Item().func_111206_d("wizardry:upgrade_attunement").func_77655_b("attunementUpgrade").func_77637_a(tabWizardry);
        magicSilk = new Item().func_111206_d("wizardry:magic_silk").func_77655_b("magicSilk").func_77637_a(tabWizardry);
        MAGICAL = EnumHelper.addToolMaterial((String)"MAGICAL", (int)3, (int)1000, (float)8.0f, (float)4.0f, (int)0);
        flamingAxe = new ItemFlamingAxe(MAGICAL).func_111206_d("wizardry:flaming_axe").func_77655_b("flamingAxe");
        frostAxe = new ItemFrostAxe(MAGICAL).func_111206_d("wizardry:frost_axe").func_77655_b("frostAxe");
        firebomb = new ItemFirebomb().func_111206_d("wizardry:firebomb").func_77655_b("firebomb");
        poisonBomb = new ItemPoisonBomb().func_111206_d("wizardry:poison_bomb").func_77655_b("poisonBomb");
        blankScroll = new Item().func_111206_d("wizardry:scroll").func_77655_b("blankScroll").func_77637_a(tabWizardry);
        scroll = new ItemScroll().func_111206_d("wizardry:scroll").func_77655_b("scroll").func_77637_a(tabSpells);
        armourUpgrade = new ItemArmourUpgrade().func_111206_d("wizardry:armour_upgrade").func_77655_b("armourUpgrade");
        SILK = EnumHelper.addArmorMaterial((String)"SILK", (int)15, (int[])new int[]{2, 5, 4, 2}, (int)0);
        wizardHat = new ItemWizardArmour(SILK, 1, 0, null);
        wizardRobe = new ItemWizardArmour(SILK, 1, 1, null);
        wizardLeggings = new ItemWizardArmour(SILK, 1, 2, null);
        wizardBoots = new ItemWizardArmour(SILK, 1, 3, null);
        wizardHatFire = new ItemWizardArmour(SILK, 1, 0, EnumElement.FIRE);
        wizardRobeFire = new ItemWizardArmour(SILK, 1, 1, EnumElement.FIRE);
        wizardLeggingsFire = new ItemWizardArmour(SILK, 1, 2, EnumElement.FIRE);
        wizardBootsFire = new ItemWizardArmour(SILK, 1, 3, EnumElement.FIRE);
        wizardHatIce = new ItemWizardArmour(SILK, 1, 0, EnumElement.ICE);
        wizardRobeIce = new ItemWizardArmour(SILK, 1, 1, EnumElement.ICE);
        wizardLeggingsIce = new ItemWizardArmour(SILK, 1, 2, EnumElement.ICE);
        wizardBootsIce = new ItemWizardArmour(SILK, 1, 3, EnumElement.ICE);
        wizardHatLightning = new ItemWizardArmour(SILK, 1, 0, EnumElement.LIGHTNING);
        wizardRobeLightning = new ItemWizardArmour(SILK, 1, 1, EnumElement.LIGHTNING);
        wizardLeggingsLightning = new ItemWizardArmour(SILK, 1, 2, EnumElement.LIGHTNING);
        wizardBootsLightning = new ItemWizardArmour(SILK, 1, 3, EnumElement.LIGHTNING);
        wizardHatNecromancy = new ItemWizardArmour(SILK, 1, 0, EnumElement.NECROMANCY);
        wizardRobeNecromancy = new ItemWizardArmour(SILK, 1, 1, EnumElement.NECROMANCY);
        wizardLeggingsNecromancy = new ItemWizardArmour(SILK, 1, 2, EnumElement.NECROMANCY);
        wizardBootsNecromancy = new ItemWizardArmour(SILK, 1, 3, EnumElement.NECROMANCY);
        wizardHatEarth = new ItemWizardArmour(SILK, 1, 0, EnumElement.EARTH);
        wizardRobeEarth = new ItemWizardArmour(SILK, 1, 1, EnumElement.EARTH);
        wizardLeggingsEarth = new ItemWizardArmour(SILK, 1, 2, EnumElement.EARTH);
        wizardBootsEarth = new ItemWizardArmour(SILK, 1, 3, EnumElement.EARTH);
        wizardHatSorcery = new ItemWizardArmour(SILK, 1, 0, EnumElement.SORCERY);
        wizardRobeSorcery = new ItemWizardArmour(SILK, 1, 1, EnumElement.SORCERY);
        wizardLeggingsSorcery = new ItemWizardArmour(SILK, 1, 2, EnumElement.SORCERY);
        wizardBootsSorcery = new ItemWizardArmour(SILK, 1, 3, EnumElement.SORCERY);
        wizardHatHealing = new ItemWizardArmour(SILK, 1, 0, EnumElement.HEALING);
        wizardRobeHealing = new ItemWizardArmour(SILK, 1, 1, EnumElement.HEALING);
        wizardLeggingsHealing = new ItemWizardArmour(SILK, 1, 2, EnumElement.HEALING);
        wizardBootsHealing = new ItemWizardArmour(SILK, 1, 3, EnumElement.HEALING);
        spawnWizard = new ItemSpawnWizard().func_77655_b("spawn_wizard");
        spectralHelmet = new ItemSpectralArmour(ItemArmor.ArmorMaterial.IRON, 1, 0).func_111206_d("wizardry:spectral_helmet").func_77655_b("spectral_helmet");
        spectralChestplate = new ItemSpectralArmour(ItemArmor.ArmorMaterial.IRON, 1, 1).func_111206_d("wizardry:spectral_chestplate").func_77655_b("spectral_chestplate");
        spectralLeggings = new ItemSpectralArmour(ItemArmor.ArmorMaterial.IRON, 1, 2).func_111206_d("wizardry:spectral_leggings").func_77655_b("spectral_leggings");
        spectralBoots = new ItemSpectralArmour(ItemArmor.ArmorMaterial.IRON, 1, 3).func_111206_d("wizardry:spectral_boots").func_77655_b("spectral_boots");
        smokeBomb = new ItemSmokeBomb().func_111206_d("wizardry:smoke_bomb").func_77655_b("smoke_bomb");
        identificationScroll = new ItemIdentificationScroll();
        crystal = new Achievement("crystal", "Crystal", -1, -1, magicCrystal, null).func_75971_g();
        arcaneInitiate = new Achievement("arcaneInitiate", "ArcaneInitiate", 2, -1, magicWand, crystal).func_75971_g();
        apprentice = new Achievement("apprentice", "Apprentice", 2, 3, apprenticeWand, arcaneInitiate).func_75971_g();
        master = new Achievement("master", "Master", 3, 6, masterWand, apprentice).func_75971_g();
        allSpells = new Achievement("allSpells", "AllSpells", 5, 7, wizardHandbook, master).func_75971_g().func_75987_b();
        wizardTrade = new Achievement("wizardTrade", "WizardTrade", 2, -5, Items.field_151166_bC, arcaneInitiate).func_75971_g();
        buyMasterSpell = new Achievement("buyMasterSpell", "BuyMasterSpell", 5, -5, spellBook, wizardTrade).func_75971_g().func_75987_b();
        freezeBlaze = new Achievement("freezeBlaze", "FreezeBlaze", -1, 3, Blocks.field_150432_aD, apprentice).func_75971_g();
        chargeCreeper = new Achievement("chargeCreeper", "ChargeCreeper", -1, 1, Items.field_151016_H, arcaneInitiate).func_75971_g();
        frankenstein = new Achievement("frankenstein", "Frankenstein", -3, 1, advancedLightningWand, chargeCreeper).func_75971_g().func_75987_b();
        specialUpgrade = new Achievement("specialUpgrade", "SpecialUpgrade", 4, 1, condenserUpgrade, arcaneInitiate).func_75971_g();
        craftFlask = new Achievement("craftFlask", "CraftFlask", 4, -2, manaFlask, arcaneInitiate).func_75971_g();
        elemental = new Achievement("elemental", "Elemental", 6, -1, basicFireWand, arcaneInitiate).func_75971_g();
        armourSet = new Achievement("armourSet", "ArmourSet", 0, -4, wizardHat, arcaneInitiate).func_75971_g();
        legendary = new Achievement("legendary", "Legendary", -2, -5, armourUpgrade, armourSet).func_75971_g().func_75987_b();
        selfDestruct = new Achievement("selfDestruct", "SelfDestruct", 1, 0, Blocks.field_150423_aK, arcaneInitiate).func_75971_g();
        pigTornado = new Achievement("pigTornado", "PigTornado", 6, 3, Items.field_151141_av, apprentice).func_75971_g().func_75987_b();
        jamWizard = new Achievement("jamWizard", "JamWizard", 4, 4, Blocks.field_150321_G, apprentice).func_75971_g();
        slimeSkeleton = new Achievement("slimeSkeleton", "SlimeSkeleton", 1, 5, Items.field_151123_aH, apprentice).func_75971_g();
        angerWizard = new Achievement("angerWizard", "AngerWizard", 1, -7, Items.field_151040_l, wizardTrade).func_75971_g();
        defeatEvilWizard = new Achievement("defeatEvilWizard", "DefeatEvilWizard", 4, -7, wizardBootsNecromancy, wizardTrade).func_75971_g();
        maxOutWand = new Achievement("maxOutWand", "MaxOutWand", 7, 1, arcaneTome, specialUpgrade).func_75971_g().func_75987_b();
        elementMaster = new Achievement("elementMaster", "ElementMaster", 7, -3, masterIceWand, elemental).func_75971_g().func_75987_b();
        identifySpell = new Achievement("identifySpell", "IdentifySpell", -2, -3, identificationScroll, arcaneInitiate).func_75971_g();
        achievementsList = new Achievement[]{crystal, arcaneInitiate, apprentice, master, allSpells, wizardTrade, buyMasterSpell, freezeBlaze, chargeCreeper, frankenstein, specialUpgrade, craftFlask, elemental, armourSet, legendary, selfDestruct, pigTornado, jamWizard, slimeSkeleton, angerWizard, defeatEvilWizard, maxOutWand, elementMaster, identifySpell};
        wizardryAchievementTab = new AchievementPage("Wizardry", achievementsList);
    }
}

