/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import electroblob.wizardry.ExtendedPlayer;
import electroblob.wizardry.SpellGlyphData;
import electroblob.wizardry.WandHelper;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryRegistry;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiSpellDisplay
extends Gui {
    private Minecraft mc;
    private static final ResourceLocation hudTexture = new ResourceLocation("wizardry", "textures/gui/spell_hud.png");

    public GuiSpellDisplay(Minecraft par1Minecraft) {
        this.mc = par1Minecraft;
    }

    @SubscribeEvent
    public void draw(RenderGameOverlayEvent event) {
        EntityClientPlayerMP player = this.mc.field_71439_g;
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemWand) {
            int width = event.resolution.func_78326_a();
            int height = event.resolution.func_78328_b();
            Spell spell = WandHelper.getCurrentSpell(player.func_70694_bm());
            int cooldown = WandHelper.getCurrentCooldown(player.func_70694_bm());
            float cooldownMultiplier = 1.0f - (float)WandHelper.getUpgradeLevel(player.func_70694_bm(), Wizardry.cooldownUpgrade) * 0.15f;
            if (player.func_70644_a(Wizardry.fontOfMana)) {
                cooldownMultiplier /= (float)(2 + player.func_70660_b(Wizardry.fontOfMana).func_76458_c());
            }
            int left = 0;
            int top = 0;
            boolean mirror = false;
            if (Wizardry.spellHUDPosition.equals("Bottom left")) {
                left = 0;
                top = height - 36;
            } else if (Wizardry.spellHUDPosition.equals("Top left")) {
                left = 0;
                top = 0;
            } else if (Wizardry.spellHUDPosition.equals("Top right")) {
                left = width - 128;
                top = 0;
                mirror = true;
            } else if (Wizardry.spellHUDPosition.equals("Bottom right")) {
                left = width - 128;
                top = height - 36;
                mirror = true;
            }
            boolean discovered = true;
            if (!player.field_71075_bZ.field_75098_d && ExtendedPlayer.get((EntityPlayer)player) != null) {
                discovered = ExtendedPlayer.get((EntityPlayer)player).hasSpellBeenDiscovered(spell);
            }
            if (event.type == RenderGameOverlayEvent.ElementType.TEXT) {
                String colour;
                String string = colour = cooldown > 0 || player.func_70644_a(Wizardry.arcaneJammer) ? "\u00a78" : spell.element.colour;
                if (!discovered) {
                    colour = "\u00a79";
                }
                String spellName = discovered ? spell.getDisplayName() : SpellGlyphData.getGlyphName(spell, player.field_70170_p);
                FontRenderer font = discovered ? this.mc.field_71466_p : this.mc.field_71464_q;
                int maxWidth = 90;
                if (font.func_78256_a(spellName) <= maxWidth) {
                    font.func_78261_a(colour + spellName, mirror ? left + 5 : left + 41, top + 13, -1);
                } else {
                    int lineNumber = 0;
                    List lines = font.func_78271_c(spellName, maxWidth);
                    for (Object line : lines) {
                        if (line instanceof String) {
                            font.func_78261_a(colour + (String)line, mirror ? left + 5 : left + 41, top + 6 + 11 * lineNumber, -1);
                        }
                        ++lineNumber;
                    }
                }
            } else if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                this.mc.field_71446_o.func_110577_a(hudTexture);
                this.func_73729_b(left, top, 0, mirror ? 36 : 0, 128, 36);
                if (cooldown > 0) {
                    this.func_73729_b(mirror ? left + 5 : left + 41, height - 8, 128, 6, 82, 6);
                    int l = (int)((double)((float)spell.cooldown * cooldownMultiplier - (float)cooldown) / (double)((float)spell.cooldown * cooldownMultiplier) * 82.0);
                    this.func_73729_b(mirror ? left + 5 : left + 41, height - 8, 128, 0, l, 6);
                }
                this.mc.field_71446_o.func_110577_a(discovered ? spell.icon : WizardryRegistry.none.icon);
                GuiSpellDisplay.drawTexturedRect(mirror ? left + 94 : left + 2, top + 2, 0, 0, 32, 32, 32, 32);
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
        }
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        float f = 1.0f / (float)textureWidth;
        float f1 = 1.0f / (float)textureHeight;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), 0.0, (double)((float)u * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)((float)(u + width) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)y, 0.0, (double)((float)(u + width) * f), (double)((float)v * f1));
        tessellator.func_78374_a((double)x, (double)y, 0.0, (double)((float)u * f), (double)((float)v * f1));
        tessellator.func_78381_a();
    }
}

