/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.ClientProxy;
import electroblob.wizardry.client.GuiButtonInvisible;
import electroblob.wizardry.client.GuiButtonNextPage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.Charsets;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiWizardHandbook
extends GuiScreen {
    private GuiButtonNextPage nextPageBtn;
    private GuiButtonNextPage prevPageBtn;
    private int xSize = 288;
    private int ySize = 180;
    private int pageNumber = 0;
    private static final int pageWidth = 120;
    public static final ResourceLocation regularHandbook = new ResourceLocation("wizardry", "textures/gui/handbook.png");
    public static final ResourceLocation ore = new ResourceLocation("wizardry", "textures/gui/ore_picture.png");
    public static final ResourceLocation crystal = new ResourceLocation("wizardry", "textures/items/magic_crystal.png");
    public static final ResourceLocation workbenchGui = new ResourceLocation("wizardry", "textures/gui/arcane_workbench.png");
    public static final ResourceLocation craftingGrids = new ResourceLocation("wizardry", "textures/gui/handbook_recipes.png");
    private ArrayList<ArrayList<String>> text;
    private ArrayList<Section> sections;
    private int guiPage;
    private int imagePage;

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        ItemStack craftingResult;
        ItemStack[][] craftingGrid;
        ArrayList list;
        int xPos = this.field_146294_l / 2 - this.xSize / 2;
        int yPos = this.field_146295_m / 2 - this.ySize / 2;
        if (this.pageNumber >= (this.sections.get((int)(this.sections.size() - 1)).pageNumber - 1) / 2 && this.pageNumber < (this.sections.get((int)(this.sections.size() - 1)).pageNumber - 1) / 2 + 4) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(craftingGrids);
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(regularHandbook);
        }
        this.drawTexturedRect(xPos, yPos, 0, 0, this.xSize, this.ySize, this.xSize, 256);
        if (this.pageNumber == (this.guiPage - 1) / 2) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(workbenchGui);
            this.func_73729_b(this.guiPage % 2 == 1 ? xPos + 17 : this.field_146294_l / 2 + 7, yPos + 14, 28, 12, 120, 118);
        }
        if (this.pageNumber == (this.imagePage - 1) / 2) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ore);
            this.drawTexturedRect(this.imagePage % 2 == 1 ? xPos + 17 : this.field_146294_l / 2 + 7, yPos + 80, 0, 0, 64, 64, 64, 64);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(crystal);
            this.drawTexturedStretchedRect(this.imagePage % 2 == 1 ? xPos + 17 + 64 : this.field_146294_l / 2 + 7 + 62, yPos + 80, 0, 0, 64, 64, 1, 1);
        }
        this.field_146289_q.func_78276_b("" + (this.pageNumber * 2 + 1), xPos + this.xSize / 4 - 3, yPos + this.ySize - 20, 0);
        this.field_146289_q.func_78276_b("" + (this.pageNumber * 2 + 2), xPos + 3 * this.xSize / 4 - 5, yPos + this.ySize - 20, 0);
        super.func_73863_a(mouseX, mouseY, par3);
        int lineNumber = 0;
        if (this.pageNumber == 1) {
            int row = 2;
            for (Section s : this.sections) {
                s.drawContents();
                ++row;
            }
        } else {
            for (Section s : this.sections) {
                s.hideButton();
            }
        }
        for (String paragraph : this.text.get(this.pageNumber * 2)) {
            this.field_146289_q.func_78279_b(paragraph, xPos + 17, yPos + 14 + lineNumber * this.field_146289_q.field_78288_b, 120, 0);
            list = new ArrayList(this.field_146289_q.func_78271_c(paragraph, 120));
            lineNumber += list.size();
        }
        lineNumber = 0;
        if (this.text.size() > this.pageNumber * 2 + 1) {
            for (String paragraph : this.text.get(this.pageNumber * 2 + 1)) {
                if (this.pageNumber == 0) {
                    int startX = this.field_146294_l / 2 + 7 + 60 - this.field_146289_q.func_78256_a(paragraph) / 2;
                    this.field_146289_q.func_78279_b(paragraph, startX, yPos + 14 + lineNumber * this.field_146289_q.field_78288_b, 120, 0);
                } else {
                    this.field_146289_q.func_78279_b(paragraph, this.field_146294_l / 2 + 7, yPos + 14 + lineNumber * this.field_146289_q.field_78288_b, 120, 0);
                }
                list = new ArrayList(this.field_146289_q.func_78271_c(paragraph, 120));
                lineNumber += list.size();
            }
        }
        if (this.pageNumber == (this.sections.get((int)(this.sections.size() - 1)).pageNumber - 1) / 2) {
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Items.field_151074_bl);
            craftingGrid[1][0] = new ItemStack(Blocks.field_150404_cg, 1, 10);
            craftingGrid[2][0] = new ItemStack(Items.field_151074_bl);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][1] = new ItemStack(Blocks.field_150368_y);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[0][2] = new ItemStack(Blocks.field_150348_b);
            craftingGrid[1][2] = new ItemStack(Blocks.field_150348_b);
            craftingGrid[2][2] = new ItemStack(Blocks.field_150348_b);
            craftingResult = new ItemStack(Wizardry.arcaneWorkbench);
            this.renderCraftingRecipe(xPos + 23, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[2][0] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][1] = new ItemStack(Items.field_151055_y);
            craftingGrid[0][2] = new ItemStack(Items.field_151074_bl);
            craftingResult = new ItemStack(Wizardry.magicWand);
            this.renderCraftingRecipe(xPos + 23, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[1][0] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][1] = new ItemStack(Items.field_151122_aG);
            craftingGrid[1][2] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicCrystal);
            craftingResult = new ItemStack(Wizardry.spellBook, 1, 1);
            this.renderCraftingRecipe(xPos + 156, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Items.field_151122_aG);
            craftingGrid[1][0] = new ItemStack(Wizardry.magicCrystal);
            craftingResult = new ItemStack(Wizardry.wizardHandbook);
            this.renderCraftingRecipe(xPos + 156, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
        } else if (this.pageNumber == (this.sections.get((int)(this.sections.size() - 1)).pageNumber - 1) / 2 + 1) {
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Wizardry.crystalFlower);
            craftingResult = new ItemStack(Wizardry.magicCrystal, 2);
            this.renderCraftingRecipe(xPos + 23, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][0] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[2][0] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][1] = new ItemStack(Items.field_151069_bo);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[0][2] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][2] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[2][2] = new ItemStack(Wizardry.magicCrystal);
            craftingResult = new ItemStack(Wizardry.manaFlask);
            this.renderCraftingRecipe(xPos + 23, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[1][0] = new ItemStack(Blocks.field_150348_b);
            craftingGrid[0][1] = new ItemStack(Blocks.field_150348_b);
            craftingGrid[1][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][2] = new ItemStack(Blocks.field_150348_b);
            craftingGrid[2][1] = new ItemStack(Blocks.field_150348_b);
            craftingResult = new ItemStack(Wizardry.transportationStone, 2);
            this.renderCraftingRecipe(xPos + 156, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[1][0] = new ItemStack(Items.field_151007_F);
            craftingGrid[0][1] = new ItemStack(Items.field_151007_F);
            craftingGrid[1][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][2] = new ItemStack(Items.field_151007_F);
            craftingGrid[2][1] = new ItemStack(Items.field_151007_F);
            craftingResult = new ItemStack(Wizardry.magicSilk, 2);
            this.renderCraftingRecipe(xPos + 156, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
        } else if (this.pageNumber == (this.sections.get((int)(this.sections.size() - 1)).pageNumber - 1) / 2 + 2) {
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[1][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicSilk);
            craftingResult = new ItemStack(Wizardry.wizardHat);
            this.renderCraftingRecipe(xPos + 23, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[1][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[0][2] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[1][2] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][2] = new ItemStack(Wizardry.magicSilk);
            craftingResult = new ItemStack(Wizardry.wizardRobe);
            this.renderCraftingRecipe(xPos + 23, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[1][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[0][2] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][2] = new ItemStack(Wizardry.magicSilk);
            craftingResult = new ItemStack(Wizardry.wizardLeggings);
            this.renderCraftingRecipe(xPos + 156, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicSilk);
            craftingResult = new ItemStack(Wizardry.wizardBoots);
            this.renderCraftingRecipe(xPos + 156, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
        } else if (this.pageNumber == (this.sections.get((int)(this.sections.size() - 1)).pageNumber - 1) / 2 + 3) {
            if (Wizardry.useAlternateScrollRecipe) {
                craftingGrid = new ItemStack[3][3];
                craftingGrid[0][0] = new ItemStack(Items.field_151121_aF);
                craftingGrid[1][0] = new ItemStack(Items.field_151007_F);
                craftingGrid[2][0] = new ItemStack(Wizardry.magicCrystal);
                craftingResult = new ItemStack(Wizardry.blankScroll);
                this.renderCraftingRecipe(xPos + 23, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            } else {
                craftingGrid = new ItemStack[3][3];
                craftingGrid[0][0] = new ItemStack(Items.field_151121_aF);
                craftingGrid[1][0] = new ItemStack(Items.field_151007_F);
                craftingResult = new ItemStack(Wizardry.blankScroll);
                this.renderCraftingRecipe(xPos + 23, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            }
            if (Wizardry.firebombIsCraftable) {
                craftingGrid = new ItemStack[3][3];
                craftingGrid[0][0] = new ItemStack(Items.field_151065_br);
                craftingGrid[1][0] = new ItemStack(Items.field_151065_br);
                craftingGrid[0][1] = new ItemStack(Items.field_151069_bo);
                craftingGrid[1][1] = new ItemStack(Items.field_151016_H);
                craftingResult = new ItemStack(Wizardry.firebomb, 3);
                this.renderCraftingRecipe(xPos + 23, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
            }
            if (Wizardry.poisonBombIsCraftable) {
                craftingGrid = new ItemStack[3][3];
                craftingGrid[0][0] = new ItemStack(Items.field_151070_bp);
                craftingGrid[1][0] = new ItemStack(Items.field_151070_bp);
                craftingGrid[0][1] = new ItemStack(Items.field_151069_bo);
                craftingGrid[1][1] = new ItemStack(Items.field_151016_H);
                craftingResult = new ItemStack(Wizardry.poisonBomb, 3);
                this.renderCraftingRecipe(xPos + 156, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            }
            if (Wizardry.smokeBombIsCraftable) {
                craftingGrid = new ItemStack[3][3];
                craftingGrid[0][0] = new ItemStack(Items.field_151044_h);
                craftingGrid[1][0] = new ItemStack(Items.field_151044_h);
                craftingGrid[0][1] = new ItemStack(Items.field_151069_bo);
                craftingGrid[1][1] = new ItemStack(Items.field_151016_H);
                craftingResult = new ItemStack(Wizardry.smokeBomb, 3);
                this.renderCraftingRecipe(xPos + 156, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
            }
        }
        if (this.pageNumber == (this.sections.get((int)(this.sections.size() - 1)).pageNumber - 1) / 2) {
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Items.field_151074_bl);
            craftingGrid[1][0] = new ItemStack(Blocks.field_150404_cg, 1, 10);
            craftingGrid[2][0] = new ItemStack(Items.field_151074_bl);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][1] = new ItemStack(Blocks.field_150368_y);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[0][2] = new ItemStack(Blocks.field_150348_b);
            craftingGrid[1][2] = new ItemStack(Blocks.field_150348_b);
            craftingGrid[2][2] = new ItemStack(Blocks.field_150348_b);
            craftingResult = new ItemStack(Wizardry.arcaneWorkbench);
            this.renderCraftingTooltips(xPos + 23, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[2][0] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][1] = new ItemStack(Items.field_151055_y);
            craftingGrid[0][2] = new ItemStack(Items.field_151074_bl);
            craftingResult = new ItemStack(Wizardry.magicWand);
            this.renderCraftingTooltips(xPos + 23, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[1][0] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][1] = new ItemStack(Items.field_151122_aG);
            craftingGrid[1][2] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicCrystal);
            craftingResult = new ItemStack(Wizardry.spellBook, 1, 1);
            this.renderCraftingTooltips(xPos + 156, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Items.field_151122_aG);
            craftingGrid[1][0] = new ItemStack(Wizardry.magicCrystal);
            craftingResult = new ItemStack(Wizardry.wizardHandbook);
            this.renderCraftingTooltips(xPos + 156, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
        } else if (this.pageNumber == (this.sections.get((int)(this.sections.size() - 1)).pageNumber - 1) / 2 + 1) {
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Wizardry.crystalFlower);
            craftingResult = new ItemStack(Wizardry.magicCrystal, 2);
            this.renderCraftingTooltips(xPos + 23, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][0] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[2][0] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][1] = new ItemStack(Items.field_151069_bo);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[0][2] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][2] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[2][2] = new ItemStack(Wizardry.magicCrystal);
            craftingResult = new ItemStack(Wizardry.manaFlask);
            this.renderCraftingTooltips(xPos + 23, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[1][0] = new ItemStack(Blocks.field_150348_b);
            craftingGrid[0][1] = new ItemStack(Blocks.field_150348_b);
            craftingGrid[1][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][2] = new ItemStack(Blocks.field_150348_b);
            craftingGrid[2][1] = new ItemStack(Blocks.field_150348_b);
            craftingResult = new ItemStack(Wizardry.transportationStone, 2);
            this.renderCraftingTooltips(xPos + 156, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[1][0] = new ItemStack(Items.field_151007_F);
            craftingGrid[0][1] = new ItemStack(Items.field_151007_F);
            craftingGrid[1][1] = new ItemStack(Wizardry.magicCrystal);
            craftingGrid[1][2] = new ItemStack(Items.field_151007_F);
            craftingGrid[2][1] = new ItemStack(Items.field_151007_F);
            craftingResult = new ItemStack(Wizardry.magicSilk, 2);
            this.renderCraftingTooltips(xPos + 156, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
        } else if (this.pageNumber == (this.sections.get((int)(this.sections.size() - 1)).pageNumber - 1) / 2 + 2) {
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[1][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicSilk);
            craftingResult = new ItemStack(Wizardry.wizardHat);
            this.renderCraftingTooltips(xPos + 23, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[1][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[0][2] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[1][2] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][2] = new ItemStack(Wizardry.magicSilk);
            craftingResult = new ItemStack(Wizardry.wizardRobe);
            this.renderCraftingTooltips(xPos + 23, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[1][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[0][2] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][2] = new ItemStack(Wizardry.magicSilk);
            craftingResult = new ItemStack(Wizardry.wizardLeggings);
            this.renderCraftingTooltips(xPos + 156, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            craftingGrid = new ItemStack[3][3];
            craftingGrid[0][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][0] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[0][1] = new ItemStack(Wizardry.magicSilk);
            craftingGrid[2][1] = new ItemStack(Wizardry.magicSilk);
            craftingResult = new ItemStack(Wizardry.wizardBoots);
            this.renderCraftingTooltips(xPos + 156, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
        } else if (this.pageNumber == (this.sections.get((int)(this.sections.size() - 1)).pageNumber - 1) / 2 + 3) {
            if (Wizardry.useAlternateScrollRecipe) {
                craftingGrid = new ItemStack[3][3];
                craftingGrid[0][0] = new ItemStack(Items.field_151121_aF);
                craftingGrid[1][0] = new ItemStack(Items.field_151007_F);
                craftingGrid[2][0] = new ItemStack(Wizardry.magicCrystal);
                craftingResult = new ItemStack(Wizardry.blankScroll);
                this.renderCraftingTooltips(xPos + 23, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            } else {
                craftingGrid = new ItemStack[3][3];
                craftingGrid[0][0] = new ItemStack(Items.field_151121_aF);
                craftingGrid[1][0] = new ItemStack(Items.field_151007_F);
                craftingResult = new ItemStack(Wizardry.blankScroll);
                this.renderCraftingTooltips(xPos + 23, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            }
            if (Wizardry.firebombIsCraftable) {
                craftingGrid = new ItemStack[3][3];
                craftingGrid[0][0] = new ItemStack(Items.field_151065_br);
                craftingGrid[1][0] = new ItemStack(Items.field_151065_br);
                craftingGrid[0][1] = new ItemStack(Items.field_151069_bo);
                craftingGrid[1][1] = new ItemStack(Items.field_151016_H);
                craftingResult = new ItemStack(Wizardry.firebomb, 3);
                this.renderCraftingTooltips(xPos + 23, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
            }
            if (Wizardry.poisonBombIsCraftable) {
                craftingGrid = new ItemStack[3][3];
                craftingGrid[0][0] = new ItemStack(Items.field_151070_bp);
                craftingGrid[1][0] = new ItemStack(Items.field_151070_bp);
                craftingGrid[0][1] = new ItemStack(Items.field_151069_bo);
                craftingGrid[1][1] = new ItemStack(Items.field_151016_H);
                craftingResult = new ItemStack(Wizardry.poisonBomb, 3);
                this.renderCraftingTooltips(xPos + 156, yPos + 39, mouseX, mouseY, craftingGrid, craftingResult);
            }
            if (Wizardry.smokeBombIsCraftable) {
                craftingGrid = new ItemStack[3][3];
                craftingGrid[0][0] = new ItemStack(Items.field_151044_h);
                craftingGrid[1][0] = new ItemStack(Items.field_151044_h);
                craftingGrid[0][1] = new ItemStack(Items.field_151069_bo);
                craftingGrid[1][1] = new ItemStack(Items.field_151016_H);
                craftingResult = new ItemStack(Wizardry.smokeBomb, 3);
                this.renderCraftingTooltips(xPos + 156, yPos + 98, mouseX, mouseY, craftingGrid, craftingResult);
            }
        }
    }

    private void renderCraftingRecipe(int xPos, int yPos, int mouseX, int mouseY, ItemStack[][] craftingGrid, ItemStack craftingResult) {
        int guiLeft = this.field_146294_l / 2 - this.xSize / 2;
        int guiTop = this.field_146295_m / 2 - this.ySize / 2;
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        GuiWizardHandbook.field_146296_j.field_77023_b = 100.0f;
        for (int i = 0; i < craftingGrid.length; ++i) {
            for (int j = 0; j < craftingGrid[i].length; ++j) {
                if (craftingGrid[i][j] == null) continue;
                field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), craftingGrid[i][j], xPos + 18 * i, yPos + 18 * j);
                field_146296_j.func_77021_b(this.field_146289_q, this.field_146297_k.func_110434_K(), craftingGrid[i][j], xPos + 18 * i, yPos + 18 * j);
            }
        }
        if (craftingResult != null) {
            field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), craftingResult, xPos + 86, yPos + 18);
            field_146296_j.func_77021_b(this.field_146289_q, this.field_146297_k.func_110434_K(), craftingResult, xPos + 86, yPos + 18);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
    }

    private void renderCraftingTooltips(int xPos, int yPos, int mouseX, int mouseY, ItemStack[][] craftingGrid, ItemStack craftingResult) {
        int guiLeft = this.field_146294_l / 2 - this.xSize / 2;
        int guiTop = this.field_146295_m / 2 - this.ySize / 2;
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GuiWizardHandbook.field_146296_j.field_77023_b = 0.0f;
        GL11.glDisable((int)2896);
        for (int i = 0; i < craftingGrid.length; ++i) {
            for (int j = 0; j < craftingGrid[i].length; ++j) {
                if (craftingGrid[i][j] == null || !this.isPointInRegion(xPos + 18 * i, yPos + 18 * j, 16, 16, mouseX + guiLeft, mouseY + guiTop)) continue;
                this.drawItemStackTooltip(craftingGrid[i][j], mouseX, mouseY);
            }
        }
        if (craftingResult != null && this.isPointInRegion(xPos + 86, yPos + 18, 16, 16, mouseX + guiLeft, mouseY + guiTop)) {
            this.drawItemStackTooltip(craftingResult, mouseX, mouseY);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        int nextButtonId = 0;
        this.field_146292_n.clear();
        this.nextPageBtn = new GuiButtonNextPage(nextButtonId++, this.field_146294_l / 2 + this.xSize / 2 - 22 - 23, this.field_146295_m / 2 + this.ySize / 2 - 10 - 13, true);
        this.field_146292_n.add(this.nextPageBtn);
        this.prevPageBtn = new GuiButtonNextPage(nextButtonId++, this.field_146294_l / 2 - this.xSize / 2 + 21, this.field_146295_m / 2 + this.ySize / 2 - 10 - 13, false);
        this.field_146292_n.add(this.prevPageBtn);
        this.text = new ArrayList(1);
        this.sections = new ArrayList(1);
        BufferedReader bufferedreader = null;
        String textFilepath = "wizardry:texts/handbook_" + Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a() + ".txt";
        try {
            bufferedreader = new BufferedReader(new InputStreamReader(this.field_146297_k.func_110442_L().func_110536_a(new ResourceLocation(textFilepath)).func_110527_b(), Charsets.UTF_8));
        }
        catch (IOException e) {
            System.out.println("Warning: wizard handbook text file missing for the current language. Using default (English - US) instead.");
            textFilepath = "wizardry:texts/handbook_en_US.txt";
            try {
                bufferedreader = new BufferedReader(new InputStreamReader(this.field_146297_k.func_110442_L().func_110536_a(new ResourceLocation(textFilepath)).func_110527_b(), Charsets.UTF_8));
            }
            catch (IOException x) {
                System.err.println("Couldn't find file: wizardry:assets/texts/handbook_en_US.txt. The file may be missing; please try re-downloading and reinstalling wizardry.");
                x.printStackTrace();
            }
        }
        if (bufferedreader != null) {
            try {
                String paragraph = bufferedreader.readLine();
                ArrayList<String> page = new ArrayList<String>(1);
                int linesPerPage = 16;
                int lineNumber = 0;
                while (paragraph != null) {
                    if (paragraph.contains("PAGEBREAK") || lineNumber >= linesPerPage) {
                        this.text.add(page);
                        page = new ArrayList(1);
                        lineNumber = 0;
                        if (!paragraph.contains("PAGEBREAK")) continue;
                        paragraph = bufferedreader.readLine();
                        continue;
                    }
                    if (paragraph.contains("LINEBREAK")) {
                        ++lineNumber;
                        page.add("");
                        paragraph = bufferedreader.readLine();
                        continue;
                    }
                    if (paragraph.contains("SECTION")) {
                        this.sections.add(new Section(paragraph.replace("SECTION ", ""), this.text.size() + 1, this.field_146294_l / 2 + 7, this.field_146295_m / 2 - this.ySize / 2 + 14 + (this.sections.size() + 2) * this.field_146289_q.field_78288_b, nextButtonId++));
                        paragraph = bufferedreader.readLine();
                        continue;
                    }
                    if (paragraph.contains("IMAGE")) {
                        if (paragraph.contains("WORKBENCH")) {
                            this.guiPage = this.text.size() + 1;
                        } else if (paragraph.contains("CRYSTAL")) {
                            this.imagePage = this.text.size() + 1;
                        }
                        paragraph = bufferedreader.readLine();
                        continue;
                    }
                    paragraph = paragraph.replaceAll("NEXT_SPELL_KEY", Keyboard.getKeyName((int)ClientProxy.nextSpell.func_151463_i()));
                    paragraph = paragraph.replaceAll("PREVIOUS_SPELL_KEY", Keyboard.getKeyName((int)ClientProxy.previousSpell.func_151463_i()));
                    paragraph = paragraph.replaceAll("MANA_PER_CRYSTAL_MINUS_30", "70");
                    paragraph = paragraph.replaceAll("MANA_PER_CRYSTAL", "100");
                    paragraph = paragraph.replaceAll("BASIC_MAX_CHARGE", "" + EnumTier.BASIC.maxCharge);
                    paragraph = paragraph.replaceAll("APPRENTICE_MAX_CHARGE", "" + EnumTier.APPRENTICE.maxCharge);
                    paragraph = paragraph.replaceAll("ADVANCED_MAX_CHARGE", "" + EnumTier.ADVANCED.maxCharge);
                    paragraph = paragraph.replaceAll("MASTER_MAX_CHARGE", "" + EnumTier.MASTER.maxCharge);
                    paragraph = paragraph.replaceAll("BASIC_COLOUR", "\u00a77");
                    paragraph = paragraph.replaceAll("APPRENTICE_COLOUR", EnumTier.APPRENTICE.colour);
                    paragraph = paragraph.replaceAll("ADVANCED_COLOUR", EnumTier.ADVANCED.colour);
                    paragraph = paragraph.replaceAll("MASTER_COLOUR", EnumTier.MASTER.colour);
                    paragraph = paragraph.replaceAll("FIRE_COLOUR", EnumElement.FIRE.colour);
                    paragraph = paragraph.replaceAll("ICE_COLOUR", EnumElement.ICE.colour);
                    paragraph = paragraph.replaceAll("LIGHTNING_COLOUR", EnumElement.LIGHTNING.colour);
                    paragraph = paragraph.replaceAll("NECROMANCY_COLOUR", EnumElement.NECROMANCY.colour);
                    paragraph = paragraph.replaceAll("EARTH_COLOUR", EnumElement.EARTH.colour);
                    paragraph = paragraph.replaceAll("SORCERY_COLOUR", EnumElement.SORCERY.colour);
                    paragraph = paragraph.replaceAll("HEALING_COLOUR", EnumElement.HEALING.colour);
                    paragraph = paragraph.replaceAll("RESET_COLOUR", "\u00a70");
                    paragraph = paragraph.replaceAll("VERSION", "1.1.4");
                    int linesInParagraph = this.field_146289_q.func_78271_c(paragraph, 120).size();
                    if (paragraph.isEmpty() && lineNumber == 0) {
                        paragraph = bufferedreader.readLine();
                        continue;
                    }
                    if (lineNumber + linesInParagraph <= linesPerPage) {
                        page.add(paragraph);
                        lineNumber += linesInParagraph;
                        paragraph = bufferedreader.readLine();
                        continue;
                    }
                    int linesInFirstPart = linesPerPage - lineNumber;
                    String paragraphFirstPart = "";
                    String paragraphLastPart = "";
                    int i = 0;
                    List strings = this.field_146289_q.func_78271_c(paragraph, 120);
                    for (Object s : strings) {
                        if (i < linesInFirstPart) {
                            paragraphFirstPart = paragraphFirstPart.concat((String)s + " ");
                        } else {
                            paragraphLastPart = paragraphLastPart.concat((String)s + " ");
                        }
                        ++i;
                    }
                    page.add(paragraphFirstPart);
                    lineNumber += linesInFirstPart;
                    paragraph = paragraphLastPart;
                }
                this.text.add(page);
            }
            catch (IOException e) {
                System.err.println("Something went wrong reading file: " + textFilepath + ". The file may be damaged; please try re-downloading and reinstalling wizardry.");
                e.printStackTrace();
            }
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            if (par1GuiButton.field_146127_k == 0) {
                if (this.pageNumber < (this.text.size() - 1) / 2) {
                    ++this.pageNumber;
                }
            } else if (par1GuiButton.field_146127_k == 1) {
                if (this.pageNumber > 0) {
                    --this.pageNumber;
                }
            } else if (this.pageNumber == 1) {
                this.pageNumber = (this.sections.get((int)(par1GuiButton.field_146127_k - 2)).pageNumber - 1) / 2;
            }
        }
    }

    protected boolean isPointInRegion(int par1, int par2, int par3, int par4, int par5, int par6) {
        int k1 = this.field_146294_l / 2 - this.xSize / 2;
        int l1 = this.field_146295_m / 2 - this.ySize / 2;
        return (par5 -= k1) >= par1 - 1 && par5 < par1 + par3 + 1 && (par6 -= l1) >= par2 - 1 && par6 < par2 + par4 + 1;
    }

    protected void drawItemStackTooltip(ItemStack par1ItemStack, int par2, int par3) {
        List list = par1ItemStack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, par1ItemStack.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        FontRenderer font = par1ItemStack.func_77973_b().getFontRenderer(par1ItemStack);
        this.drawHoveringText(list, par2, par3, font == null ? this.field_146289_q : font);
    }

    protected void drawHoveringText(List par1List, int par2, int par3, FontRenderer font) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_146294_l) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_146295_m) {
                j1 = this.field_146295_m - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            GuiWizardHandbook.field_146296_j.field_77023_b = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = (String)par1List.get(k2);
                font.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            GuiWizardHandbook.field_146296_j.field_77023_b = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }

    public void drawTexturedRect(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        float f = 1.0f / (float)textureWidth;
        float f1 = 1.0f / (float)textureHeight;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), 0.0, (double)((float)u * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)((float)(u + width) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)y, 0.0, (double)((float)(u + width) * f), (double)((float)v * f1));
        tessellator.func_78374_a((double)x, (double)y, 0.0, (double)((float)u * f), (double)((float)v * f1));
        tessellator.func_78381_a();
    }

    public void drawTexturedStretchedRect(int x, int y, int u, int v, int finalWidth, int finalHeight, int width, int height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + finalHeight), 0.0, (double)u, (double)(v + height));
        tessellator.func_78374_a((double)(x + finalWidth), (double)(y + finalHeight), 0.0, (double)(u + width), (double)(v + height));
        tessellator.func_78374_a((double)(x + finalWidth), (double)y, 0.0, (double)(u + width), (double)v);
        tessellator.func_78374_a((double)x, (double)y, 0.0, (double)u, (double)v);
        tessellator.func_78381_a();
    }

    private class Section {
        String name;
        int pageNumber;
        int x;
        int y;
        int buttonId;

        Section(String name, int pageNumber, int x, int y, int id) {
            this.name = name;
            this.pageNumber = pageNumber;
            this.x = x;
            this.y = y;
            this.buttonId = id;
            GuiWizardHandbook.this.field_146292_n.add(new GuiButtonInvisible(id, x, y, 120, ((GuiWizardHandbook)GuiWizardHandbook.this).field_146289_q.field_78288_b));
        }

        void hideButton() {
            ((GuiButton)((GuiWizardHandbook)GuiWizardHandbook.this).field_146292_n.get((int)this.buttonId)).field_146125_m = false;
        }

        void drawContents() {
            ((GuiButton)((GuiWizardHandbook)GuiWizardHandbook.this).field_146292_n.get((int)this.buttonId)).field_146125_m = true;
            GuiWizardHandbook.this.field_146289_q.func_78276_b(this.name, this.x, this.y, ((GuiButton)GuiWizardHandbook.this.field_146292_n.get(this.buttonId)).func_146115_a() ? 14502941 : 0);
            int nameWidth = GuiWizardHandbook.this.field_146289_q.func_78256_a(this.name);
            String dotsAndNumber = " " + this.pageNumber;
            while (GuiWizardHandbook.this.field_146289_q.func_78256_a(dotsAndNumber) < 120 - nameWidth - 2) {
                dotsAndNumber = "." + dotsAndNumber;
            }
            GuiWizardHandbook.this.field_146289_q.func_78276_b(dotsAndNumber, this.x + 120 - GuiWizardHandbook.this.field_146289_q.func_78256_a(dotsAndNumber), this.y, 0);
        }
    }
}

