/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.renderer;

class RayHelper
implements Comparable<RayHelper> {
    int ordinal;
    double x1;
    double y1;
    double z1;
    double x2;
    double y2;
    double z2;
    double offsetX;
    double offsetY;
    double offsetZ;

    RayHelper(int ordinal, double x1, double y1, double z1, double x2, double y2, double z2, double offsetX, double offsetY, double offsetZ) {
        this.ordinal = ordinal;
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    double getDistanceFromViewpoint() {
        double midX = (this.x1 + this.x2) / 2.0;
        double midY = (this.y1 + this.y2) / 2.0;
        double midZ = (this.z1 + this.z2) / 2.0;
        double absoluteX = this.offsetX + midX;
        double absoluteY = this.offsetY + midY;
        double absoluteZ = this.offsetZ + midZ;
        return Math.sqrt(absoluteX * absoluteX + absoluteY * absoluteY + absoluteZ * absoluteZ);
    }

    @Override
    public int compareTo(RayHelper ray) {
        if (this.getDistanceFromViewpoint() > ray.getDistanceFromViewpoint()) {
            return -1;
        }
        if (this.getDistanceFromViewpoint() < ray.getDistanceFromViewpoint()) {
            return 1;
        }
        return 0;
    }
}

