/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityMagicSlime
extends EntityLiving
implements IEntityAdditionalSpawnData {
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private int slimeJumpDelay;
    private int lifetime;

    public EntityMagicSlime(World par1World) {
        super(par1World);
        this.field_70129_M = 0.0f;
        this.slimeJumpDelay = this.field_70146_Z.nextInt(20) + 10;
        this.setSlimeSize(2);
    }

    public EntityMagicSlime(World world, int lifetime) {
        this(world);
        this.lifetime = lifetime;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(1));
    }

    protected void setSlimeSize(int par1) {
        this.field_70180_af.func_75692_b(16, (Object)new Byte((byte)par1));
        this.func_70105_a(0.6f * (float)par1, 0.6f * (float)par1);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(par1 * par1));
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV = par1;
    }

    public int getSlimeSize() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Size", this.getSlimeSize() - 1);
        par1NBTTagCompound.func_74768_a("lifetime", this.lifetime);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setSlimeSize(par1NBTTagCompound.func_74762_e("Size") + 1);
        this.lifetime = par1NBTTagCompound.func_74762_e("lifetime");
    }

    protected String getSlimeParticle() {
        return "slime";
    }

    protected String getJumpSound() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    public void func_70071_h_() {
        double z;
        double y;
        double x;
        int i;
        if (this.field_70173_aa > this.lifetime) {
            this.func_70106_y();
            for (i = 0; i < 30; ++i) {
                x = this.field_70165_t - 0.5 + this.field_70146_Z.nextDouble();
                y = this.field_70163_u - 0.5 + this.field_70146_Z.nextDouble();
                z = this.field_70161_v - 0.5 + this.field_70146_Z.nextDouble();
                this.field_70170_p.func_72869_a("slime", x, y, z, (x - this.field_70165_t) * 2.0, (y - this.field_70163_u) * 2.0, (z - this.field_70161_v) * 2.0);
            }
            this.func_85030_a("mob.slime.attack", 2.5f, 0.6f);
            this.func_85030_a("fireworks.blast_far", 1.0f, 0.5f);
        }
        if (this.field_70154_o != null && this.field_70154_o instanceof EntityLivingBase && ((EntityLivingBase)this.field_70154_o).func_110143_aJ() > 0.0f) {
            if (this.field_70173_aa % 16 == 1) {
                this.field_70154_o.func_70097_a(DamageSource.field_76376_m, 1.0f);
                ((EntityLivingBase)this.field_70154_o).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 20, 2));
                this.func_85030_a("mob.slime.attack", 1.0f, 1.0f);
                this.squishAmount = 0.5f;
            }
        } else {
            this.func_70106_y();
            for (i = 0; i < 30; ++i) {
                x = this.field_70165_t - 0.5 + this.field_70146_Z.nextDouble();
                y = this.field_70163_u - 0.5 + this.field_70146_Z.nextDouble();
                z = this.field_70161_v - 0.5 + this.field_70146_Z.nextDouble();
                this.field_70170_p.func_72869_a("slime", x, y, z, (x - this.field_70165_t) * 2.0, (y - this.field_70163_u) * 2.0, (z - this.field_70161_v) * 2.0);
            }
            this.func_85030_a("mob.slime.attack", 2.5f, 0.6f);
            this.func_85030_a("fireworks.blast_far", 1.0f, 0.5f);
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        boolean flag = this.field_70122_E;
        super.func_70071_h_();
        if (this.field_70122_E && !flag) {
            int i2 = this.getSlimeSize();
            for (int j = 0; j < i2 * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i2 * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i2 * 0.5f * f1;
                this.field_70170_p.func_72869_a(this.getSlimeParticle(), this.field_70165_t + (double)f2, this.field_70121_D.field_72338_b, this.field_70161_v + (double)f3, 0.0, 0.0, 0.0);
            }
            if (this.makesSoundOnLand()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && flag) {
            this.squishAmount = 1.0f;
        }
        this.alterSquishAmount();
        if (this.field_70170_p.field_72995_K) {
            int i3 = this.getSlimeSize();
            this.func_70105_a(0.6f * (float)i3, 0.6f * (float)i3);
        }
    }

    protected void func_70626_be() {
        this.func_70623_bb();
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        if (entityplayer != null) {
            this.func_70625_a((Entity)entityplayer, 10.0f, 20.0f);
        }
        if (this.field_70122_E && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.getJumpDelay();
            if (entityplayer != null) {
                this.slimeJumpDelay /= 3;
            }
            this.field_70703_bu = true;
            if (this.makesSoundOnJump()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_70702_br = 1.0f - this.field_70146_Z.nextFloat() * 2.0f;
            this.field_70701_bs = 1 * this.getSlimeSize();
        } else {
            this.field_70703_bu = false;
            if (this.field_70122_E) {
                this.field_70701_bs = 0.0f;
                this.field_70702_br = 0.0f;
            }
        }
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    protected EntityMagicSlime createInstance() {
        return new EntityMagicSlime(this.field_70170_p);
    }

    public void func_70106_y() {
        int i = this.getSlimeSize();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntityMagicSlime entityslime = this.createInstance();
                entityslime.setSlimeSize(i / 2);
                entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityslime);
            }
        }
        super.func_70106_y();
    }

    protected String func_70621_aR() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected String func_70673_aS() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected int getDropItemId() {
        return -1;
    }

    protected float func_70599_aP() {
        return 0.4f * (float)this.getSlimeSize();
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return this.getSlimeSize() > 0;
    }

    protected boolean makesSoundOnLand() {
        return this.getSlimeSize() > 2;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.lifetime);
    }

    public void readSpawnData(ByteBuf data) {
        this.lifetime = data.readInt();
    }
}

