/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.ExtendedPlayer;
import electroblob.wizardry.WandHelper;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryRegistry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.ContainerArcaneWorkbench;
import electroblob.wizardry.tileentity.TileEntityArcaneWorkbench;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;

public class PacketControlInput
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            int eventID = message.eventID;
            EntityPlayerMP entityplayer = ctx.getServerHandler().field_147369_b;
            if (eventID == 0) {
                TileEntityArcaneWorkbench tileentity = ((ContainerArcaneWorkbench)entityplayer.field_71070_bA).tileEntityArcaneWorkbench;
                ItemStack wand = tileentity.func_70301_a(9);
                ItemStack[] spellBooks = new ItemStack[8];
                for (int i = 0; i < spellBooks.length; ++i) {
                    spellBooks[i] = tileentity.func_70301_a(i);
                }
                ItemStack crystals = tileentity.func_70301_a(8);
                ItemStack upgrade = tileentity.func_70301_a(10);
                if (wand != null && wand.func_77973_b() instanceof ItemWand) {
                    Spell[] spells;
                    if (upgrade != null) {
                        if (upgrade.func_77973_b() == Wizardry.arcaneTome) {
                            switch (EnumTier.values()[upgrade.func_77960_j()]) {
                                case APPRENTICE: {
                                    if (((ItemWand)wand.func_77973_b()).tier != EnumTier.BASIC) break;
                                    ItemStack newWand = new ItemStack(WizardryUtilities.getWand(EnumTier.values()[upgrade.func_77960_j()], ((ItemWand)wand.func_77973_b()).element));
                                    newWand.field_77990_d = wand.field_77990_d;
                                    newWand.func_77964_b(newWand.func_77958_k() - (wand.func_77958_k() - wand.func_77960_j()));
                                    tileentity.func_70299_a(9, newWand);
                                    tileentity.func_70299_a(10, null);
                                    entityplayer.func_71064_a((StatBase)Wizardry.apprentice, 1);
                                    break;
                                }
                                case ADVANCED: {
                                    if (((ItemWand)wand.func_77973_b()).tier != EnumTier.APPRENTICE) break;
                                    ItemStack newWand = new ItemStack(WizardryUtilities.getWand(EnumTier.values()[upgrade.func_77960_j()], ((ItemWand)wand.func_77973_b()).element));
                                    newWand.field_77990_d = wand.field_77990_d;
                                    newWand.func_77964_b(newWand.func_77958_k() - (wand.func_77958_k() - wand.func_77960_j()));
                                    tileentity.func_70299_a(9, newWand);
                                    tileentity.func_70299_a(10, null);
                                    break;
                                }
                                case MASTER: {
                                    if (((ItemWand)wand.func_77973_b()).tier != EnumTier.ADVANCED) break;
                                    ItemStack newWand = new ItemStack(WizardryUtilities.getWand(EnumTier.values()[upgrade.func_77960_j()], ((ItemWand)wand.func_77973_b()).element));
                                    newWand.field_77990_d = wand.field_77990_d;
                                    newWand.func_77964_b(newWand.func_77958_k() - (wand.func_77958_k() - wand.func_77960_j()));
                                    tileentity.func_70299_a(9, newWand);
                                    tileentity.func_70299_a(10, null);
                                    entityplayer.func_71064_a((StatBase)Wizardry.master, 1);
                                    break;
                                }
                            }
                            wand = tileentity.func_70301_a(9);
                        } else {
                            int prevMana = wand.func_77958_k() - wand.func_77960_j();
                            if (WandHelper.getTotalUpgrades(wand) < ((ItemWand)wand.func_77973_b()).tier.upgradeLimit && WandHelper.getUpgradeLevel(wand, upgrade.func_77973_b()) < 3) {
                                WandHelper.applyUpgrade(wand, upgrade.func_77973_b());
                                if (upgrade.func_77973_b() == Wizardry.storageUpgrade) {
                                    wand.func_77964_b(wand.func_77958_k() - prevMana);
                                }
                                if (upgrade.func_77973_b() == Wizardry.attunementUpgrade) {
                                    Spell[] spells2 = WandHelper.getSpells(wand);
                                    Spell[] newSpells = new Spell[5 + WandHelper.getUpgradeLevel(wand, Wizardry.attunementUpgrade)];
                                    for (int i = 0; i < newSpells.length; ++i) {
                                        newSpells[i] = i < spells2.length && spells2[i] != null ? spells2[i] : WizardryRegistry.none;
                                    }
                                    WandHelper.setSpells(wand, newSpells);
                                    int[] cooldown = WandHelper.getCooldowns(wand);
                                    int[] newCooldown = new int[5 + WandHelper.getUpgradeLevel(wand, Wizardry.attunementUpgrade)];
                                    if (cooldown.length > 0) {
                                        for (int i = 0; i < cooldown.length; ++i) {
                                            newCooldown[i] = cooldown[i];
                                        }
                                    }
                                    WandHelper.setCooldowns(wand, newCooldown);
                                }
                                tileentity.func_70298_a(10, 1);
                                entityplayer.func_71064_a((StatBase)Wizardry.specialUpgrade, 1);
                                if (WandHelper.getTotalUpgrades(wand) == EnumTier.MASTER.upgradeLimit) {
                                    entityplayer.func_71064_a((StatBase)Wizardry.maxOutWand, 1);
                                }
                            }
                        }
                    }
                    if ((spells = WandHelper.getSpells(wand)).length <= 0) {
                        spells = new Spell[5];
                    }
                    for (int i = 0; i < spells.length; ++i) {
                        if (spellBooks[i] == null || Spell.get((int)spellBooks[i].func_77960_j()).tier.level > ((ItemWand)wand.func_77973_b()).tier.level) continue;
                        spells[i] = Spell.get(spellBooks[i].func_77960_j());
                    }
                    WandHelper.setSpells(wand, spells);
                    if (crystals != null) {
                        int chargeDepleted = wand.func_77960_j();
                        if (crystals.field_77994_a * 100 < chargeDepleted) {
                            wand.func_77964_b(chargeDepleted - crystals.field_77994_a * 100);
                            tileentity.func_70298_a(8, crystals.field_77994_a);
                        } else if (chargeDepleted != 0) {
                            tileentity.func_70298_a(8, (int)Math.ceil((double)chargeDepleted / 100.0));
                            wand.func_77964_b(0);
                        }
                    }
                } else if (wand != null && wand.func_77973_b() instanceof ItemWizardArmour) {
                    if (upgrade != null && upgrade.func_77973_b() == Wizardry.armourUpgrade) {
                        if (!wand.func_77942_o()) {
                            wand.field_77990_d = new NBTTagCompound();
                        }
                        if (!wand.field_77990_d.func_74764_b("legendary")) {
                            wand.field_77990_d.func_74757_a("legendary", true);
                            tileentity.func_70299_a(10, null);
                            entityplayer.func_71029_a((StatBase)Wizardry.legendary);
                        }
                    }
                    if (crystals != null) {
                        int chargeDepleted = wand.func_77960_j();
                        if (crystals.field_77994_a * 100 < chargeDepleted) {
                            wand.func_77964_b(chargeDepleted - crystals.field_77994_a * 100);
                            tileentity.func_70298_a(8, crystals.field_77994_a);
                        } else if (chargeDepleted != 0) {
                            tileentity.func_70298_a(8, (int)Math.ceil((double)chargeDepleted / 100.0));
                            wand.func_77964_b(0);
                        }
                    }
                } else if (wand != null && wand.func_77973_b() == Wizardry.blankScroll && spellBooks[0] != null && (entityplayer.field_71075_bZ.field_75098_d || ExtendedPlayer.get((EntityPlayer)entityplayer) != null && ExtendedPlayer.get((EntityPlayer)entityplayer).hasSpellBeenDiscovered(Spell.get(spellBooks[0].func_77960_j()))) && crystals != null && crystals.field_77994_a * 100 > Spell.get((int)spellBooks[0].func_77960_j()).cost) {
                    tileentity.func_70298_a(8, (int)Math.ceil((double)Spell.get((int)spellBooks[0].func_77960_j()).cost / 100.0));
                    tileentity.func_70299_a(9, new ItemStack(Wizardry.scroll, 1, spellBooks[0].func_77960_j()));
                }
            } else if (eventID == 1) {
                if (entityplayer.field_71071_by.func_70448_g() != null && entityplayer.field_71071_by.func_70448_g().func_77973_b() instanceof ItemWand) {
                    ItemStack wand = entityplayer.field_71071_by.func_70448_g();
                    if (wand != null) {
                        WandHelper.selectNextSpell(wand);
                    }
                    entityplayer.func_71041_bz();
                }
            } else if (eventID == 2 && entityplayer.field_71071_by.func_70448_g() != null && entityplayer.field_71071_by.func_70448_g().func_77973_b() instanceof ItemWand) {
                ItemStack wand = entityplayer.field_71071_by.func_70448_g();
                if (wand != null) {
                    WandHelper.selectPreviousSpell(wand);
                }
                entityplayer.func_71041_bz();
            }
        }
        return null;
    }

    public static class Message
    implements IMessage {
        private int eventID;

        public Message() {
        }

        public Message(int eventID) {
            this.eventID = eventID;
        }

        public void fromBytes(ByteBuf buf) {
            this.eventID = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.eventID);
        }
    }
}

