/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.ExtendedPlayer;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.packet.PacketClairvoyance;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.spell.Spell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class Clairvoyance
extends Spell {
    public static final int PARTICLE_MOVEMENT_INTERVAL = 45;

    public Clairvoyance() {
        super(EnumTier.APPRENTICE, 20, EnumElement.SORCERY, "clairvoyance", EnumSpellType.UTILITY, 100, EnumAction.bow, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        ExtendedPlayer properties = ExtendedPlayer.get(caster);
        if (properties != null && !caster.func_70093_af()) {
            if (caster.field_71093_bK == properties.clairvoyanceDimension) {
                if (properties.clairvoyanceY > -1) {
                    PathEntity path;
                    if (!world.field_72995_K) {
                        caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.clairvoyance.searching", new Object[0]));
                    }
                    if ((path = world.func_72844_a((Entity)caster, properties.clairvoyanceX, properties.clairvoyanceY, properties.clairvoyanceZ, 256.0f * rangeMultiplier, true, true, false, true)) != null && path.func_75870_c() != null && path.func_75870_c().field_75839_a == properties.clairvoyanceX && path.func_75870_c().field_75837_b == properties.clairvoyanceY && path.func_75870_c().field_75838_c == properties.clairvoyanceZ) {
                        world.func_72956_a((Entity)caster, "wizardry:aura", 1.0f, 1.0f);
                        if (!world.field_72995_K && caster instanceof EntityPlayerMP) {
                            WizardryPacketHandler.net.sendTo((IMessage)new PacketClairvoyance.Message(path, durationMultiplier), (EntityPlayerMP)caster);
                        }
                        return true;
                    }
                    if (!world.field_72995_K) {
                        caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.clairvoyance.outofrange", new Object[0]));
                    }
                } else if (!world.field_72995_K) {
                    caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.clairvoyance.undefined", new Object[0]));
                }
            } else if (!world.field_72995_K) {
                caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.clairvoyance.wrongdimension", new Object[0]));
            }
        }
        return false;
    }

    public static void spawnPathPaticles(World world, PathEntity path, float durationMultiplier) {
        PathPoint point;
        while (!path.func_75879_b() && (point = path.func_75877_a(path.func_75873_e())) != path.func_75870_c()) {
            PathPoint nextPoint = path.func_75874_d() - path.func_75873_e() <= 2 ? path.func_75870_c() : path.func_75877_a(path.func_75873_e() + 2);
            Wizardry.proxy.spawnParticle(EnumParticleType.PATH, world, (double)point.field_75839_a + 0.5, (double)point.field_75837_b + 0.5, (double)point.field_75838_c + 0.5, (float)(nextPoint.field_75839_a - point.field_75839_a) / 45.0f, (float)(nextPoint.field_75837_b - point.field_75837_b) / 45.0f, (float)(nextPoint.field_75838_c - point.field_75838_c) / 45.0f, (int)(1800.0f * durationMultiplier), 0.0f, 1.0f, 0.3f);
            path.func_75875_a();
            path.func_75875_a();
        }
        point = path.func_75870_c();
        Wizardry.proxy.spawnParticle(EnumParticleType.PATH, world, (double)point.field_75839_a + 0.5, (double)point.field_75837_b + 0.5, (double)point.field_75838_c + 0.5, 0.0, 0.0, 0.0, (int)(1800.0f * durationMultiplier), 1.0f, 1.0f, 1.0f);
    }
}

