/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.construct.EntityIceSpike;
import electroblob.wizardry.spell.Spell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class IceSpikes
extends Spell {
    public IceSpikes() {
        super(EnumTier.ADVANCED, 30, EnumElement.ICE, "ice_spikes", EnumSpellType.ATTACK, 75, EnumAction.none, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        MovingObjectPosition rayTrace = WizardryUtilities.rayTrace(20.0f * rangeMultiplier, world, (EntityLivingBase)caster, false);
        if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && rayTrace.field_72310_e == 1) {
            if (!world.field_72995_K) {
                double x = rayTrace.field_72311_b;
                double y = rayTrace.field_72312_c;
                double z = rayTrace.field_72309_d;
                for (int i = 0; i < (int)(18.0f * blastMultiplier); ++i) {
                    float angle = (float)((double)world.field_73012_v.nextFloat() * Math.PI * 2.0);
                    double radius = 0.5 + world.field_73012_v.nextDouble() * 2.0 * (double)blastMultiplier;
                    double x1 = x + radius * (double)MathHelper.func_76126_a((float)angle);
                    double z1 = z + radius * (double)MathHelper.func_76134_b((float)angle);
                    double y1 = WizardryUtilities.getNearestFloorLevel(world, MathHelper.func_76128_c((double)x1), (int)y, MathHelper.func_76128_c((double)z1), 2) - 1;
                    if (!(y1 > -1.0)) continue;
                    EntityIceSpike icespike = new EntityIceSpike(world, x1, y1, z1, (EntityLivingBase)caster, 30 + world.field_73012_v.nextInt(15), damageMultiplier);
                    world.func_72838_d((Entity)icespike);
                }
            }
            caster.func_71038_i();
            world.func_72956_a((Entity)caster, "wizardry:ice", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EntityLivingBase target, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        if (target != null) {
            if (!world.field_72995_K) {
                double x = target.field_70165_t;
                double y = target.field_70163_u;
                double z = target.field_70161_v;
                for (int i = 0; i < (int)(18.0f * blastMultiplier); ++i) {
                    float angle = (float)((double)world.field_73012_v.nextFloat() * Math.PI * 2.0);
                    double radius = 0.5 + world.field_73012_v.nextDouble() * 2.0 * (double)blastMultiplier;
                    double x1 = x + radius * (double)MathHelper.func_76126_a((float)angle);
                    double z1 = z + radius * (double)MathHelper.func_76134_b((float)angle);
                    double y1 = WizardryUtilities.getNearestFloorLevel(world, MathHelper.func_76128_c((double)x1), (int)y, MathHelper.func_76128_c((double)z1), 2) - 1;
                    if (!(y1 > -1.0)) continue;
                    EntityIceSpike icespike = new EntityIceSpike(world, x1, y1, z1, (EntityLivingBase)caster, 30 + world.field_73012_v.nextInt(15), damageMultiplier);
                    world.func_72838_d((Entity)icespike);
                }
            }
            caster.func_71038_i();
            world.func_72956_a((Entity)caster, "wizardry:ice", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

