/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.EntityMagicSlime;
import electroblob.wizardry.spell.Spell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Slime
extends Spell {
    public Slime() {
        super(EnumTier.ADVANCED, 20, EnumElement.EARTH, "slime", EnumSpellType.ATTACK, 50, EnumAction.none, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        Vec3 look = caster.func_70040_Z();
        MovingObjectPosition rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 8.0f * rangeMultiplier);
        if (rayTrace != null && rayTrace.field_72308_g != null && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
            if (target instanceof EntitySlime) {
                if (!world.field_72995_K) {
                    caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getDisplayNameWithFormatting()}));
                }
            } else if (!(target instanceof EntityMagicSlime)) {
                if (target instanceof EntitySkeleton) {
                    caster.func_71029_a((StatBase)Wizardry.slimeSkeleton);
                }
                if (!world.field_72995_K) {
                    EntityMagicSlime slime = new EntityMagicSlime(world, (int)(200.0f * durationMultiplier));
                    slime.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                    slime.func_70078_a((Entity)target);
                    world.func_72838_d((Entity)slime);
                }
            }
        }
        if (world.field_72995_K) {
            for (int i = 1; i < (int)(25.0f * rangeMultiplier); i += 2) {
                double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                world.func_72869_a("slime", x1, y1, z1, 0.0, 0.0, 0.0);
                Wizardry.proxy.spawnParticle(EnumParticleType.DARK_MAGIC, world, x1, y1, z1, 0.0, 0.0, 0.0, 0, 0.2f, 0.8f, 0.1f);
            }
        }
        caster.func_71038_i();
        world.func_72956_a((Entity)caster, "mob.slime.attack", 1.0f, 0.5f);
        world.func_72956_a((Entity)caster, "wizardry:ice", 1.0f, 1.0f);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EntityLivingBase target, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        if (target != null && !(target instanceof EntitySlime) && !(target instanceof EntityMagicSlime)) {
            if (!world.field_72995_K) {
                EntityMagicSlime slime = new EntityMagicSlime(world, (int)(200.0f * durationMultiplier));
                slime.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                slime.func_70078_a((Entity)target);
                world.func_72838_d((Entity)slime);
            }
            if (world.field_72995_K) {
                double dx = (target.field_70165_t - caster.field_70165_t) / (double)caster.func_70032_d((Entity)target);
                double dy = (target.field_70163_u - caster.field_70163_u) / (double)caster.func_70032_d((Entity)target);
                double dz = (target.field_70161_v - caster.field_70161_v) / (double)caster.func_70032_d((Entity)target);
                for (int i = 1; i < (int)(25.0f * rangeMultiplier); i += 2) {
                    double x1 = caster.field_70165_t + dx * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    double y1 = caster.field_70163_u + (double)caster.func_70047_e() - (double)0.4f + dy * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    double z1 = caster.field_70161_v + dz * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    world.func_72869_a("slime", x1, y1, z1, 0.0, 0.0, 0.0);
                    Wizardry.proxy.spawnParticle(EnumParticleType.DARK_MAGIC, world, x1, y1, z1, 0.0, 0.0, 0.0, 0, 0.2f, 0.8f, 0.1f);
                }
            }
            caster.func_71038_i();
            world.func_72956_a((Entity)caster, "mob.slime.attack", 1.0f, 0.5f);
            world.func_72956_a((Entity)caster, "wizardry:ice", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

