/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.WizardryRegistry;
import electroblob.wizardry.spell.None;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class Spell
implements Comparable<Spell> {
    private static ArrayList<Spell> spellsList = new ArrayList(1);
    private static ArrayList<String> unlocalisedNames = new ArrayList(1);
    public final EnumTier tier;
    public final int cost;
    public final EnumElement element;
    private final String unlocalisedName;
    public final EnumSpellType type;
    public final int cooldown;
    public final EnumAction action;
    public final boolean isContinuous;
    public ResourceLocation icon;
    public String modID;
    private boolean isEnabled = true;
    public static Filter allSpells = new Filter(){

        @Override
        public boolean test(Spell spell) {
            return true;
        }
    };
    public static Filter enabledSpells = new Filter(){

        @Override
        public boolean test(Spell spell) {
            return spell.isEnabled();
        }
    };
    public static Filter nonContinuousSpells = new Filter(){

        @Override
        public boolean test(Spell spell) {
            return !spell.isContinuous;
        }
    };
    public static Filter npcSpells = new Filter(){

        @Override
        public boolean test(Spell spell) {
            return spell.isEnabled() && spell.canBeCastByNPCs();
        }
    };

    public Spell(EnumTier tier, int cost, EnumElement element, String name, EnumSpellType type, int cooldown, EnumAction action, boolean isContinuous) {
        this.tier = tier;
        this.cost = cost;
        this.element = element;
        this.unlocalisedName = name;
        this.type = type;
        this.cooldown = cooldown;
        this.action = action;
        this.isContinuous = isContinuous;
        this.modID = "wizardry";
        this.icon = new ResourceLocation(this.modID, "textures/spells/" + this.unlocalisedName + ".png");
    }

    public Spell(EnumTier tier, int cost, EnumElement element, String name, EnumSpellType type, int cooldown, EnumAction action, boolean isContinuous, String modID) {
        this(tier, cost, element, name, type, cooldown, action, isContinuous);
        this.modID = modID;
        this.icon = new ResourceLocation(this.modID, "textures/spells/" + this.unlocalisedName + ".png");
    }

    public abstract boolean cast(World var1, EntityPlayer var2, int var3, float var4, float var5, float var6, float var7);

    public boolean cast(World world, EntityLiving caster, EntityLivingBase target, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        return false;
    }

    public boolean canBeCastByNPCs() {
        return false;
    }

    public boolean doesSpellRequirePacket() {
        return true;
    }

    public final int id() {
        return spellsList.indexOf(this);
    }

    public String getUnlocalisedName() {
        return this.unlocalisedName;
    }

    public String getDisplayName() {
        return StatCollector.func_74838_a((String)("spell." + this.unlocalisedName));
    }

    public String getDisplayNameWithFormatting() {
        return this.element.colour + StatCollector.func_74838_a((String)("spell." + this.unlocalisedName));
    }

    public String getDescription() {
        return StatCollector.func_74838_a((String)("spell." + this.unlocalisedName + ".desc"));
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public final int compareTo(Spell spell) {
        if (this.tier.ordinal() > spell.tier.ordinal()) {
            return 1;
        }
        if (this.tier.ordinal() < spell.tier.ordinal()) {
            return -1;
        }
        if (this.element.ordinal() > spell.element.ordinal()) {
            return 1;
        }
        if (this.element.ordinal() < spell.element.ordinal()) {
            return -1;
        }
        return 0;
    }

    public static void register(Spell spell) {
        if (spell == null) {
            throw new NullPointerException("Tried to register a spell, but the passed in spell was null.");
        }
        spellsList.add(spell);
        if (!(spell instanceof None)) {
            unlocalisedNames.add(spell.unlocalisedName);
        }
    }

    @Deprecated
    public static void sortSpells() {
        Collections.sort(spellsList);
    }

    public static int getTotalSpellCount() {
        return spellsList.size() - 1;
    }

    public static Spell get(int id) {
        return id < 0 || id >= spellsList.size() ? WizardryRegistry.none : spellsList.get(id);
    }

    public static Spell get(String unlocalisedName) {
        for (Spell spell : Spell.getSpells(allSpells)) {
            if (!spell.unlocalisedName.equals(unlocalisedName)) continue;
            return spell;
        }
        return null;
    }

    public static String[] getUnlocalisedNames() {
        return unlocalisedNames.toArray(new String[unlocalisedNames.size()]);
    }

    public static List<Spell> getSpells(Filter filter) {
        ArrayList<Spell> spells = new ArrayList<Spell>(1);
        for (Spell spell : spellsList) {
            if (!filter.test(spell) || spell == WizardryRegistry.none) continue;
            spells.add(spell);
        }
        return spells;
    }

    public static class TierElementFilter
    implements Filter {
        private EnumTier tier;
        private EnumElement element;

        public TierElementFilter(EnumTier tier, EnumElement element) {
            this.tier = tier;
            this.element = element;
        }

        @Override
        public boolean test(Spell spell) {
            return !(!spell.isEnabled() || this.tier != null && spell.tier != this.tier || this.element != null && spell.element != this.element);
        }
    }

    public static interface Filter {
        public boolean test(Spell var1);
    }
}

