/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.block;

import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import tv.mapper.embellishcraft.block.CustomBlock;

public class CouchBlock
extends CustomBlock
implements IWaterLoggable {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.field_208146_au;
    public static final BooleanProperty LEFT_END = BooleanProperty.func_177716_a((String)"left_end");
    public static final BooleanProperty RIGHT_END = BooleanProperty.func_177716_a((String)"right_end");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SLAB_BOTTOM = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWU_CORNER = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SWU_CORNER = Block.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NEU_CORNER = Block.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SEU_CORNER = Block.func_208617_a((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = CouchBlock.makeShapes(SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    private static final int[] field_196522_K = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_199780_5_ -> CouchBlock.combineShapes(p_199780_5_, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        return voxelshape;
    }

    public CouchBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT)).func_206870_a((IProperty)LEFT_END, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)RIGHT_END, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public CouchBlock(Block.Properties properties, ToolType toolType) {
        super(properties);
        this.toolType = toolType;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT)).func_206870_a((IProperty)LEFT_END, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)RIGHT_END, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SLAB_BOTTOM_SHAPES[field_196522_K[this.getCouchShape(state)]];
    }

    private int getCouchShape(BlockState state) {
        return ((StairsShape)state.func_177229_b(SHAPE)).ordinal() * 4 + ((Direction)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_200132_m();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        boolean leftend = true;
        boolean rightend = true;
        Direction facing = context.func_195992_f();
        StairsShape shape = CouchBlock.getShapeProperty((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)facing), (IBlockReader)context.func_195991_k(), blockpos);
        if (shape == StairsShape.STRAIGHT) {
            BlockState rightstate;
            BlockState leftstate;
            switch (facing) {
                case NORTH: {
                    leftstate = iblockreader.func_180495_p(blockpos.func_177976_e());
                    rightstate = iblockreader.func_180495_p(blockpos.func_177974_f());
                    break;
                }
                case SOUTH: {
                    leftstate = iblockreader.func_180495_p(blockpos.func_177974_f());
                    rightstate = iblockreader.func_180495_p(blockpos.func_177976_e());
                    break;
                }
                case EAST: {
                    leftstate = iblockreader.func_180495_p(blockpos.func_177978_c());
                    rightstate = iblockreader.func_180495_p(blockpos.func_177968_d());
                    break;
                }
                case WEST: {
                    leftstate = iblockreader.func_180495_p(blockpos.func_177968_d());
                    rightstate = iblockreader.func_180495_p(blockpos.func_177978_c());
                    break;
                }
                default: {
                    leftstate = iblockreader.func_180495_p(blockpos.func_177976_e());
                    rightstate = iblockreader.func_180495_p(blockpos.func_177974_f());
                }
            }
            if (leftstate.func_177230_c() instanceof CouchBlock) {
                leftend = false;
            }
            if (rightstate.func_177230_c() instanceof CouchBlock) {
                rightend = false;
            }
        } else {
            leftend = false;
            rightend = false;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(SHAPE, (Comparable)shape)).func_206870_a((IProperty)FACING, (Comparable)facing)).func_206870_a((IProperty)LEFT_END, (Comparable)Boolean.valueOf(leftend))).func_206870_a((IProperty)RIGHT_END, (Comparable)Boolean.valueOf(rightend))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    private static StairsShape getShapeProperty(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (CouchBlock.isCouchBlock(blockstate) && (direction1 = (Direction)blockstate.func_177229_b((IProperty)FACING)).func_176740_k() != ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k() && CouchBlock.isDifferentCouch(state, worldIn, pos, direction1.func_176734_d())) {
            if (direction1 == direction.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (CouchBlock.isCouchBlock(blockstate1) && (direction2 = (Direction)blockstate1.func_177229_b((IProperty)FACING)).func_176740_k() != ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k() && CouchBlock.isDifferentCouch(state, worldIn, pos, direction2)) {
            if (direction2 == direction.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        boolean rightend;
        boolean leftend;
        StairsShape shape = (StairsShape)stateIn.func_177229_b(SHAPE);
        Direction direction = (Direction)stateIn.func_177229_b((IProperty)FACING);
        if (facing.func_176740_k().func_176722_c()) {
            shape = CouchBlock.getShapeProperty(stateIn, (IBlockReader)worldIn, currentPos);
        }
        if (shape == StairsShape.STRAIGHT) {
            BlockState rightstate;
            BlockState leftstate;
            switch (direction) {
                case NORTH: {
                    leftstate = worldIn.func_180495_p(currentPos.func_177976_e());
                    rightstate = worldIn.func_180495_p(currentPos.func_177974_f());
                    break;
                }
                case SOUTH: {
                    leftstate = worldIn.func_180495_p(currentPos.func_177974_f());
                    rightstate = worldIn.func_180495_p(currentPos.func_177976_e());
                    break;
                }
                case EAST: {
                    leftstate = worldIn.func_180495_p(currentPos.func_177978_c());
                    rightstate = worldIn.func_180495_p(currentPos.func_177968_d());
                    break;
                }
                case WEST: {
                    leftstate = worldIn.func_180495_p(currentPos.func_177968_d());
                    rightstate = worldIn.func_180495_p(currentPos.func_177978_c());
                    break;
                }
                default: {
                    leftstate = worldIn.func_180495_p(currentPos.func_177976_e());
                    rightstate = worldIn.func_180495_p(currentPos.func_177974_f());
                }
            }
            leftend = !(leftstate.func_177230_c() instanceof CouchBlock);
            rightend = !(rightstate.func_177230_c() instanceof CouchBlock);
        } else {
            leftend = false;
            rightend = false;
        }
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facing == Direction.DOWN && !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return facing.func_176740_k().func_176722_c() ? (BlockState)((BlockState)((BlockState)stateIn.func_206870_a(SHAPE, (Comparable)shape)).func_206870_a((IProperty)LEFT_END, (Comparable)Boolean.valueOf(leftend))).func_206870_a((IProperty)RIGHT_END, (Comparable)Boolean.valueOf(rightend)) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static boolean isDifferentCouch(BlockState state, IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(face));
        return !CouchBlock.isCouchBlock(blockstate) || blockstate.func_177229_b((IProperty)FACING) != state.func_177229_b((IProperty)FACING);
    }

    public static boolean isCouchBlock(BlockState state) {
        return state.func_177230_c() instanceof CouchBlock;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        StairsShape stairsshape = (StairsShape)state.func_177229_b(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.func_176740_k() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.func_176740_k() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, SHAPE, LEFT_END, RIGHT_END, WATERLOGGED});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

