/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.block;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tv.mapper.embellishcraft.EmbellishCraft;
import tv.mapper.embellishcraft.inventory.container.VerticalChestContainer;
import tv.mapper.embellishcraft.network.ECNetwork;
import tv.mapper.embellishcraft.network.LockerLockPacket;
import tv.mapper.embellishcraft.network.LockerUUIDPacket;
import tv.mapper.embellishcraft.state.properties.VerticalChestType;
import tv.mapper.embellishcraft.tileentity.VerticalChestTileEntity;

public class VerticalChestBlock
extends ContainerBlock
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<VerticalChestType> TYPE = EnumProperty.func_177709_a((String)"type", VerticalChestType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    private static final InventoryFactory<IInventory> field_220109_i = new InventoryFactory<IInventory>(){

        @Override
        public IInventory forDouble(VerticalChestTileEntity p_212855_1_, VerticalChestTileEntity p_212855_2_) {
            return new DoubleSidedInventory((IInventory)p_212855_1_, (IInventory)p_212855_2_);
        }

        @Override
        public IInventory forSingle(VerticalChestTileEntity p_212856_1_) {
            return p_212856_1_;
        }
    };
    private static final InventoryFactory<INamedContainerProvider> field_220110_j = new InventoryFactory<INamedContainerProvider>(){

        @Override
        public INamedContainerProvider forDouble(final VerticalChestTileEntity p_212855_1_, final VerticalChestTileEntity p_212855_2_) {
            DoubleSidedInventory iinventory = new DoubleSidedInventory((IInventory)p_212855_1_, (IInventory)p_212855_2_);
            return new INamedContainerProvider((IInventory)iinventory){
                final /* synthetic */ IInventory val$iinventory;
                {
                    this.val$iinventory = iInventory;
                }

                @Nullable
                public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                    if (p_212855_1_.func_213904_e(p_createMenu_3_) && p_212855_2_.func_213904_e(p_createMenu_3_)) {
                        p_212855_1_.func_184281_d(p_createMenu_2_.field_70458_d);
                        p_212855_2_.func_184281_d(p_createMenu_2_.field_70458_d);
                        return VerticalChestContainer.createGeneric9X6(p_createMenu_1_, p_createMenu_2_, this.val$iinventory);
                    }
                    return null;
                }

                public ITextComponent func_145748_c_() {
                    if (p_212855_1_.func_145818_k_()) {
                        return p_212855_1_.func_145748_c_();
                    }
                    return p_212855_2_.func_145818_k_() ? p_212855_2_.func_145748_c_() : new TranslationTextComponent("embellishcraft.container.locker_tall", new Object[0]);
                }
            };
        }

        @Override
        public INamedContainerProvider forSingle(VerticalChestTileEntity p_212856_1_) {
            return p_212856_1_;
        }
    };

    public VerticalChestBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(TYPE, (Comparable)((Object)VerticalChestType.SINGLE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_190946_v(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (facingState.func_177230_c() == this && facing.func_176740_k().func_200128_b()) {
            VerticalChestType chesttype = (VerticalChestType)((Object)facingState.func_177229_b(TYPE));
            if (stateIn.func_177229_b(TYPE) == VerticalChestType.SINGLE && chesttype != VerticalChestType.SINGLE && stateIn.func_177229_b((IProperty)FACING) == facingState.func_177229_b((IProperty)FACING) && VerticalChestBlock.getDirectionToAttached(facingState) == facing.func_176734_d()) {
                TileEntity Te = world.func_175625_s(facingPos);
                TileEntity attachedTe = world.func_175625_s(currentPos);
                if (attachedTe instanceof VerticalChestTileEntity && ((VerticalChestTileEntity)attachedTe).isLocked() && !world.func_201670_d()) {
                    ((VerticalChestTileEntity)Te).lockIt();
                }
                return (BlockState)stateIn.func_206870_a(TYPE, (Comparable)((Object)chesttype.opposite()));
            }
        } else if (VerticalChestBlock.getDirectionToAttached(stateIn) == facing) {
            return (BlockState)stateIn.func_206870_a(TYPE, (Comparable)((Object)VerticalChestType.SINGLE));
        }
        return super.func_196271_a(stateIn, facing, facingState, world, currentPos, facingPos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            default: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: 
        }
        return SHAPE_EAST;
    }

    public static Direction getDirectionToAttached(BlockState state) {
        return state.func_177229_b(TYPE) == VerticalChestType.BOTTOM ? Direction.UP : Direction.DOWN;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        VerticalChestType chesttype = VerticalChestType.SINGLE;
        Direction direction = context.func_195992_f().func_176734_d();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = context.func_195998_g();
        Direction direction1 = context.func_196000_l();
        if (direction1.func_176740_k().func_200128_b() && flag) {
            TileEntity attachedTe;
            BlockPos attachedPos = context.func_195995_a().func_177972_a(direction1.func_176734_d());
            BlockState attachedState = context.func_195991_k().func_180495_p(attachedPos);
            if (attachedState.func_177230_c() == this && attachedState.func_177229_b((IProperty)FACING) == direction && attachedState.func_177229_b(TYPE) == VerticalChestType.SINGLE && (attachedTe = context.func_195991_k().func_175625_s(attachedPos)) instanceof VerticalChestTileEntity && ((VerticalChestTileEntity)attachedTe).hasUUID()) {
                UUID id = ((VerticalChestTileEntity)attachedTe).getUUID();
                if (!id.equals(context.func_195999_j().func_110124_au())) {
                    chesttype = VerticalChestType.SINGLE;
                } else {
                    switch (context.func_196000_l()) {
                        case DOWN: {
                            chesttype = VerticalChestType.BOTTOM;
                            break;
                        }
                        case UP: {
                            chesttype = VerticalChestType.TOP;
                            break;
                        }
                        default: {
                            chesttype = VerticalChestType.SINGLE;
                        }
                    }
                }
            }
        }
        if (chesttype == VerticalChestType.SINGLE && !flag) {
            TileEntity te;
            BlockPos pos = context.func_195995_a();
            BlockState stateUp = context.func_195991_k().func_180495_p(pos.func_177984_a());
            BlockState stateDown = context.func_195991_k().func_180495_p(pos.func_177977_b());
            if (stateUp.func_177230_c() == this && stateUp.func_177229_b((IProperty)FACING) == direction) {
                if (stateUp.func_177229_b(TYPE) == VerticalChestType.SINGLE && (te = context.func_195991_k().func_175625_s(pos.func_177984_a())) instanceof VerticalChestTileEntity && ((VerticalChestTileEntity)te).hasUUID()) {
                    UUID id = ((VerticalChestTileEntity)te).getUUID();
                    chesttype = !id.equals(context.func_195999_j().func_110124_au()) ? VerticalChestType.SINGLE : VerticalChestType.BOTTOM;
                }
            } else if (stateDown.func_177230_c() == this && stateDown.func_177229_b((IProperty)FACING) == direction) {
                if (stateDown.func_177229_b(TYPE) == VerticalChestType.SINGLE && (te = context.func_195991_k().func_175625_s(pos.func_177977_b())) instanceof VerticalChestTileEntity && ((VerticalChestTileEntity)te).hasUUID()) {
                    UUID id = ((VerticalChestTileEntity)te).getUUID();
                    chesttype = !id.equals(context.func_195999_j().func_110124_au()) ? VerticalChestType.SINGLE : VerticalChestType.TOP;
                }
            } else {
                chesttype = VerticalChestType.SINGLE;
            }
        }
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)direction)).func_206870_a(TYPE, (Comparable)((Object)chesttype))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof VerticalChestTileEntity) {
            if (world.field_72995_K) {
                ECNetwork.EMBELLISHCRAFT_CHANNEL.sendToServer((Object)new LockerUUIDPacket(pos));
            }
            if (stack.func_82837_s()) {
                ((VerticalChestTileEntity)tileentity).func_213903_a(stack.func_200301_q());
            }
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof VerticalChestTileEntity) {
            UUID id;
            if (player.func_184586_b(handIn).func_77973_b() == Items.field_196180_eI && !world.field_72995_K) {
                EmbellishCraft.LOGGER.debug("This locker belongs to: " + ((VerticalChestTileEntity)te).getUUID() + " and locked is " + ((VerticalChestTileEntity)te).isLocked());
                return true;
            }
            if (player.func_70093_af()) {
                TileEntity otherTe;
                if (world.field_72995_K) {
                    ECNetwork.EMBELLISHCRAFT_CHANNEL.sendToServer((Object)new LockerLockPacket(pos));
                }
                if (!world.field_72995_K) {
                    if (player.func_110124_au().equals(((VerticalChestTileEntity)te).getUUID())) {
                        if (((VerticalChestTileEntity)te).isLocked()) {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("embellishcraft.message.locker.lock", new Object[0]), true);
                        } else {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("embellishcraft.message.locker.unlock", new Object[0]), true);
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("embellishcraft.message.locker.wrong", new Object[0]), true);
                    }
                }
                BlockPos otherPos = null;
                switch ((VerticalChestType)((Object)state.func_177229_b(TYPE))) {
                    case BOTTOM: {
                        otherPos = pos.func_177984_a();
                        break;
                    }
                    case TOP: {
                        otherPos = pos.func_177977_b();
                        break;
                    }
                }
                if (otherPos != null && (otherTe = world.func_175625_s(otherPos)) instanceof VerticalChestTileEntity && ((VerticalChestTileEntity)otherTe).hasUUID() && !world.field_72995_K && ((VerticalChestTileEntity)otherTe).getUUID().equals(player.func_110124_au())) {
                    ((VerticalChestTileEntity)otherTe).lockIt();
                }
                return true;
            }
            INamedContainerProvider inamedcontainerprovider = this.func_220052_b(state, world, pos);
            if (inamedcontainerprovider != null && (id = ((VerticalChestTileEntity)te).getUUID()) != null) {
                if (id.equals(player.func_110124_au())) {
                    player.func_213829_a(inamedcontainerprovider);
                } else if (!((VerticalChestTileEntity)te).isLocked()) {
                    player.func_213829_a(inamedcontainerprovider);
                } else if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("embellishcraft.message.locker.locked", new Object[0]), true);
                }
            }
        }
        return true;
    }

    @Nullable
    public static <T> T getChestInventory(BlockState state, IWorld world, BlockPos pos, boolean allowBlocked, InventoryFactory<T> inv) {
        VerticalChestType chesttype1;
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof VerticalChestTileEntity)) {
            return null;
        }
        if (!allowBlocked && VerticalChestBlock.isBlocked(world, pos)) {
            return null;
        }
        VerticalChestTileEntity chesttileentity = (VerticalChestTileEntity)tileentity;
        VerticalChestType chesttype = (VerticalChestType)((Object)state.func_177229_b(TYPE));
        if (chesttype == VerticalChestType.SINGLE) {
            return inv.forSingle(chesttileentity);
        }
        BlockPos blockpos = pos.func_177972_a(VerticalChestBlock.getDirectionToAttached(state));
        BlockState blockstate = world.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == state.func_177230_c() && (chesttype1 = (VerticalChestType)((Object)blockstate.func_177229_b(TYPE))) != VerticalChestType.SINGLE && chesttype != chesttype1 && blockstate.func_177229_b((IProperty)FACING) == state.func_177229_b((IProperty)FACING)) {
            if (!allowBlocked && VerticalChestBlock.isBlocked(world, blockpos)) {
                return null;
            }
            TileEntity tileentity1 = world.func_175625_s(blockpos);
            if (tileentity1 instanceof VerticalChestTileEntity) {
                VerticalChestTileEntity chesttileentity1 = chesttype == VerticalChestType.TOP ? chesttileentity : (VerticalChestTileEntity)tileentity1;
                VerticalChestTileEntity chesttileentity2 = chesttype == VerticalChestType.TOP ? (VerticalChestTileEntity)tileentity1 : chesttileentity;
                return inv.forDouble(chesttileentity1, chesttileentity2);
            }
        }
        return inv.forSingle(chesttileentity);
    }

    @Nullable
    public static IInventory getInventory(BlockState state, World world, BlockPos pos, boolean allowBlocked) {
        return VerticalChestBlock.getChestInventory(state, (IWorld)world, pos, allowBlocked, field_220109_i);
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        return VerticalChestBlock.getChestInventory(state, (IWorld)world, pos, false, field_220110_j);
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new VerticalChestTileEntity();
    }

    private static boolean isBlocked(IWorld world, BlockPos pos) {
        return VerticalChestBlock.isFacingSolidBlock((IBlockReader)world, pos);
    }

    private static boolean isFacingSolidBlock(IBlockReader block, BlockPos world) {
        BlockPos blockpos;
        switch ((Direction)block.func_180495_p(world).func_177229_b((IProperty)FACING)) {
            case EAST: {
                blockpos = world.func_177974_f();
                break;
            }
            case NORTH: {
                blockpos = world.func_177978_c();
                break;
            }
            case SOUTH: {
                blockpos = world.func_177968_d();
                break;
            }
            case WEST: {
                blockpos = world.func_177976_e();
                break;
            }
            default: {
                blockpos = null;
            }
        }
        if (blockpos == null) {
            return false;
        }
        return block.func_180495_p(blockpos).func_215686_e(block, blockpos);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)VerticalChestBlock.getInventory(blockState, world, pos, false));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, TYPE, WATERLOGGED});
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }

    static interface InventoryFactory<T> {
        public T forDouble(VerticalChestTileEntity var1, VerticalChestTileEntity var2);

        public T forSingle(VerticalChestTileEntity var1);
    }
}

