/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.DyeColor;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import tv.mapper.embellishcraft.client.renderer.tileentity.model.FancyBedModel;
import tv.mapper.embellishcraft.tileentity.CustomBedTileEntity;
import tv.mapper.embellishcraft.util.WoodType;

@OnlyIn(value=Dist.CLIENT)
public class CustomBedTileEntityRenderer<T extends CustomBedTileEntity>
extends TileEntityRenderer<T> {
    public static List<ResourceLocation> TEXTURES = new ArrayList<ResourceLocation>();
    private int woodId = -1;
    private int colorId = -1;
    private final FancyBedModel model = new FancyBedModel();

    public CustomBedTileEntityRenderer() {
        int i = 0;
        while ((long)i < Arrays.stream(WoodType.values()).count()) {
            int j = 0;
            while ((long)j < Arrays.stream(DyeColor.values()).count()) {
                String name = DyeColor.func_196056_a((int)j).func_176762_d() + "_" + WoodType.getWoodByID(i);
                if (i < 6) {
                    TEXTURES.add(new ResourceLocation("embellishcraft", "textures/entity/furniture/bed/" + name + "_fancy_bed.png"));
                } else if (i > 5 && i < 18 && ModList.get().isLoaded("embellishcraft-bop")) {
                    TEXTURES.add(new ResourceLocation("embellishcraft-bop", "textures/entity/bed/" + name + "_fancy_bed.png"));
                }
                ++j;
            }
            ++i;
        }
    }

    public void render(T tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        } else {
            this.woodId = ((CustomBedTileEntity)((Object)tileEntityIn)).getWood().getId();
            this.colorId = ((CustomBedTileEntity)((Object)tileEntityIn)).getColor().func_196059_a();
            ResourceLocation res = TEXTURES.get(this.woodId * 16 + this.colorId);
            if (res != null) {
                this.func_147499_a(res);
            }
        }
        if (tileEntityIn.func_145830_o()) {
            BlockState blockstate = tileEntityIn.func_195044_w();
            this.prepare(blockstate.func_177229_b((IProperty)BedBlock.field_176472_a) == BedPart.HEAD, x, y, z, (Direction)blockstate.func_177229_b((IProperty)BedBlock.field_185512_D));
        } else {
            this.prepare(true, x, y, z, Direction.SOUTH);
            this.prepare(false, x, y, z - 1.0, Direction.SOUTH);
        }
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }

    private void prepare(boolean p_199343_1_, double x, double y, double z, Direction direction) {
        this.model.preparePiece(p_199343_1_);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x), (float)((float)y + 0.5625f), (float)((float)z));
        GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.rotatef((float)(180.0f + direction.func_185119_l()), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.enableRescaleNormal();
        this.model.render();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }
}

