/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.model.ChestModel;
import net.minecraft.client.renderer.tileentity.model.LargeChestModel;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import tv.mapper.embellishcraft.EmbellishCraft;
import tv.mapper.embellishcraft.block.CustomChestBlock;
import tv.mapper.embellishcraft.init.ModBlocks;
import tv.mapper.embellishcraft.tileentity.CustomChestTileEntity;
import tv.mapper.embellishcraft.util.WoodType;

public class CustomChestTileEntityRenderer<T extends CustomChestTileEntity>
extends TileEntityRenderer<T> {
    public static List<ResourceLocation> TEXTURES = new ArrayList<ResourceLocation>();
    public static List<ResourceLocation> TEXTURES_DOUBLE = new ArrayList<ResourceLocation>();
    private int woodId = -1;
    private final ChestModel simpleChest = new ChestModel();
    private final ChestModel largeChest = new LargeChestModel();

    public CustomChestTileEntityRenderer() {
        int i = 0;
        while ((long)i < Arrays.stream(WoodType.values()).count()) {
            String name = WoodType.getWoodByID(i);
            if (i < 6) {
                TEXTURES.add(new ResourceLocation("embellishcraft", "textures/entity/furniture/storage/chest/" + name + "_fancy_chest.png"));
                TEXTURES_DOUBLE.add(new ResourceLocation("embellishcraft", "textures/entity/furniture/storage/chest/" + name + "_fancy_chest_double.png"));
            } else if (i > 5 && i < 18 && ModList.get().isLoaded("embellishcraft-bop")) {
                TEXTURES.add(new ResourceLocation("embellishcraft-bop", "textures/entity/chest/" + name + "_fancy_chest.png"));
                TEXTURES_DOUBLE.add(new ResourceLocation("embellishcraft-bop", "textures/entity/chest/" + name + "_fancy_chest_double.png"));
            }
            ++i;
        }
    }

    public void render(T tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        this.render(tileEntityIn, x, y, z, partialTicks, destroyStage, null);
    }

    public void render(T tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage, String registryName) {
        ChestType chesttype;
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        BlockState blockstate = tileEntityIn.func_145830_o() ? tileEntityIn.func_195044_w() : (BlockState)ModBlocks.OAK_FANCY_CHEST.func_176223_P().func_206870_a((IProperty)CustomChestBlock.field_176459_a, (Comparable)Direction.SOUTH);
        ChestType chestType = chesttype = blockstate.func_196959_b((IProperty)CustomChestBlock.field_196314_b) ? (ChestType)blockstate.func_177229_b((IProperty)CustomChestBlock.field_196314_b) : ChestType.SINGLE;
        if (registryName == null) {
            registryName = blockstate.func_177230_c().getRegistryName().toString();
        }
        if (chesttype != ChestType.LEFT) {
            boolean flag = chesttype != ChestType.SINGLE;
            ChestModel chestmodel = this.getChestModel(tileEntityIn, destroyStage, flag, registryName);
            if (destroyStage >= 0) {
                GlStateManager.matrixMode((int)5890);
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)(flag ? 8.0f : 4.0f), (float)4.0f, (float)1.0f);
                GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
                GlStateManager.matrixMode((int)5888);
            } else {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.pushMatrix();
            GlStateManager.enableRescaleNormal();
            GlStateManager.translatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            float f = ((Direction)blockstate.func_177229_b((IProperty)CustomChestBlock.field_176459_a)).func_185119_l();
            if ((double)Math.abs(f) > 1.0E-5) {
                GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.rotatef((float)f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            }
            this.applyLidRotation(tileEntityIn, partialTicks, chestmodel);
            chestmodel.func_78231_a();
            GlStateManager.disableRescaleNormal();
            GlStateManager.popMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (destroyStage >= 0) {
                GlStateManager.matrixMode((int)5890);
                GlStateManager.popMatrix();
                GlStateManager.matrixMode((int)5888);
            }
        }
    }

    private ChestModel getChestModel(T tileEntityIn, int destroyStage, boolean doubleChest, String blockName) {
        ResourceLocation resourcelocation;
        if (destroyStage >= 0) {
            resourcelocation = field_178460_a[destroyStage];
        } else {
            this.woodId = ((CustomChestTileEntity)((Object)tileEntityIn)).getWood().getId();
            resourcelocation = !doubleChest ? TEXTURES.get(this.woodId) : TEXTURES_DOUBLE.get(this.woodId);
        }
        if (resourcelocation != null) {
            this.func_147499_a(resourcelocation);
        } else {
            EmbellishCraft.LOGGER.warn("Warning: couldn't bind texture on custom chest renderer!");
        }
        return doubleChest ? this.largeChest : this.simpleChest;
    }

    private void applyLidRotation(T p_199346_1_, float p_199346_2_, ChestModel p_199346_3_) {
        float f = p_199346_1_.func_195480_a(p_199346_2_);
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        p_199346_3_.func_205058_b().field_78795_f = -(f * 1.5707964f);
    }
}

