/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tv.mapper.embellishcraft.block.VerticalChestBlock;
import tv.mapper.embellishcraft.client.renderer.tileentity.model.LockerModel;
import tv.mapper.embellishcraft.client.renderer.tileentity.model.TallLockerModel;
import tv.mapper.embellishcraft.state.properties.VerticalChestType;

@OnlyIn(value=Dist.CLIENT)
public class VerticalChestTileEntityRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    private static final ResourceLocation TEXTURE_LOCKER = new ResourceLocation("embellishcraft", "textures/entity/furniture/storage/locker.png");
    private final LockerModel simpleModel = new LockerModel();
    private final LockerModel largeModel = new TallLockerModel();

    public void func_199341_a(T tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        VerticalChestType chesttype;
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        BlockState blockstate = tileEntityIn.func_145830_o() ? tileEntityIn.func_195044_w() : (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)VerticalChestBlock.FACING, (Comparable)Direction.SOUTH);
        VerticalChestType verticalChestType = chesttype = blockstate.func_196959_b(VerticalChestBlock.TYPE) ? (VerticalChestType)((Object)blockstate.func_177229_b(VerticalChestBlock.TYPE)) : VerticalChestType.SINGLE;
        if (chesttype != VerticalChestType.BOTTOM) {
            boolean flag = chesttype != VerticalChestType.SINGLE;
            LockerModel lockermodel = this.getLockerModel(tileEntityIn, destroyStage, flag);
            if (destroyStage >= 0) {
                GlStateManager.matrixMode((int)5890);
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)(flag ? 8.0f : 4.0f), (float)4.0f, (float)1.0f);
                GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
                GlStateManager.matrixMode((int)5888);
            } else {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.pushMatrix();
            GlStateManager.enableRescaleNormal();
            GlStateManager.translatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            float f = ((Direction)blockstate.func_177229_b((IProperty)VerticalChestBlock.FACING)).func_185119_l();
            if ((double)Math.abs(f) > 1.0E-5) {
                GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.rotatef((float)f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            }
            this.applyLidRotation(tileEntityIn, partialTicks, lockermodel);
            lockermodel.renderAll();
            GlStateManager.disableRescaleNormal();
            GlStateManager.popMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (destroyStage >= 0) {
                GlStateManager.matrixMode((int)5890);
                GlStateManager.popMatrix();
                GlStateManager.matrixMode((int)5888);
            }
        }
    }

    private LockerModel getLockerModel(T tileEntityIn, int destroyStage, boolean doubleChest) {
        ResourceLocation resourcelocation = destroyStage >= 0 ? field_178460_a[destroyStage] : TEXTURE_LOCKER;
        this.func_147499_a(resourcelocation);
        return doubleChest ? this.largeModel : this.simpleModel;
    }

    private void applyLidRotation(T chest, float angle, LockerModel locker) {
        float f = ((IChestLid)chest).func_195480_a(angle);
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        locker.getLid().field_78796_g = 0.85f * f * 1.5707964f;
    }
}

