/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.tileentity;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import tv.mapper.embellishcraft.block.CrateBlock;
import tv.mapper.embellishcraft.init.ModTileEntityTypes;
import tv.mapper.embellishcraft.inventory.container.CrateContainer;

public class CrateTileEntity
extends LockableLootTileEntity
implements ISidedInventory {
    private static final int[] SLOTS = IntStream.range(0, 16).toArray();
    private NonNullList<ItemStack> crateContents = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
    private LazyOptional<IItemHandlerModifiable> crateHandler = LazyOptional.of(this::createHandler);

    protected CrateTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    public CrateTileEntity() {
        this(ModTileEntityTypes.CRATE);
    }

    public int func_70302_i_() {
        return 16;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.crateContents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("embellishcraft.container.wooden_crate", new Object[0]);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.loadFromNbt(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        return this.saveToNbt(compound);
    }

    public void loadFromNbt(CompoundNBT compound) {
        this.crateContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound) && compound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.crateContents);
        }
    }

    public CompoundNBT saveToNbt(CompoundNBT compound) {
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191281_a((CompoundNBT)compound, this.crateContents, (boolean)false);
        }
        return compound;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.crateContents;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.crateContents = itemsIn;
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return CrateContainer.createCrate4X4(id, player, (IInventory)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.crateHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((IInventory)this){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof CrateBlock || Block.func_149634_a((Item)stack.func_77973_b()) instanceof ShulkerBoxBlock) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.crateHandler != null) {
            this.crateHandler.invalidate();
        }
    }

    public int[] func_180463_a(Direction side) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        if (Block.func_149634_a((Item)itemStackIn.func_77973_b()) instanceof CrateBlock || Block.func_149634_a((Item)itemStackIn.func_77973_b()) instanceof ShulkerBoxBlock) {
            return false;
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }
}

