/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.tileentity;

import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import tv.mapper.embellishcraft.block.VerticalChestBlock;
import tv.mapper.embellishcraft.init.ModTileEntityTypes;
import tv.mapper.embellishcraft.inventory.container.VerticalChestContainer;
import tv.mapper.embellishcraft.item.wrapper.CustomInvWrapper;
import tv.mapper.embellishcraft.state.properties.VerticalChestType;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class VerticalChestTileEntity
extends LockableLootTileEntity
implements IChestLid,
ITickableTileEntity,
ISidedInventory {
    private static final int[] SLOTS = IntStream.range(0, 16).toArray();
    private NonNullList<ItemStack> chestContents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    protected float lidAngle;
    protected float prevLidAngle;
    protected int numPlayersUsing;
    private int ticksSinceSync;
    private boolean isLocked = false;
    private UUID id = null;
    private LazyOptional<IItemHandlerModifiable> chestHandler;

    protected VerticalChestTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    public VerticalChestTileEntity() {
        this(ModTileEntityTypes.VERTICAL_CHEST);
    }

    public int func_70302_i_() {
        return 27;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.chestContents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("embellishcraft.container.locker", new Object[0]);
    }

    public void lockIt() {
        this.isLocked = !this.isLocked;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setUUID(UUID id) {
        this.id = id;
    }

    public UUID getUUID() {
        return this.id;
    }

    public boolean hasUUID() {
        return this.id != null;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.chestContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.chestContents);
        }
        this.id = compound.func_186857_a("id");
        this.isLocked = compound.func_74767_n("is_locked");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.chestContents);
        }
        if (this.id != null) {
            compound.func_186854_a("id", this.id);
        }
        compound.func_74757_a("is_locked", this.isLocked);
        return compound;
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        this.numPlayersUsing = VerticalChestTileEntity.calculatePlayersUsingSync(this.field_145850_b, (LockableTileEntity)this, this.ticksSinceSync, i, j, k, this.numPlayersUsing);
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.playSound(SoundEvents.field_187611_cI);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f1 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && f1 >= 0.5f) {
                this.playSound(SoundEvents.field_187608_cH);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public static int calculatePlayersUsingSync(World p_213977_0_, LockableTileEntity p_213977_1_, int p_213977_2_, int p_213977_3_, int p_213977_4_, int p_213977_5_, int p_213977_6_) {
        if (!p_213977_0_.field_72995_K && p_213977_6_ != 0 && (p_213977_2_ + p_213977_3_ + p_213977_4_ + p_213977_5_) % 200 == 0) {
            p_213977_6_ = VerticalChestTileEntity.calculatePlayersUsing(p_213977_0_, p_213977_1_, p_213977_3_, p_213977_4_, p_213977_5_);
        }
        return p_213977_6_;
    }

    public static int calculatePlayersUsing(World p_213976_0_, LockableTileEntity p_213976_1_, int p_213976_2_, int p_213976_3_, int p_213976_4_) {
        int i = 0;
        for (PlayerEntity playerentity : p_213976_0_.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)p_213976_2_ - 5.0f), (double)((float)p_213976_3_ - 5.0f), (double)((float)p_213976_4_ - 5.0f), (double)((float)(p_213976_2_ + 1) + 5.0f), (double)((float)(p_213976_3_ + 1) + 5.0f), (double)((float)(p_213976_4_ + 1) + 5.0f)))) {
            IInventory iinventory;
            if (!(playerentity.field_71070_bA instanceof VerticalChestContainer) || (iinventory = ((VerticalChestContainer)playerentity.field_71070_bA).getLowerChestInventory()) != p_213976_1_ && (!(iinventory instanceof DoubleSidedInventory) || !((DoubleSidedInventory)iinventory).func_90010_a((IInventory)p_213976_1_))) continue;
            ++i;
        }
        return i;
    }

    private void playSound(SoundEvent soundIn) {
        VerticalChestType chesttype = (VerticalChestType)((Object)this.func_195044_w().func_177229_b(VerticalChestBlock.TYPE));
        if (chesttype != VerticalChestType.BOTTOM) {
            double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
            double d1 = (double)this.field_174879_c.func_177956_o() + 0.5;
            double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
            if (chesttype == VerticalChestType.TOP) {
                Direction direction = VerticalChestBlock.getDirectionToAttached(this.func_195044_w());
                d0 += (double)direction.func_82601_c() * 0.5;
                d2 += (double)direction.func_82599_e() * 0.5;
            }
            this.field_145850_b.func_184148_a((PlayerEntity)null, d0, d1, d2, soundIn, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof VerticalChestBlock) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.chestContents;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.chestContents = itemsIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    public static int getPlayersUsing(IBlockReader reader, BlockPos posIn) {
        TileEntity tileentity;
        BlockState blockstate = reader.func_180495_p(posIn);
        if (blockstate.hasTileEntity() && (tileentity = reader.func_175625_s(posIn)) instanceof VerticalChestTileEntity) {
            return ((VerticalChestTileEntity)tileentity).numPlayersUsing;
        }
        return 0;
    }

    public static void swapContents(VerticalChestTileEntity chest, VerticalChestTileEntity otherChest) {
        NonNullList<ItemStack> nonnulllist = chest.func_190576_q();
        chest.func_199721_a(otherChest.func_190576_q());
        otherChest.func_199721_a(nonnulllist);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return VerticalChestContainer.createGeneric9X3(id, player, (IInventory)this);
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
            this.chestHandler = null;
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.chestHandler == null) {
                this.chestHandler = LazyOptional.of(this::createHandler);
            }
            return this.chestHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        BlockState state = this.func_195044_w();
        if (!(state.func_177230_c() instanceof VerticalChestBlock)) {
            return new CustomInvWrapper((IInventory)this, this);
        }
        VerticalChestType type = (VerticalChestType)((Object)state.func_177229_b(VerticalChestBlock.TYPE));
        if (type != VerticalChestType.SINGLE) {
            TileEntity ote;
            VerticalChestType otype;
            BlockPos opos = this.func_174877_v().func_177972_a(VerticalChestBlock.getDirectionToAttached(state));
            BlockState ostate = this.func_145831_w().func_180495_p(opos);
            if (state.func_177230_c() == ostate.func_177230_c() && (otype = (VerticalChestType)((Object)ostate.func_177229_b(VerticalChestBlock.TYPE))) != VerticalChestType.SINGLE && type != otype && state.func_177229_b((IProperty)VerticalChestBlock.FACING) == ostate.func_177229_b((IProperty)VerticalChestBlock.FACING) && (ote = this.func_145831_w().func_175625_s(opos)) instanceof VerticalChestTileEntity) {
                VerticalChestTileEntity top = type == VerticalChestType.TOP ? this : (IInventory)ote;
                VerticalChestTileEntity bottom = type == VerticalChestType.TOP ? (IInventory)ote : this;
                return new CombinedInvWrapper(new IItemHandlerModifiable[]{new CustomInvWrapper((IInventory)top, this), new CustomInvWrapper((IInventory)bottom, this)});
            }
        }
        return new CustomInvWrapper((IInventory)this, this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        BlockPos pos = this.getTileEntity().func_174877_v();
        AxisAlignedBB bb = new AxisAlignedBB(pos.func_177982_a(0, -1, 0), pos.func_177982_a(1, 1, 1));
        return bb;
    }

    public int[] func_180463_a(Direction side) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return !this.isLocked;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return !this.isLocked;
    }
}

