/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.world;

import java.util.ArrayList;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;
import tv.mapper.mapperbase.MapperBase;
import tv.mapper.mapperbase.block.BaseBlocks;
import tv.mapper.mapperbase.block.CustomBlock;
import tv.mapper.mapperbase.config.BaseOreGenConfig;

public class BaseOreGenerator {
    private static boolean generate;

    public static void setupOregen() {
        ArrayList<String> biome_verify = new ArrayList<String>();
        for (Biome biome : ForgeRegistries.BIOMES) {
            biome_verify.add(biome.getRegistryName().toString());
        }
        for (String name : (ArrayList)BaseOreGenConfig.CommonConfig.BITUMEN_BIOME_LIST.get()) {
            if (biome_verify.contains(name)) continue;
            MapperBase.LOGGER.warn("Invalid biome '" + name + "' in mapperbase-common.toml in bitumen ore blacklist, please verify the entries!");
        }
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (!((Boolean)BaseOreGenConfig.CommonConfig.BITUMEN_GENERATION.get()).booleanValue()) continue;
            if (((ArrayList)BaseOreGenConfig.CommonConfig.BITUMEN_BIOME_LIST.get()).contains(biome.getRegistryName().toString())) {
                if (((Boolean)BaseOreGenConfig.CommonConfig.BITUMEN_LIST_MODE.get()).booleanValue()) {
                    MapperBase.LOGGER.info("Bitumen ore whitelisted for biome " + biome.getRegistryName() + " in the config.");
                    generate = true;
                } else {
                    MapperBase.LOGGER.info("Bitumen ore blacklisted for biome " + biome.getRegistryName() + " in the config.");
                    generate = false;
                }
            } else {
                generate = (Boolean)BaseOreGenConfig.CommonConfig.BITUMEN_LIST_MODE.get() == false;
            }
            if (!generate) continue;
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((CustomBlock)BaseBlocks.BITUMEN_ORE.get()).func_176223_P(), ((Integer)BaseOreGenConfig.CommonConfig.BITUMEN_SIZE.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)BaseOreGenConfig.CommonConfig.BITUMEN_CHANCE.get()).intValue(), ((Integer)BaseOreGenConfig.CommonConfig.BITUMEN_MIN_HEIGHT.get()).intValue(), ((Integer)BaseOreGenConfig.CommonConfig.BITUMEN_MIN_HEIGHT.get()).intValue(), ((Integer)BaseOreGenConfig.CommonConfig.BITUMEN_MAX_HEIGHT.get()).intValue()))));
        }
    }
}

