/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.mapper.mapperbase.block.BaseBlocks;
import tv.mapper.mapperbase.config.BaseConfig;
import tv.mapper.mapperbase.config.BaseOreGenConfig;
import tv.mapper.mapperbase.item.BaseItems;
import tv.mapper.mapperbase.util.ConfigChecker;
import tv.mapper.mapperbase.world.BaseFeatures;
import tv.mapper.mapperbase.world.BaseOreGenerator;
import tv.mapper.mapperbase.world.OreList;

@Mod(value="mapperbase")
public class MapperBase {
    public static final String MODID = "mapperbase";
    public static final Logger LOGGER = LogManager.getLogger();

    public MapperBase() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, BaseConfig.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, BaseOreGenConfig.COMMON_CONFIG);
        BaseBlocks.init();
        BaseItems.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
        MinecraftForge.EVENT_BUS.register((Object)new BaseOreGenerator());
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Mapper Base setup started!");
        OreList.initOres();
        if (!((Boolean)BaseOreGenConfig.CommonConfig.BITUMEN_GENERATION.get()).booleanValue()) {
            LOGGER.info("Ore generation is disabled by config.");
        } else {
            ConfigChecker.checkConfig();
            BaseFeatures.registerFeatures();
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    private void serverSetup(FMLDedicatedServerSetupEvent event) {
    }
}

