/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.world;

import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tv.mapper.mapperbase.MapperBase;
import tv.mapper.mapperbase.config.BaseConfig;
import tv.mapper.mapperbase.world.CustomOre;
import tv.mapper.mapperbase.world.OreList;

public class BaseOreGenerator {
    private static boolean generate;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void registerOreGen(BiomeLoadingEvent event) {
        for (CustomOre ore : OreList.ores) {
            if (!ore.canGenerate()) continue;
            String biome = event.getName().toString();
            if (ore.hasWhitelist()) {
                if (ore.getBiomeList().contains(biome)) {
                    generate = true;
                    if (((Boolean)BaseConfig.ClientConfig.ENABLE_GEN_LOGS.get()).booleanValue()) {
                        MapperBase.LOGGER.info(ore.name + " whitelisted for biome " + biome + " in the config.");
                    }
                } else {
                    generate = false;
                }
            } else if (ore.getBiomeList().contains(biome)) {
                generate = false;
                if (((Boolean)BaseConfig.ClientConfig.ENABLE_GEN_LOGS.get()).booleanValue()) {
                    MapperBase.LOGGER.info(ore.name + " blacklisted for biome " + biome + " in the config.");
                }
            } else {
                generate = true;
            }
            if (!generate) continue;
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ore.getFeature());
        }
    }
}

