/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib;

import java.util.Map;
import mchorse.mclib.CommonProxy;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.ConfigBuilder;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.config.values.ValueRL;
import mchorse.mclib.events.RegisterConfigEvent;
import mchorse.mclib.math.IValue;
import mchorse.mclib.math.MathBuilder;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber
@Mod(modid="mclib", name="McLib", version="2.0.3", updateJSON="https://raw.githubusercontent.com/mchorse/mclib/1.12/version.json", acceptedMinecraftVersions="[1.12.2]")
public class McLib {
    public static final String MOD_ID = "mclib";
    public static final String VERSION = "2.0.3";
    public static final String CLIENT_PROXY = "mchorse.mclib.ClientProxy";
    public static final String SERVER_PROXY = "mchorse.mclib.CommonProxy";
    @SidedProxy(clientSide="mchorse.mclib.ClientProxy", serverSide="mchorse.mclib.CommonProxy")
    public static CommonProxy proxy;
    public static final EventBus EVENT_BUS;
    public static ValueBoolean debugPanel;
    public static ValueInt primaryColor;
    public static ValueBoolean enableBorders;
    public static ValueBoolean enableCheckboxRendering;
    public static ValueBoolean enableGridRendering;
    public static ValueInt userIntefaceScale;
    public static ValueBoolean enableMouseRendering;
    public static ValueBoolean enableKeystrokeRendering;
    public static ValueInt keystrokeOffset;
    public static ValueInt keystrokeMode;
    public static ValueRL backgroundImage;
    public static ValueInt backgroundColor;
    public static ValueBoolean scrollbarFlat;
    public static ValueInt scrollbarShadow;
    public static ValueInt scrollbarWidth;
    public static ValueInt maxPacketSize;

    @SubscribeEvent
    public void onConfigRegister(RegisterConfigEvent event) {
        ConfigBuilder builder = event.createBuilder(MOD_ID);
        debugPanel = builder.category("appearance").getBoolean("debug_panel", false);
        primaryColor = builder.getInt("primary_color", 35071).color();
        debugPanel.invisible();
        enableBorders = builder.getBoolean("enable_borders", false);
        enableCheckboxRendering = builder.getBoolean("enable_checkbox_rendering", false);
        enableGridRendering = builder.getBoolean("enable_grid_rendering", true);
        userIntefaceScale = builder.getInt("user_interface_scale", 2, 0, 4);
        enableMouseRendering = builder.category("tutorials").getBoolean("enable_mouse_rendering", false);
        enableKeystrokeRendering = builder.getBoolean("enable_keystrokes_rendering", false);
        keystrokeOffset = builder.getInt("keystroke_offset", 10, 0, 20);
        keystrokeMode = builder.getInt("keystroke_position", 1).modes(IKey.lang("mclib.keystrokes_position.auto"), IKey.lang("mclib.keystrokes_position.bottom_left"), IKey.lang("mclib.keystrokes_position.bottom_right"), IKey.lang("mclib.keystrokes_position.top_right"), IKey.lang("mclib.keystrokes_position.top_left"));
        backgroundImage = builder.category("background").getRL("image", null);
        backgroundColor = builder.getInt("color", -872415232).colorAlpha();
        scrollbarFlat = builder.category("scrollbars").getBoolean("flat", false);
        scrollbarShadow = builder.getInt("shadow", -2013265920).colorAlpha();
        scrollbarWidth = builder.getInt("width", 4, 2, 10);
        maxPacketSize = builder.category("vanilla").getInt("max_packet_size", Short.MAX_VALUE, Short.MAX_VALUE, Integer.MAX_VALUE);
        event.modules.add(builder.build());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
        EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @NetworkCheckHandler
    public boolean checkModDependencies(Map<String, String> map, Side side) {
        return true;
    }

    public static void main(String[] args) throws Exception {
        MathBuilder test = new MathBuilder();
        IValue value = test.parse("2 + 2");
        System.out.println(value.get());
    }

    static {
        EVENT_BUS = new EventBus();
    }
}

