/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework;

import java.util.List;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.client.gui.Gui;

public class GuiTooltip {
    public GuiElement element;
    public Area area = new Area();

    public void set(GuiContext context, GuiElement element) {
        this.element = element;
        if (element != null) {
            this.area.copy(element.area);
            this.area.x -= context.shiftX;
            this.area.y -= context.shiftY;
        }
    }

    public void draw(Tooltip tooltip, GuiContext context) {
        if (this.element == null || tooltip == null) {
            return;
        }
        String label = tooltip.label.get();
        if (label.isEmpty()) {
            return;
        }
        List strings = context.font.func_78271_c(label, tooltip.width);
        if (strings.isEmpty()) {
            return;
        }
        Direction dir = tooltip.direction;
        int w = strings.size() == 1 ? context.font.func_78256_a((String)strings.get(0)) : tooltip.width;
        int h = (context.font.field_78288_b + 3) * strings.size() - 3;
        int x = this.area.x(dir.anchorX) - (int)((float)w * (1.0f - dir.anchorX)) + 6 * dir.factorX;
        int y = this.area.y(dir.anchorY) - (int)((float)h * (1.0f - dir.anchorY)) + 6 * dir.factorY;
        x = MathUtils.clamp(x, 3, context.screen.field_146294_l - w - 3);
        y = MathUtils.clamp(y, 3, context.screen.field_146295_m - h - 3);
        Gui.func_73734_a((int)(x - 3), (int)(y - 3), (int)(x + w + 3), (int)(y + h + 3), (int)-1);
        for (String line : strings) {
            context.font.func_78276_b(line, x, y, 0);
            y += context.font.field_78288_b + 3;
        }
    }

    public void drawTooltip(GuiContext context) {
        if (this.element != null) {
            this.element.drawTooltip(context, this.area);
        }
    }

    public static class Tooltip {
        public IKey label;
        public int width = 200;
        public Direction direction;

        public Tooltip(IKey label, Direction direction) {
            this.label = label;
            this.direction = direction;
        }

        public Tooltip(IKey label, int width, Direction direction) {
            this(label, direction);
            this.width = width;
        }
    }
}

