/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.GuiTooltip;
import mchorse.mclib.client.gui.framework.elements.GuiDelegateElement;
import mchorse.mclib.client.gui.framework.elements.GuiElements;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.KeybindManager;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.Flex;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Direction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElement
extends Gui
implements IGuiElement {
    public Area area = new Area();
    protected IResizer resizer;
    protected Flex flex;
    public GuiTooltip.Tooltip tooltip;
    public KeybindManager keybinds;
    public Supplier<GuiContextMenu> contextMenu;
    public boolean hideTooltip;
    public boolean ignored;
    protected boolean container;
    protected GuiElement parent;
    private GuiElements<IGuiElement> children;
    protected boolean enabled = true;
    protected boolean visible = true;
    protected Minecraft mc;
    protected FontRenderer font;

    public GuiElement(Minecraft mc) {
        this.mc = mc;
        this.font = mc.field_71466_p;
    }

    public GuiElement getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isDescendant(GuiElement element) {
        if (this == element) {
            return false;
        }
        while (element != null) {
            if (element.parent == this) {
                return true;
            }
            element = element.parent;
        }
        return false;
    }

    public List<IGuiElement> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children.elements;
    }

    public <T extends GuiElement> List<T> getChildren(Class<T> clazz) {
        return this.getChildren(clazz, new ArrayList());
    }

    public <T extends GuiElement> List<T> getChildren(Class<T> clazz, List<T> list) {
        for (IGuiElement element : this.getChildren()) {
            if (element.getClass() == clazz) {
                list.add(clazz.cast(element));
            }
            if (!(element instanceof GuiElement)) continue;
            ((GuiElement)element).getChildren(clazz, list);
        }
        return list;
    }

    public void prepend(IGuiElement element) {
        if (this.children == null) {
            this.children = new GuiElements(this);
        }
        this.markChild(element);
        this.children.prepend(element);
    }

    public void add(IGuiElement element) {
        if (this.children == null) {
            this.children = new GuiElements(this);
        }
        this.markChild(element);
        this.children.add(element);
    }

    public void add(IGuiElement ... elements) {
        if (this.children == null) {
            this.children = new GuiElements(this);
        }
        for (IGuiElement element : elements) {
            this.markChild(element);
            this.children.add(element);
        }
    }

    private void markChild(IGuiElement element) {
        if (element instanceof GuiElement) {
            GuiElement child = (GuiElement)element;
            child.parent = this;
            if (this.resizer != null) {
                this.resizer.add(this, child);
            }
        }
    }

    public void removeAll() {
        if (this.children == null) {
            return;
        }
        for (IGuiElement element : this.children.elements) {
            if (!(element instanceof GuiElement)) continue;
            if (this.resizer != null) {
                this.resizer.remove(this, (GuiElement)element);
            }
            ((GuiElement)element).parent = null;
        }
        this.children.clear();
    }

    public void removeFromParent() {
        if (this.hasParent()) {
            this.parent.remove(this);
        }
    }

    public void remove(GuiElement element) {
        if (this.children.elements.remove(element)) {
            if (this.resizer != null) {
                this.resizer.remove(this, element);
            }
            element.parent = null;
        }
    }

    public GuiElement removeTooltip() {
        this.tooltip = null;
        return this;
    }

    public GuiElement tooltip(IKey label) {
        this.tooltip = new GuiTooltip.Tooltip(label, Direction.BOTTOM);
        return this;
    }

    public GuiElement tooltip(IKey label, Direction direction) {
        this.tooltip = new GuiTooltip.Tooltip(label, direction);
        return this;
    }

    public GuiElement tooltip(IKey label, int width, Direction direction) {
        this.tooltip = new GuiTooltip.Tooltip(label, width, direction);
        return this;
    }

    public GuiElement hideTooltip() {
        this.hideTooltip = true;
        return this;
    }

    public KeybindManager keys() {
        if (this.keybinds == null) {
            this.keybinds = new KeybindManager();
        }
        return this.keybinds;
    }

    public GuiElement markContainer() {
        this.container = true;
        return this;
    }

    public GuiElement markIgnored() {
        this.ignored = true;
        return this;
    }

    public boolean isContainer() {
        return this.container;
    }

    public GuiElement getParentContainer() {
        GuiElement element;
        for (element = this.getParent(); element != null && !element.isContainer(); element = element.getParent()) {
        }
        return element;
    }

    public GuiElement context(Supplier<GuiContextMenu> supplier) {
        this.contextMenu = supplier;
        return this;
    }

    public Flex flex() {
        if (this.flex == null) {
            this.flex = new Flex(this);
            if (this.resizer == null) {
                this.resizer = this.flex;
            }
        }
        return this.flex;
    }

    public void flex(Flex flex) {
        if (flex != null) {
            this.flex = flex;
        }
    }

    public IResizer resizer() {
        return this.resizer;
    }

    public GuiElement resizer(IResizer resizer) {
        this.resizer = resizer;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.visible;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void toggleVisible() {
        this.visible = !this.visible;
    }

    public boolean canBeSeen() {
        if (!this.hasParent() || !this.isVisible()) {
            return false;
        }
        GuiElement last = this;
        GuiElement element = this.getParent();
        while (element != null) {
            if (!element.isVisible()) {
                return false;
            }
            GuiElement parent = element.getParent();
            if (parent instanceof GuiDelegateElement && ((GuiDelegateElement)parent).delegate != element) {
                return false;
            }
            last = element;
            element = parent;
        }
        return last instanceof GuiBase.GuiRootElement;
    }

    @Override
    public void resize() {
        if (this.resizer != null) {
            this.resizer.apply(this.area);
        }
        if (this.children != null) {
            this.children.resize();
        }
        if (this.resizer != null) {
            this.resizer.postApply(this.area);
        }
    }

    @Override
    public boolean mouseClicked(GuiContext context) {
        GuiContextMenu menu;
        if (this.children != null && this.children.mouseClicked(context)) {
            return true;
        }
        if (this.area.isInside(context) && context.mouseButton == 1 && !context.hasContextMenu() && (menu = this.createContextMenu(context)) != null) {
            context.setContextMenu(menu);
            return true;
        }
        return false;
    }

    public void clickItself(GuiContext context) {
        this.clickItself(context, 0);
    }

    public void clickItself(GuiContext context, int mouseButton) {
        if (!this.isEnabled()) {
            return;
        }
        int mouseX = context.mouseX;
        int mouseY = context.mouseY;
        int button = context.mouseButton;
        context.mouseX = this.area.x + 1;
        context.mouseY = this.area.y + 1;
        context.mouseButton = mouseButton;
        this.mouseClicked(context);
        context.mouseX = mouseX;
        context.mouseY = mouseY;
        context.mouseButton = button;
    }

    public GuiContextMenu createContextMenu(GuiContext context) {
        return this.contextMenu == null ? null : this.contextMenu.get();
    }

    @Override
    public boolean mouseScrolled(GuiContext context) {
        return this.children != null && this.children.mouseScrolled(context);
    }

    @Override
    public void mouseReleased(GuiContext context) {
        if (this.children != null) {
            this.children.mouseReleased(context);
        }
    }

    @Override
    public boolean keyTyped(GuiContext context) {
        if (this.children != null && this.children.keyTyped(context)) {
            return true;
        }
        return this.keybinds != null && !context.isFocused() && this.keybinds.check(context.keyCode, this.area.isInside(context));
    }

    @Override
    public void draw(GuiContext context) {
        if (this.keybinds != null && this.isEnabled()) {
            this.keybinds.add(context.keybinds, this.area.isInside(context));
        }
        if (this.tooltip != null && this.area.isInside(context)) {
            context.tooltip.set(context, this);
        } else if ((this.hideTooltip || this.container) && this.area.isInside(context)) {
            context.reset();
        }
        if (this.children != null) {
            this.children.draw(context);
        }
    }

    public void drawTooltip(GuiContext context, Area area) {
        context.tooltip.draw(this.tooltip, context);
    }
}

