/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.input;

import java.util.function.Consumer;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.ColorUtils;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiColorElement
extends GuiElement {
    public GuiColorPickerElement picker;
    public boolean label = true;
    public Direction direction;
    public GuiElement target;

    public GuiColorElement(Minecraft mc, ValueInt value) {
        this(mc, value, null);
    }

    public GuiColorElement(Minecraft mc, ValueInt value, Consumer<Integer> callback) {
        this(mc, callback == null ? value::set : integer -> {
            value.set((int)integer);
            callback.accept((Integer)integer);
        });
        this.tooltip(IKey.lang(value.getTooltipKey()));
        if (value.getSubtype() == ValueInt.Subtype.COLOR_ALPHA) {
            this.picker.editAlpha();
        }
        this.picker.setColor(value.get());
    }

    public GuiColorElement(Minecraft mc, Consumer<Integer> callback) {
        super(mc);
        this.picker = new GuiColorPickerElement(mc, color -> {
            if (callback != null) {
                callback.accept((Integer)color);
            }
        });
        this.picker.markIgnored().flex().wh(200, 85).bounds(GuiBase.getCurrent(), 2);
        this.direction(Direction.BOTTOM).flex().h(20);
    }

    public GuiColorElement direction(Direction direction) {
        this.direction = direction;
        this.picker.flex().anchor(1.0f - direction.anchorX, 1.0f - direction.anchorY);
        return this;
    }

    public GuiColorElement onTop() {
        return this.direction(Direction.TOP);
    }

    public GuiColorElement noLabel() {
        this.label = false;
        return this;
    }

    public GuiColorElement target(GuiElement target) {
        this.target = target;
        return this;
    }

    @Override
    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        if (this.area.isInside(context)) {
            if (!this.picker.hasParent()) {
                int x = context.globalX(this.area.x(this.direction.anchorX) + 2 * this.direction.factorX);
                int y = context.globalY(this.area.y(this.direction.anchorY) + 2 * this.direction.factorY);
                (this.target == null ? this.getParentContainer() : this.target).add((IGuiElement)this.picker);
                this.picker.flex().xy(x, y);
                this.picker.resize();
            } else {
                this.picker.removeFromParent();
            }
            return true;
        }
        return false;
    }

    @Override
    public void draw(GuiContext context) {
        int padding = 0;
        if (McLib.enableBorders.get()) {
            this.area.draw(-16777216);
            this.picker.drawRect(this.area.x + 1, this.area.y + 1, this.area.ex() - 1, this.area.ey() - 1);
            padding = 1;
        } else {
            this.picker.drawRect(this.area.x, this.area.y, this.area.ex(), this.area.ey());
        }
        if (this.area.isInside(context)) {
            this.area.draw(0x22000000, padding);
        }
        if (this.label) {
            String label = this.picker.color.stringify(this.picker.editAlpha);
            GuiDraw.drawTextBackground(this.font, label, this.area.mx(this.font.func_78256_a(label)), this.area.my(this.font.field_78288_b - 1), 0xFFFFFF, 0x55000000, 1);
        }
        GuiDraw.drawLockedArea(this);
        super.draw(context);
    }

    public static class GuiColorPickerElement
    extends GuiElement {
        public Color color = new Color();
        public Consumer<Integer> callback;
        public GuiTextElement input;
        public boolean editAlpha;
        public Area red = new Area();
        public Area green = new Area();
        public Area blue = new Area();
        public Area alpha = new Area();
        public int dragging = -1;

        public GuiColorPickerElement(Minecraft mc, Consumer<Integer> callback) {
            super(mc);
            this.callback = callback;
            this.input = new GuiTextElement(mc, 7, string -> {
                this.setValue(ColorUtils.parseColor(string));
                this.callback();
            });
            this.input.flex().relative(this).set(5.0f, 5.0f, 0.0f, 20.0f).w(1.0f, -35);
            this.hideTooltip().add((IGuiElement)this.input);
        }

        public GuiColorPickerElement editAlpha() {
            this.editAlpha = true;
            this.input.field.func_146203_f(9);
            return this;
        }

        public void updateField() {
            this.input.setText(this.color.stringify(this.editAlpha));
        }

        public void updateColor() {
            this.updateField();
            this.callback();
        }

        protected void callback() {
            if (this.callback != null) {
                this.callback.accept(this.editAlpha ? this.color.getRGBAColor() : this.color.getRGBColor());
            }
        }

        public void setColor(float r, float g, float b, float a) {
            this.color.set(r, g, b, a);
            this.updateField();
        }

        public void setColor(int color) {
            this.setValue(color);
            this.updateField();
        }

        public void setValue(int color) {
            this.color.set(color, this.editAlpha);
        }

        @Override
        public void resize() {
            super.resize();
            int c = this.editAlpha ? 4 : 3;
            int h = (this.area.h - 35) / c;
            int w = this.area.w - 10;
            int remainder = this.area.h - 35 - h * c;
            int y = this.area.y + 30;
            this.red.set(this.area.x + 5, y, w, h);
            if (this.editAlpha) {
                this.green.set(this.area.x + 5, y + h, w, h);
                this.blue.set(this.area.x + 5, y + h + h, w, h + remainder);
                this.alpha.set(this.area.x + 5, this.area.ey() - 5 - h, w, h);
            } else {
                this.green.set(this.area.x + 5, y + h, w, h + remainder);
                this.blue.set(this.area.x + 5, this.area.ey() - 5 - h, w, h);
            }
        }

        @Override
        public boolean mouseClicked(GuiContext context) {
            if (super.mouseClicked(context)) {
                return true;
            }
            if (this.red.isInside(context)) {
                this.dragging = 1;
                return true;
            }
            if (this.green.isInside(context)) {
                this.dragging = 2;
                return true;
            }
            if (this.blue.isInside(context)) {
                this.dragging = 3;
                return true;
            }
            if (this.alpha.isInside(context) && this.editAlpha) {
                this.dragging = 4;
                return true;
            }
            if (!this.area.isInside(context)) {
                this.removeFromParent();
                return false;
            }
            return true;
        }

        @Override
        public void mouseReleased(GuiContext context) {
            super.mouseReleased(context);
            this.dragging = -1;
        }

        @Override
        public void draw(GuiContext context) {
            if (this.dragging >= 0) {
                float factor = (float)(context.mouseX - (this.red.x + 7)) / (float)(this.red.w - 14);
                this.color.set(MathUtils.clamp(factor, 0.0f, 1.0f), this.dragging);
                this.updateColor();
            }
            int padding = GuiDraw.drawBorder(this.area, -1);
            this.area.draw(-3750202, padding + 1);
            this.drawRect(this.area.ex() - 25, this.area.y + 5, this.area.ex() - 5, this.area.y + 25);
            GuiDraw.drawOutline(this.area.ex() - 25, this.area.y + 5, this.area.ex() - 5, this.area.y + 25, 0x44000000);
            if (this.editAlpha) {
                this.mc.field_71446_o.func_110577_a(Icons.ICONS);
                GuiUtils.drawContinuousTexturedBox((int)this.alpha.x, (int)this.red.y, (int)0, (int)240, (int)this.alpha.w, (int)(this.alpha.ey() - this.red.y), (int)16, (int)16, (int)0, (float)0.0f);
            }
            Color color = new Color();
            color.copy((Color)this.color).r = 0.0f;
            int left = color.getRGBAColor();
            color.copy((Color)this.color).r = 1.0f;
            int right = color.getRGBAColor();
            GuiDraw.drawHorizontalGradientRect(this.red.x, this.red.y, this.red.ex(), this.red.ey(), left, right);
            color.copy((Color)this.color).g = 0.0f;
            left = color.getRGBAColor();
            color.copy((Color)this.color).g = 1.0f;
            right = color.getRGBAColor();
            GuiDraw.drawHorizontalGradientRect(this.green.x, this.green.y, this.green.ex(), this.green.ey(), left, right);
            color.copy((Color)this.color).b = 0.0f;
            left = color.getRGBAColor();
            color.copy((Color)this.color).b = 1.0f;
            right = color.getRGBAColor();
            GuiDraw.drawHorizontalGradientRect(this.blue.x, this.blue.y, this.blue.ex(), this.blue.ey(), left, right);
            if (this.editAlpha) {
                color.copy((Color)this.color).a = 0.0f;
                left = color.getRGBAColor();
                color.copy((Color)this.color).a = 1.0f;
                right = color.getRGBAColor();
                GuiDraw.drawHorizontalGradientRect(this.alpha.x, this.alpha.y, this.alpha.ex(), this.alpha.ey(), left, right);
            }
            GuiDraw.drawOutline(this.red.x, this.red.y, this.red.ex(), this.editAlpha ? this.alpha.ey() : this.blue.ey(), 0x44000000);
            this.drawMarker(this.red.x + 7 + (int)((float)(this.red.w - 14) * this.color.r), this.red.my());
            this.drawMarker(this.green.x + 7 + (int)((float)(this.green.w - 14) * this.color.g), this.green.my());
            this.drawMarker(this.blue.x + 7 + (int)((float)(this.blue.w - 14) * this.color.b), this.blue.my());
            if (this.editAlpha) {
                this.drawMarker(this.alpha.x + 7 + (int)((float)(this.alpha.w - 14) * this.color.a), this.alpha.my());
            }
            super.draw(context);
        }

        public void drawRect(int x1, int y1, int x2, int y2) {
            if (this.editAlpha) {
                this.mc.field_71446_o.func_110577_a(Icons.ICONS);
                GuiUtils.drawContinuousTexturedBox((int)x1, (int)y1, (int)0, (int)240, (int)(x2 - x1), (int)(y2 - y1), (int)16, (int)16, (int)0, (float)0.0f);
                this.drawAlphaPreviewQuad(x1, y1, x2, y2);
            } else {
                Gui.func_73734_a((int)x1, (int)y1, (int)x2, (int)y2, (int)this.color.getRGBAColor());
            }
        }

        private void drawAlphaPreviewQuad(int x1, int y1, int x2, int y2) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179103_j((int)7425);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(4, DefaultVertexFormats.field_181706_f);
            vertexbuffer.func_181662_b((double)x1, (double)y1, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b((double)x1, (double)y2, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b((double)x2, (double)y1, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b((double)x2, (double)y1, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, this.color.a).func_181675_d();
            vertexbuffer.func_181662_b((double)x1, (double)y2, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, this.color.a).func_181675_d();
            vertexbuffer.func_181662_b((double)x2, (double)y2, 0.0).func_181666_a(this.color.r, this.color.g, this.color.b, this.color.a).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179084_k();
            GlStateManager.func_179118_c();
            GlStateManager.func_179098_w();
        }

        private void drawMarker(int x, int y) {
            Gui.func_73734_a((int)(x - 4), (int)(y - 4), (int)(x + 4), (int)(y + 4), (int)-16777216);
            Gui.func_73734_a((int)(x - 3), (int)(y - 3), (int)(x + 3), (int)(y + 3), (int)-1);
            Gui.func_73734_a((int)(x - 2), (int)(y - 2), (int)(x + 2), (int)(y + 2), (int)-3750202);
        }
    }
}

