/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.keyframes;

import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiKeyframeElement;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiKeyframeInterpolationsList;
import mchorse.mclib.client.gui.framework.elements.keyframes.Selection;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.MathUtils;
import mchorse.mclib.utils.keyframes.Keyframe;
import mchorse.mclib.utils.keyframes.KeyframeEasing;
import mchorse.mclib.utils.keyframes.KeyframeInterpolation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public abstract class GuiKeyframesEditor<T extends GuiKeyframeElement>
extends GuiElement {
    public GuiElement frameButtons;
    public GuiTrackpadElement tick;
    public GuiTrackpadElement value;
    public GuiButtonElement interp;
    public GuiListElement<KeyframeInterpolation> interpolations;
    public GuiCirculateElement easing;
    public T graph;
    private int clicks;
    private long clickTimer;

    public GuiKeyframesEditor(Minecraft mc) {
        super(mc);
        this.frameButtons = new GuiElement(mc);
        this.frameButtons.setVisible(false);
        this.tick = new GuiTrackpadElement(mc, this::setTick);
        this.tick.limit(-2.147483648E9, 2.147483647E9, true).tooltip(IKey.lang("mclib.gui.keyframes.tick"));
        this.value = new GuiTrackpadElement(mc, this::setValue);
        this.value.tooltip(IKey.lang("mclib.gui.keyframes.value"));
        this.interp = new GuiButtonElement(mc, IKey.lang(""), b -> this.interpolations.toggleVisible());
        this.interpolations = new GuiKeyframeInterpolationsList(mc, interp -> this.pickInterpolation((KeyframeInterpolation)((Object)((Object)interp.get(0)))));
        this.interpolations.setVisible(false);
        this.easing = new GuiCirculateElement(mc, b -> this.changeEasing());
        for (KeyframeEasing easing : KeyframeEasing.values()) {
            this.easing.addLabel(IKey.lang(easing.getKey()));
        }
        this.graph = this.createElement(mc);
        this.tick.flex().relative(this).set(0.0f, 10.0f, 80.0f, 20.0f).x(1.0f, -90);
        this.value.flex().relative(this).set(0.0f, 35.0f, 80.0f, 20.0f).x(1.0f, -90);
        this.interp.flex().relative(this.tick).set(-90.0f, 0.0f, 80.0f, 20.0f);
        this.easing.flex().relative(this.value).set(-90.0f, 0.0f, 80.0f, 20.0f);
        this.interpolations.flex().relative(this).set(0.0f, 30.0f, 80.0f, 20.0f).x(1.0f, -180).h(1.0f, -30).maxH(112);
        ((GuiElement)this.graph).flex().relative(this).set(0.0f, 0.0f, 0.0f, 0.0f).w(1.0f, 0).h(1.0f, 0);
        this.add(new IGuiElement[]{this.graph, this.frameButtons});
        this.frameButtons.add(this.tick, this.value, this.interp, this.easing, this.interpolations);
    }

    protected abstract T createElement(Minecraft var1);

    protected void toggleInterpolation() {
        Keyframe keyframe = ((GuiKeyframeElement)this.graph).getCurrent();
        if (keyframe == null) {
            return;
        }
        KeyframeInterpolation interp = keyframe.interp;
        int factor = GuiScreen.func_146272_n() ? -1 : 1;
        int index = MathUtils.cycler(interp.ordinal() + factor, 0, KeyframeInterpolation.values().length - 1);
        this.pickInterpolation(KeyframeInterpolation.values()[index]);
        this.interpolations.setCurrent(interp);
        GuiUtils.playClick();
    }

    protected void toggleEasing() {
        this.easing.clickItself(GuiBase.getCurrent(), GuiScreen.func_146272_n() ? 1 : 0);
    }

    @Override
    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        int mouseX = context.mouseX;
        int mouseY = context.mouseY;
        if (this.area.isInside(mouseX, mouseY) && context.mouseButton == 0) {
            long time = System.currentTimeMillis();
            if (time - this.clickTimer < 175L) {
                ++this.clicks;
                if (this.clicks >= 1) {
                    this.clicks = 0;
                    this.doubleClick(mouseX, mouseY);
                }
            } else {
                this.clicks = 0;
            }
            this.clickTimer = time;
        }
        return this.area.isInside(mouseX, mouseY);
    }

    @Override
    public GuiContextMenu createContextMenu(GuiContext context) {
        if (((GuiKeyframeElement)this.graph).which != Selection.NOT_SELECTED) {
            GuiSimpleContextMenu menu = new GuiSimpleContextMenu(this.mc);
            menu.action(Icons.REMOVE, IKey.lang("mclib.gui.keyframes.context.remove"), this::removeSelectedKeyframes);
            if (((GuiKeyframeElement)this.graph).which != Selection.NOT_SELECTED && ((GuiKeyframeElement)this.graph).isMultipleSelected()) {
                menu.action(Icons.LEFT_HANDLE, IKey.lang("mclib.gui.keyframes.context.to_left"), () -> {
                    ((GuiKeyframeElement)this.graph).which = Selection.LEFT_HANDLE;
                });
                menu.action(Icons.MAIN_HANDLE, IKey.lang("mclib.gui.keyframes.context.to_main"), () -> {
                    ((GuiKeyframeElement)this.graph).which = Selection.KEYFRAME;
                });
                menu.action(Icons.RIGHT_HANDLE, IKey.lang("mclib.gui.keyframes.context.to_right"), () -> {
                    ((GuiKeyframeElement)this.graph).which = Selection.RIGHT_HANDLE;
                });
            }
            return menu;
        }
        return super.createContextMenu(context);
    }

    protected void doubleClick(int mouseX, int mouseY) {
        ((GuiKeyframeElement)this.graph).doubleClick(mouseX, mouseY);
        this.fillData(((GuiKeyframeElement)this.graph).getCurrent());
    }

    @Override
    public boolean mouseScrolled(GuiContext context) {
        return super.mouseScrolled(context) || this.area.isInside(context.mouseX, context.mouseY);
    }

    public void removeSelectedKeyframes() {
        ((GuiKeyframeElement)this.graph).removeSelectedKeyframes();
    }

    public void setTick(double tick) {
        ((GuiKeyframeElement)this.graph).setTick(tick, false);
    }

    public void setValue(double value) {
        ((GuiKeyframeElement)this.graph).setValue(value, false);
    }

    public void pickInterpolation(KeyframeInterpolation interp) {
        ((GuiKeyframeElement)this.graph).setInterpolation(interp);
        this.interp.label.set(interp.getKey());
        this.interpolations.setVisible(false);
    }

    public void changeEasing() {
        ((GuiKeyframeElement)this.graph).setEasing(KeyframeEasing.values()[this.easing.getValue()]);
    }

    public void fillData(Keyframe frame) {
        boolean show = frame != null && ((GuiKeyframeElement)this.graph).which != Selection.NOT_SELECTED;
        this.frameButtons.setVisible(show);
        if (!show) {
            return;
        }
        this.tick.integer = ((GuiKeyframeElement)this.graph).which == Selection.KEYFRAME;
        this.tick.setValue(((GuiKeyframeElement)this.graph).which.getX(frame));
        this.value.setValue(((GuiKeyframeElement)this.graph).which.getY(frame));
        this.interp.label.set(frame.interp.getKey());
        this.interpolations.setCurrent(frame.interp);
        this.easing.setValue(frame.easing.ordinal());
    }
}

