/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.keyframes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import mchorse.mclib.client.gui.framework.elements.keyframes.Selection;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.keyframes.Keyframe;
import mchorse.mclib.utils.keyframes.KeyframeChannel;
import mchorse.mclib.utils.keyframes.KeyframeEasing;
import mchorse.mclib.utils.keyframes.KeyframeInterpolation;

public class GuiSheet {
    public IKey title;
    public int color;
    public KeyframeChannel channel;
    public List<Integer> selected = new ArrayList<Integer>();
    public boolean handles = true;

    public GuiSheet(IKey title, int color, KeyframeChannel channel, boolean handles) {
        this(title, color, channel);
        this.handles = handles;
    }

    public GuiSheet(IKey title, int color, KeyframeChannel channel) {
        this.title = title;
        this.color = color;
        this.channel = channel;
    }

    public void sort() {
        ArrayList<Keyframe> keyframes = new ArrayList<Keyframe>();
        for (int index : this.selected) {
            Keyframe keyframe = this.channel.get(index);
            if (keyframe == null) continue;
            keyframes.add(keyframe);
        }
        this.channel.sort();
        this.selected.clear();
        for (Keyframe keyframe : keyframes) {
            this.selected.add(this.channel.getKeyframes().indexOf(keyframe));
        }
    }

    public void setTick(double dx, Selection selection, boolean opposite) {
        for (int index : this.selected) {
            Keyframe keyframe = this.channel.get(index);
            if (keyframe == null) continue;
            selection.setX(keyframe, selection.getX(keyframe) + dx, opposite);
        }
    }

    public void setValue(double dy, Selection selection, boolean opposite) {
        for (int index : this.selected) {
            Keyframe keyframe = this.channel.get(index);
            if (keyframe == null) continue;
            selection.setY(keyframe, selection.getY(keyframe) + dy, opposite);
        }
    }

    public void setInterpolation(KeyframeInterpolation interp) {
        for (int index : this.selected) {
            Keyframe keyframe = this.channel.get(index);
            if (keyframe == null) continue;
            keyframe.setInterpolation(interp);
        }
    }

    public void setEasing(KeyframeEasing easing) {
        for (int index : this.selected) {
            Keyframe keyframe = this.channel.get(index);
            if (keyframe == null) continue;
            keyframe.setEasing(easing);
        }
    }

    public Keyframe getKeyframe() {
        if (this.selected.isEmpty()) {
            return null;
        }
        return this.channel.get(this.selected.get(0));
    }

    public boolean hasSelected(int i) {
        return this.selected.contains(i);
    }

    public void clearSelection() {
        this.selected.clear();
    }

    public int getSelectedCount() {
        return this.selected.size();
    }

    public void removeSelectedKeyframes() {
        ArrayList<Integer> sorted = new ArrayList<Integer>(this.selected);
        Collections.sort(sorted);
        Collections.reverse(sorted);
        this.clearSelection();
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            this.channel.remove(index);
        }
        this.clearSelection();
    }

    public void duplicate(long tick) {
        ArrayList<Keyframe> selected = new ArrayList<Keyframe>();
        ArrayList<Keyframe> created = new ArrayList<Keyframe>();
        long minTick = Integer.MAX_VALUE;
        for (int index : this.selected) {
            Keyframe keyframe = this.channel.get(index);
            if (keyframe == null) continue;
            selected.add(keyframe);
            minTick = Math.min(keyframe.tick, minTick);
        }
        selected.sort(Comparator.comparingLong(a -> a.tick));
        long diff = tick - minTick;
        for (Keyframe keyframe : selected) {
            long fin = keyframe.tick + diff;
            int index = this.channel.insert(fin, keyframe.value);
            Keyframe current = this.channel.get(index);
            current.copy(keyframe);
            current.tick = fin;
            created.add(current);
        }
        this.clearSelection();
        for (Keyframe keyframe : created) {
            this.selected.add(this.channel.getKeyframes().indexOf(keyframe));
        }
    }
}

