/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.utils;

import java.util.List;
import java.util.Stack;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.utils.ColorUtils;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiDraw {
    private static final Stack<Area> scissors = new Stack();

    public static void scissor(int x, int y, int w, int h, GuiContext context) {
        GuiDraw.scissor(x - context.shiftX, y - context.shiftY, w, h, context.screen.field_146294_l, context.screen.field_146295_m);
    }

    public static void scissor(int x, int y, int w, int h, int sw, int sh) {
        Area scissor;
        Area area = scissor = scissors.isEmpty() ? null : scissors.peek();
        if (scissor != null) {
            w += Math.min(x - scissor.x, 0);
            h += Math.min(y - scissor.y, 0);
            x = MathUtils.clamp(x, scissor.x, scissor.ex());
            y = MathUtils.clamp(y, scissor.y, scissor.ey());
            w = MathUtils.clamp(w, 0, scissor.ex() - x);
            h = MathUtils.clamp(h, 0, scissor.ey() - y);
        }
        scissor = new Area(x, y, w, h);
        GuiDraw.scissorArea(x, y, w, h, sw, sh);
        scissors.add(scissor);
    }

    private static void scissorArea(int x, int y, int w, int h, int sw, int sh) {
        Minecraft mc = Minecraft.func_71410_x();
        float rx = (float)Math.ceil((double)mc.field_71443_c / (double)sw);
        float ry = (float)Math.ceil((double)mc.field_71440_d / (double)sh);
        int xx = (int)((float)x * rx);
        int yy = (int)((float)mc.field_71440_d - (float)(y + h) * ry);
        int ww = (int)((float)w * rx);
        int hh = (int)((float)h * ry);
        GL11.glEnable((int)3089);
        if (ww == 0 || hh == 0) {
            GL11.glScissor((int)0, (int)0, (int)1, (int)1);
        } else {
            GL11.glScissor((int)xx, (int)yy, (int)ww, (int)hh);
        }
    }

    public static void unscissor(GuiContext context) {
        GuiDraw.unscissor(context.screen.field_146294_l, context.screen.field_146295_m);
    }

    public static void unscissor(int sw, int sh) {
        scissors.pop();
        if (scissors.isEmpty()) {
            GL11.glDisable((int)3089);
        } else {
            Area area = scissors.peek();
            GuiDraw.scissorArea(area.x, area.y, area.w, area.h, sw, sh);
        }
    }

    public static void drawHorizontalGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        GuiDraw.drawHorizontalGradientRect(left, top, right, bottom, startColor, endColor, 0.0f);
    }

    public static void drawHorizontalGradientRect(int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        float a1 = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(startColor & 0xFF) / 255.0f;
        float a2 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(r2, g2, b2, a2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawBillboard(int x, int y, int u, int v, int w, int h, int textureW, int textureH) {
        GuiDraw.drawBillboard(x, y, u, v, w, h, textureW, textureH, 0.0f);
    }

    public static void drawBillboard(int x, int y, int u, int v, int w, int h, int textureW, int textureH, float z) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GuiDraw.drawBillboard(buffer, x, y, u, v, w, h, textureW, textureH, z);
        tessellator.func_78381_a();
    }

    public static void drawBillboard(BufferBuilder buffer, int x, int y, int u, int v, int w, int h, int textureW, int textureH, float z) {
        float tw = 1.0f / (float)textureW;
        float th = 1.0f / (float)textureH;
        buffer.func_181662_b((double)x, (double)(y + h), (double)z).func_187315_a((double)((float)u * tw), (double)((float)(v + h) * th)).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), (double)z).func_187315_a((double)((float)(u + w) * tw), (double)((float)(v + h) * th)).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, (double)z).func_187315_a((double)((float)(u + w) * tw), (double)((float)v * th)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)((float)u * tw), (double)((float)v * th)).func_181675_d();
    }

    public static int drawBorder(Area area, int color) {
        if (!McLib.enableBorders.get()) {
            area.draw(color);
            return 0;
        }
        area.draw(-16777216);
        area.draw(color, 1);
        return 1;
    }

    public static void drawOutlineCenter(int x, int y, int offset, int color) {
        GuiDraw.drawOutlineCenter(x, y, offset, color, 1);
    }

    public static void drawOutlineCenter(int x, int y, int offset, int color, int border) {
        GuiDraw.drawOutline(x - offset, y - offset, x + offset, y + offset, color, border);
    }

    public static void drawOutline(int left, int top, int right, int bottom, int color) {
        GuiDraw.drawOutline(left, top, right, bottom, color, 1);
    }

    public static void drawOutline(int left, int top, int right, int bottom, int color, int border) {
        Gui.func_73734_a((int)left, (int)top, (int)(left + border), (int)bottom, (int)color);
        Gui.func_73734_a((int)(right - border), (int)top, (int)right, (int)bottom, (int)color);
        Gui.func_73734_a((int)(left + border), (int)top, (int)(right - border), (int)(top + border), (int)color);
        Gui.func_73734_a((int)(left + border), (int)(bottom - border), (int)(right - border), (int)bottom, (int)color);
    }

    public static void drawOutlinedIcon(Icon icon, int x, int y, int color) {
        GuiDraw.drawOutlinedIcon(icon, x, y, color, 0.0f, 0.0f);
    }

    public static void drawOutlinedIcon(Icon icon, int x, int y, int color, float ax, float ay) {
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        icon.render(x - 1, y, ax, ay);
        icon.render(x + 1, y, ax, ay);
        icon.render(x, y - 1, ax, ay);
        icon.render(x, y + 1, ax, ay);
        ColorUtils.bindColor(color);
        icon.render(x, y, ax, ay);
    }

    public static void drawLockedArea(GuiElement element) {
        GuiDraw.drawLockedArea(element, 0);
    }

    public static void drawLockedArea(GuiElement element, int padding) {
        if (!element.isEnabled()) {
            element.area.draw(-2013265920, padding);
            GuiDraw.drawOutlinedIcon(Icons.LOCKED, element.area.mx(), element.area.my(), -1, 0.5f, 0.5f);
        }
    }

    public static void drawDropShadow(int left, int top, int right, int bottom, int offset, int opaque, int shadow) {
        left -= offset;
        top -= offset;
        right += offset;
        bottom += offset;
        float a1 = (float)(opaque >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(opaque >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(opaque >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(opaque & 0xFF) / 255.0f;
        float a2 = (float)(shadow >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(shadow >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(shadow >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(shadow & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)(right - offset), (double)(top + offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(left + offset), (double)(top + offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(left + offset), (double)(bottom - offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(right - offset), (double)(bottom - offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)right, (double)top, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)(left + offset), (double)(top + offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(right - offset), (double)(top + offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(right - offset), (double)(bottom - offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(left + offset), (double)(bottom - offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)(left + offset), (double)(top + offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)(left + offset), (double)(bottom - offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)right, (double)top, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)(right - offset), (double)(top + offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)(right - offset), (double)(bottom - offset), 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawDropCircleShadow(int x, int y, int radius, int segments, int opaque, int shadow) {
        float a1 = (float)(opaque >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(opaque >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(opaque >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(opaque & 0xFF) / 255.0f;
        float a2 = (float)(shadow >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(shadow >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(shadow >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(shadow & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        for (int i = 0; i <= segments; ++i) {
            double a = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            buffer.func_181662_b((double)x - Math.cos(a) * (double)radius, (double)y + Math.sin(a) * (double)radius, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawDropCircleShadow(int x, int y, int radius, int offset, int segments, int opaque, int shadow) {
        int i;
        if (offset >= radius) {
            GuiDraw.drawDropCircleShadow(x, y, radius, segments, opaque, shadow);
            return;
        }
        float a1 = (float)(opaque >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(opaque >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(opaque >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(opaque & 0xFF) / 255.0f;
        float a2 = (float)(shadow >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(shadow >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(shadow >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(shadow & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        for (i = 0; i <= segments; ++i) {
            double a = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            buffer.func_181662_b((double)x - Math.cos(a) * (double)offset, (double)y + Math.sin(a) * (double)offset, 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
        }
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (i = 0; i < segments; ++i) {
            double alpha1 = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            double alpha2 = (double)(i + 1) / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            buffer.func_181662_b((double)x - Math.cos(alpha2) * (double)offset, (double)y + Math.sin(alpha2) * (double)offset, 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
            buffer.func_181662_b((double)x - Math.cos(alpha1) * (double)offset, (double)y + Math.sin(alpha1) * (double)offset, 0.0).func_181666_a(r1, g1, b1, a1).func_181675_d();
            buffer.func_181662_b((double)x - Math.cos(alpha1) * (double)radius, (double)y + Math.sin(alpha1) * (double)radius, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
            buffer.func_181662_b((double)x - Math.cos(alpha2) * (double)radius, (double)y + Math.sin(alpha2) * (double)radius, 0.0).func_181666_a(r2, g2, b2, a2).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static int drawMultiText(FontRenderer font, String text, int x, int y, int color, int width) {
        return GuiDraw.drawMultiText(font, text, x, y, color, width, 12);
    }

    public static int drawMultiText(FontRenderer font, String text, int x, int y, int color, int width, int lineHeight) {
        return GuiDraw.drawMultiText(font, text, x, y, color, width, lineHeight, 0.0f, 0.0f);
    }

    public static int drawMultiText(FontRenderer font, String text, int x, int y, int color, int width, int lineHeight, float ax, float ay) {
        List list = font.func_78271_c(text, width);
        int h = lineHeight * (list.size() - 1) + font.field_78288_b;
        y = (int)((float)y - (float)h * ay);
        for (String string : list) {
            font.func_175063_a(string, (float)x + (float)(width - font.func_78256_a(string)) * ax, (float)y, color);
            y += lineHeight;
        }
        return h;
    }

    public static void drawTextBackground(FontRenderer font, String text, int x, int y, int color, int background) {
        GuiDraw.drawTextBackground(font, text, x, y, color, background, 3);
    }

    public static void drawTextBackground(FontRenderer font, String text, int x, int y, int color, int background, int offset) {
        int a = background >> 24 & 0xFF;
        if (a != 0) {
            Gui.func_73734_a((int)(x - offset), (int)(y - offset), (int)(x + font.func_78256_a(text) + offset), (int)(y + font.field_78288_b + offset), (int)background);
        }
        font.func_175063_a(text, (float)x, (float)y, color);
    }

    public static void drawCustomBackground(int x, int y, int width, int height) {
        ResourceLocation background = McLib.backgroundImage.get();
        int color = McLib.backgroundColor.get();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (background == null) {
            Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(background);
            ColorUtils.bindColor(color);
            GlStateManager.func_179141_d();
            GuiDraw.drawBillboard(x, y, 0, 0, width, height, width, height);
        }
    }

    public static void drawRepeatBillboard(int x, int y, int w, int h, int u, int v, int tileW, int tileH, int tw, int th) {
        int countX = (w - 1) / tileW + 1;
        int countY = (h - 1) / tileH + 1;
        int fillerX = w - (countX - 1) * tileW;
        int fillerY = h - (countY - 1) * tileH;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int c = countX * countY;
        for (int i = 0; i < c; ++i) {
            int ix = i % countX;
            int iy = i / countX;
            int xx = x + ix * tileW;
            int yy = y + iy * tileH;
            int xw = ix == countX - 1 ? fillerX : tileW;
            int yh = iy == countY - 1 ? fillerY : tileH;
            GuiDraw.drawBillboard(buffer, xx, yy, u, v, xw, yh, tw, th, 0.0f);
        }
        tessellator.func_78381_a();
    }
}

