/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.utils;

import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.gui.Gui;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Area
implements IResizer {
    public static final Area SHARED = new Area();
    public int x;
    public int y;
    public int w;
    public int h;

    public Area() {
    }

    public Area(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInside(GuiContext context) {
        return this.isInside(context.mouseX, context.mouseY);
    }

    public boolean isInside(int x, int y) {
        return x >= this.x && x < this.x + this.w && y >= this.y && y < this.y + this.h;
    }

    public boolean intersects(Area area) {
        return this.x < area.x + area.w && this.y < area.y + area.h && area.x < this.x + this.w && area.y < this.y + this.h;
    }

    public void set(int x, int y, int w, int h) {
        this.setPos(x, y);
        this.setSize(w, h);
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(int w, int h) {
        this.w = w;
        this.h = h;
    }

    public void setPoints(int x1, int y1, int x2, int y2) {
        this.setPoints(x1, y1, x2, y2, 0);
    }

    public void setPoints(int x1, int y1, int x2, int y2, int offset) {
        int mx = Math.max(x1, x2);
        int my = Math.max(y1, y2);
        int nx = Math.min(x1, x2);
        int ny = Math.min(y1, y2);
        this.x = nx - offset;
        this.y = ny - offset;
        this.w = mx - nx + offset;
        this.h = my - ny + offset;
    }

    public void copy(Area area) {
        this.x = area.x;
        this.y = area.y;
        this.w = area.w;
        this.h = area.h;
    }

    public int x(float anchor) {
        return this.x + (int)((float)this.w * anchor);
    }

    public int x(float anchor, int value) {
        return this.x + (int)((float)(this.w - value) * anchor);
    }

    public int mx() {
        return this.x + (int)((float)this.w * 0.5f);
    }

    public int mx(int value) {
        return this.x + (int)((float)(this.w - value) * 0.5f);
    }

    public int ex() {
        return this.x + this.w;
    }

    public int y(float anchor) {
        return this.y + (int)((float)this.h * anchor);
    }

    public int y(float anchor, int value) {
        return this.y + (int)((float)(this.h - value) * anchor);
    }

    public int my() {
        return this.y + (int)((float)this.h * 0.5f);
    }

    public int my(int value) {
        return this.y + (int)((float)(this.h - value) * 0.5f);
    }

    public int ey() {
        return this.y + this.h;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Area) {
            Area area = (Area)obj;
            return this.x == area.x && this.y == area.y && this.w == area.w && this.h == area.h;
        }
        return super.equals(obj);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int color) {
        this.draw(color, 0, 0, 0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int color, int offset) {
        this.draw(color, offset, offset, offset, offset);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int color, int horizontal, int vertical) {
        this.draw(color, horizontal, vertical, horizontal, vertical);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int color, int lx, int ty, int rx, int by) {
        Gui.func_73734_a((int)(this.x + lx), (int)(this.y + ty), (int)(this.ex() - rx), (int)(this.ey() - by), (int)color);
    }

    @Override
    public void preApply(Area area) {
    }

    @Override
    public void apply(Area area) {
        area.copy(this);
    }

    @Override
    public void postApply(Area area) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void add(GuiElement parent, GuiElement child) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void remove(GuiElement parent, GuiElement child) {
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getW() {
        return this.w;
    }

    @Override
    public int getH() {
        return this.h;
    }
}

