/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.values;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.List;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.gui.GuiConfig;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ValueDouble
extends Value {
    private double value;
    private double defaultValue;
    public final double min;
    public final double max;

    public ValueDouble(String id, double defaultValue) {
        super(id);
        this.defaultValue = defaultValue;
        this.min = Double.NEGATIVE_INFINITY;
        this.max = Double.POSITIVE_INFINITY;
        this.reset();
    }

    public ValueDouble(String id, double defaultValue, double min, double max) {
        super(id);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.reset();
    }

    public double get() {
        return this.value;
    }

    public void set(double value) {
        this.value = MathUtils.clamp(value, this.min, this.max);
        this.saveLater();
    }

    @Override
    public void reset() {
        this.set(this.defaultValue);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiElement> getFields(Minecraft mc, GuiConfig gui) {
        GuiElement element = new GuiElement(mc);
        GuiLabel label = Elements.label(IKey.lang(this.getTitleKey()), 0).anchor(0.0f, 0.5f);
        GuiTrackpadElement trackpad = new GuiTrackpadElement(mc, this);
        trackpad.flex().w(90);
        element.flex().row(0).preferred(0).height(20);
        element.add(label, trackpad.removeTooltip());
        return Arrays.asList(element.tooltip(IKey.lang(this.getTooltipKey())));
    }

    @Override
    public void fromJSON(JsonElement element) {
        this.set(element.getAsDouble());
    }

    @Override
    public JsonElement toJSON() {
        return new JsonPrimitive((Number)this.value);
    }
}

