/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.values;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.List;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.gui.GuiConfig;
import mchorse.mclib.config.values.Value;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ValueString
extends Value {
    private String value = "";
    private String defaultValue;

    public ValueString(String id, String defaultValue) {
        super(id);
        this.defaultValue = defaultValue;
        this.reset();
    }

    public String get() {
        return this.value;
    }

    public void set(String value) {
        this.value = value;
        this.saveLater();
    }

    @Override
    public void reset() {
        this.set(this.defaultValue);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiElement> getFields(Minecraft mc, GuiConfig gui) {
        GuiElement element = new GuiElement(mc);
        GuiLabel label = Elements.label(IKey.lang(this.getTitleKey()), 0).anchor(0.0f, 0.5f);
        GuiTextElement textbox = new GuiTextElement(mc, this);
        textbox.flex().w(90);
        element.flex().row(0).preferred(0).height(20);
        element.add(label, textbox.removeTooltip());
        return Arrays.asList(element.tooltip(IKey.lang(this.getTooltipKey())));
    }

    @Override
    public void fromJSON(JsonElement element) {
        this.set(element.getAsString());
    }

    @Override
    public JsonElement toJSON() {
        return new JsonPrimitive(this.value);
    }
}

