/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils.files.entries;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mchorse.mclib.utils.files.FileTree;
import mchorse.mclib.utils.files.entries.AbstractEntry;

public class FolderEntry
extends AbstractEntry {
    public FolderEntry parent;
    public FolderEntry top;
    protected List<AbstractEntry> entries = new ArrayList<AbstractEntry>();
    private long lastModified;

    public FolderEntry(String title, File file, FolderEntry parent) {
        super(title, file);
        this.parent = parent;
    }

    protected String getPrefix() {
        ArrayList<String> joiner = new ArrayList<String>();
        FolderEntry parent = this;
        while (parent != null && parent.parent != null) {
            joiner.add(parent.title);
            parent = parent.parent;
        }
        Collections.reverse(joiner);
        return String.join((CharSequence)"/", joiner).replaceFirst("/", ":");
    }

    public List<AbstractEntry> getEntries() {
        if (this.top != null) {
            return this.top.getEntries();
        }
        if (this.file != null) {
            if (this.hasChanged()) {
                this.populateEntries();
            }
            this.lastModified = System.currentTimeMillis();
        }
        return this.entries;
    }

    public List<AbstractEntry> getRawEntries() {
        return this.entries;
    }

    protected void populateEntries() {
        Collections.sort(this.entries, FileTree.SORTER);
        if (this.getEntry("../") == null) {
            FileTree.addBackEntry(this);
        }
    }

    protected AbstractEntry getEntry(String title) {
        for (AbstractEntry entry : this.entries) {
            if (!entry.title.equals(title)) continue;
            return entry;
        }
        return null;
    }

    public void setTop(FolderEntry top) {
        this.top = top;
    }

    public boolean hasChanged() {
        if (this.top != null) {
            return false;
        }
        if (this.file != null && this.file.lastModified() > this.lastModified) {
            return true;
        }
        for (AbstractEntry entry : this.entries) {
            FolderEntry folder;
            if (!entry.isFolder() || !(folder = (FolderEntry)entry).hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        AbstractEntry entry;
        if (this.entries.size() == 1 && (entry = this.entries.get(0)).isFolder() && ((FolderEntry)entry).isTop()) {
            return true;
        }
        return this.entries.isEmpty();
    }

    public boolean isTop() {
        return this.top != null;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj instanceof FolderEntry) {
            result = result && Objects.equals(this.parent, ((FolderEntry)obj).parent);
        }
        return result;
    }
}

