/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.utils.keyframes;

import mchorse.mclib.utils.Interpolation;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.keyframes.Keyframe;
import mchorse.mclib.utils.keyframes.KeyframeEasing;
import net.minecraft.util.math.MathHelper;

public enum KeyframeInterpolation {
    CONST("const"){

        @Override
        public double interpolate(Keyframe a, Keyframe b, float x) {
            return a.value;
        }
    }
    ,
    LINEAR("linear"){

        @Override
        public double interpolate(Keyframe a, Keyframe b, float x) {
            return Interpolations.lerp(a.value, b.value, (double)x);
        }
    }
    ,
    QUAD("quad"){

        @Override
        public double interpolate(Keyframe a, Keyframe b, float x) {
            if (a.easing == KeyframeEasing.IN) {
                return Interpolation.QUAD_IN.interpolate(a.value, b.value, (double)x);
            }
            if (a.easing == KeyframeEasing.OUT) {
                return Interpolation.QUAD_OUT.interpolate(a.value, b.value, (double)x);
            }
            return Interpolation.QUAD_INOUT.interpolate(a.value, b.value, (double)x);
        }
    }
    ,
    CUBIC("cubic"){

        @Override
        public double interpolate(Keyframe a, Keyframe b, float x) {
            if (a.easing == KeyframeEasing.IN) {
                return Interpolation.CUBIC_IN.interpolate(a.value, b.value, (double)x);
            }
            if (a.easing == KeyframeEasing.OUT) {
                return Interpolation.CUBIC_OUT.interpolate(a.value, b.value, (double)x);
            }
            return Interpolation.CUBIC_INOUT.interpolate(a.value, b.value, (double)x);
        }
    }
    ,
    HERMITE("hermite"){

        @Override
        public double interpolate(Keyframe a, Keyframe b, float x) {
            double v0 = a.prev.value;
            double v1 = a.value;
            double v2 = b.value;
            double v3 = b.next.value;
            return Interpolations.cubicHermite(v0, v1, v2, v3, x);
        }
    }
    ,
    EXP("exp"){

        @Override
        public double interpolate(Keyframe a, Keyframe b, float x) {
            if (a.easing == KeyframeEasing.IN) {
                return Interpolation.EXP_IN.interpolate(a.value, b.value, (double)x);
            }
            if (a.easing == KeyframeEasing.OUT) {
                return Interpolation.EXP_OUT.interpolate(a.value, b.value, (double)x);
            }
            return Interpolation.EXP_INOUT.interpolate(a.value, b.value, (double)x);
        }
    }
    ,
    BEZIER("bezier"){

        @Override
        public double interpolate(Keyframe a, Keyframe b, float x) {
            if (x <= 0.0f) {
                return a.value;
            }
            if (x >= 1.0f) {
                return b.value;
            }
            double w = b.tick - a.tick;
            double h = b.value - a.value;
            if (h == 0.0) {
                h = 1.0E-5;
            }
            double x1 = (double)a.rx / w;
            double y1 = (double)a.ry / h;
            double x2 = (w - (double)b.lx) / w;
            double y2 = (h + (double)b.ly) / h;
            double e = 5.0E-4;
            e = h == 0.0 ? e : Math.max(Math.min(e, 1.0 / h * e), 1.0E-5);
            x1 = MathHelper.func_151237_a((double)x1, (double)0.0, (double)1.0);
            x2 = MathHelper.func_151237_a((double)x2, (double)0.0, (double)1.0);
            return Interpolations.bezier(0.0, y1, y2, 1.0, Interpolations.bezierX(x1, x2, (double)x, e)) * h + a.value;
        }
    }
    ,
    BACK("back"){

        @Override
        public double interpolate(Keyframe a, Keyframe b, float x) {
            if (a.easing == KeyframeEasing.IN) {
                return Interpolation.BACK_IN.interpolate(a.value, b.value, (double)x);
            }
            if (a.easing == KeyframeEasing.OUT) {
                return Interpolation.BACK_OUT.interpolate(a.value, b.value, (double)x);
            }
            return Interpolation.BACK_INOUT.interpolate(a.value, b.value, (double)x);
        }
    }
    ,
    ELASTIC("elastic"){

        @Override
        public double interpolate(Keyframe a, Keyframe b, float x) {
            if (a.easing == KeyframeEasing.IN) {
                return Interpolation.ELASTIC_IN.interpolate(a.value, b.value, (double)x);
            }
            if (a.easing == KeyframeEasing.OUT) {
                return Interpolation.ELASTIC_OUT.interpolate(a.value, b.value, (double)x);
            }
            return Interpolation.ELASTIC_INOUT.interpolate(a.value, b.value, (double)x);
        }
    }
    ,
    BOUNCE("bounce"){

        @Override
        public double interpolate(Keyframe a, Keyframe b, float x) {
            if (a.easing == KeyframeEasing.IN) {
                return Interpolation.BOUNCE_IN.interpolate(a.value, b.value, (double)x);
            }
            if (a.easing == KeyframeEasing.OUT) {
                return Interpolation.BOUNCE_OUT.interpolate(a.value, b.value, (double)x);
            }
            return Interpolation.BOUNCE_INOUT.interpolate(a.value, b.value, (double)x);
        }
    };

    public final String key;

    private KeyframeInterpolation(String key) {
        this.key = key;
    }

    public abstract double interpolate(Keyframe var1, Keyframe var2, float var3);

    public String getKey() {
        return "mclib.interpolations." + this.key;
    }
}

