/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.api.enchant;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import quarris.enchantability.api.enchant.IEnchantEffect;

public class EnchantEffectRegistry {
    public static final Map<String, List<IEnchantEffect>> REGISTRY = new HashMap<String, List<IEnchantEffect>>();

    private static void register(ResourceLocation location, IEnchantEffect effect) {
        String loc = location.toString();
        if (!REGISTRY.containsKey(loc)) {
            REGISTRY.put(loc, Collections.singletonList(effect));
        } else {
            REGISTRY.get(location).add(effect);
        }
    }

    public static void register(IEnchantEffect effect) {
        EnchantEffectRegistry.register(Objects.requireNonNull(effect.getEnchantment().getRegistryName()), effect);
    }

    public static List<IEnchantEffect> getEffectsFromEnchantment(Enchantment enchantment) {
        return REGISTRY.getOrDefault(Objects.requireNonNull(enchantment.getRegistryName()).toString(), Collections.emptyList());
    }
}

