/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.capability.player.container;

import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;
import quarris.enchantability.api.enchant.EnchantEffectRegistry;
import quarris.enchantability.mod.capability.player.CapabilityHandler;
import quarris.enchantability.mod.capability.player.container.IEnchantItemHandler;
import quarris.enchantability.mod.capability.player.enchant.IPlayerEnchHandler;
import quarris.enchantability.mod.network.PacketHandler;
import quarris.enchantability.mod.network.PacketSendCapsToClients;

public class EnchantItemHandler
extends ItemStackHandler
implements IEnchantItemHandler {
    public static final int ENCH_SLOTS = 4;
    private EntityPlayer player;

    public EnchantItemHandler() {
        this(null);
    }

    public EnchantItemHandler(EntityPlayer player) {
        super(4);
        this.player = player;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public void updateEnchants() {
        IPlayerEnchHandler cap = (IPlayerEnchHandler)this.player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
        if (cap == null) {
            return;
        }
        cap.clearEnchants();
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            ItemStack stack = this.getStackInSlot(slot);
            NBTTagList enchants = stack.serializeNBT().func_74775_l("tag").func_150295_c("StoredEnchantments", 10);
            if (stack.func_190926_b() || enchants.func_74745_c() != 1) continue;
            Enchantment ench = Enchantment.func_185262_c((int)enchants.func_150305_b(0).func_74765_d("id"));
            short level = enchants.func_150305_b(0).func_74765_d("lvl");
            if (level <= 0 || cap.hasEnchant(ench) >= level) continue;
            cap.addEnchant(ench, level);
        }
        PacketHandler.INSTANCE.sendToAll((IMessage)new PacketSendCapsToClients(this.player));
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemEnchantedBook)) {
            return false;
        }
        NBTTagList enchants = stack.serializeNBT().func_74775_l("tag").func_150295_c("StoredEnchantments", 10);
        return enchants.func_74745_c() == 1 && !EnchantEffectRegistry.getEffectsFromEnchantment(Enchantment.func_185262_c((int)enchants.func_150305_b(0).func_74765_d("id"))).isEmpty();
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (this.isItemValid(stack)) {
            super.setStackInSlot(slot, stack);
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.isItemValid(stack)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    public int getSlots() {
        return 4;
    }
}

