/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.capability.player.enchant;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.commons.lang3.tuple.Pair;
import quarris.enchantability.api.enchant.EnchantEffectRegistry;
import quarris.enchantability.api.enchant.IEnchantEffect;
import quarris.enchantability.mod.Enchantability;
import quarris.enchantability.mod.capability.player.CapabilityHandler;
import quarris.enchantability.mod.capability.player.container.IEnchantItemHandler;
import quarris.enchantability.mod.capability.player.enchant.IPlayerEnchHandler;

public class PlayerEnchHandler
implements IPlayerEnchHandler {
    protected EntityPlayer player;
    protected boolean dirty = true;
    protected List<Pair<Enchantment, Integer>> enchants;

    public PlayerEnchHandler() {
        this(null);
    }

    public PlayerEnchHandler(EntityPlayer player) {
        this.player = player;
        this.enchants = new ArrayList<Pair<Enchantment, Integer>>();
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public List<Pair<Enchantment, Integer>> getEnchants() {
        return this.enchants;
    }

    @Override
    public boolean hasEnchant(Enchantment enchant, int tier) {
        for (Pair<Enchantment, Integer> pair : this.enchants) {
            if (!((Enchantment)pair.getLeft()).equals(enchant) || !((Integer)pair.getRight()).equals(tier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hasEnchant(Enchantment enchant) {
        for (Pair<Enchantment, Integer> pair : this.enchants) {
            if (!((Enchantment)pair.getLeft()).equals(enchant)) continue;
            return (Integer)pair.getRight();
        }
        return 0;
    }

    @Override
    public void addEnchant(Enchantment enchant, int tier) {
        if (enchant == null) {
            Enchantability.logger.warn("Tried adding enchant which does not exist.");
            return;
        }
        if (tier < 1 || tier > enchant.func_77325_b()) {
            Enchantability.logger.warn("Tried adding enchant to the player with an invalid tier for that enchant. Enchant: " + enchant.func_77320_a() + ", Tier: " + tier);
            return;
        }
        for (Pair<Enchantment, Integer> pair : this.enchants) {
            if (!((Enchantment)pair.getLeft()).equals(enchant) || tier >= (Integer)pair.getRight()) continue;
            this.enchants.remove(pair);
            break;
        }
        List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment(enchant);
        for (IEnchantEffect effect : effects) {
            effect.onAdded(this.player, tier);
        }
        this.enchants.add((Pair<Enchantment, Integer>)Pair.of((Object)enchant, (Object)tier));
        this.markDirty();
    }

    @Override
    public void removeEnchant(Enchantment enchant) {
        for (Pair<Enchantment, Integer> pair : this.enchants) {
            if (!((Enchantment)pair.getLeft()).equals(enchant)) continue;
            List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
            for (IEnchantEffect effect : effects) {
                effect.onRemoved(this.player, (Integer)pair.getRight());
            }
            this.enchants.remove(pair);
            this.markDirty();
            IEnchantItemHandler cap = (IEnchantItemHandler)this.player.getCapability(CapabilityHandler.ENCHANT_INVENTORY_CAPABILITY, null);
            for (int i = 0; i < 4; ++i) {
                NBTTagList enchants;
                NBTTagCompound ench;
                ItemStack stack = cap.getStackInSlot(i);
                if (stack.func_190926_b() || !Enchantment.func_185262_c((int)(ench = (enchants = stack.serializeNBT().func_74775_l("tag").func_150295_c("StoredEnchantments", 10)).func_150305_b(i)).func_74765_d("id")).equals(enchant) || ench.func_74765_d("lvl") != ((Integer)pair.getRight()).intValue()) continue;
                cap.setStackInSlot(i, ItemStack.field_190927_a);
                return;
            }
            return;
        }
    }

    @Override
    public void clearEnchants() {
        for (Pair<Enchantment, Integer> pair : this.enchants) {
            List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
            for (IEnchantEffect effect : effects) {
                effect.onRemoved(this.player, (Integer)pair.getRight());
            }
        }
        this.enchants.clear();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void markClean() {
        this.dirty = false;
    }

    @Override
    public NBTTagList serializeNBT() {
        NBTTagList enchantList = new NBTTagList();
        for (Pair<Enchantment, Integer> enchant : this.enchants) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("enchant", ((Enchantment)enchant.getLeft()).getRegistryName().toString());
            compound.func_74768_a("tier", ((Integer)enchant.getRight()).intValue());
            enchantList.func_74742_a((NBTBase)compound);
        }
        return enchantList;
    }

    @Override
    public void deserializeNBT(NBTTagList nbt) {
        this.clearEnchants();
        for (NBTBase base : nbt) {
            NBTTagCompound compound = (NBTTagCompound)base;
            this.addEnchant(Enchantment.func_180305_b((String)compound.func_74779_i("enchant")), compound.func_74762_e("tier"));
        }
    }
}

