/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import quarris.enchantability.mod.capability.player.CapabilityHandler;
import quarris.enchantability.mod.capability.player.enchant.IPlayerEnchHandler;

public class CommandAddEnchant
extends CommandBase {
    public String func_71517_b() {
        return "add";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/ench add <Player> <Enchantment> [tier]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        IPlayerEnchHandler cap;
        if (args.length < 2 || args.length > 3) {
            throw new CommandException("Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = server.func_184103_al().func_152612_a(args[0]);
        Enchantment enchantment = Enchantment.func_180305_b((String)args[1]);
        int tier = 1;
        if (player == null) {
            throw new CommandException("Player '" + args[0] + "' does not exist.", new Object[0]);
        }
        if (enchantment == null) {
            throw new CommandException("Enchantment '" + args[1] + "' does not exist.", new Object[0]);
        }
        if (args.length == 3) {
            try {
                tier = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                throw new CommandException("The given tier does not exist", new Object[0]);
            }
            if (tier < 1 || tier > enchantment.func_77325_b()) {
                throw new CommandException("The tier is not within the range of the enchantment. Must be between 1 and " + enchantment.func_77325_b(), new Object[0]);
            }
        }
        if ((cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null)) != null) {
            cap.addEnchant(enchantment, tier);
            sender.func_145747_a((ITextComponent)new TextComponentString("Successfully added " + enchantment.func_77316_c(tier) + " to " + player.func_70005_c_()));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        Enchantment ench;
        if (args.length == 1) {
            return CommandAddEnchant.func_71530_a((String[])args, (String[])server.func_184103_al().func_72369_d());
        }
        if (args.length == 2) {
            ArrayList<String> enchantments = new ArrayList<String>();
            for (ResourceLocation enchLocation : Enchantment.field_185264_b.func_148742_b()) {
                enchantments.add(enchLocation.toString());
            }
            return CommandAddEnchant.func_175762_a((String[])args, enchantments);
        }
        if (args.length == 3 && (ench = Enchantment.func_180305_b((String)args[1])) != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 1; i <= ench.func_77325_b(); ++i) {
                list.add(String.valueOf(i));
            }
            return list;
        }
        return Collections.emptyList();
    }
}

