/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.command;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.tuple.Pair;
import quarris.enchantability.mod.capability.player.CapabilityHandler;
import quarris.enchantability.mod.capability.player.enchant.IPlayerEnchHandler;

public class CommandGetEnchant
extends CommandBase {
    public String func_71517_b() {
        return "get";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/ench get <Player>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw new CommandException("Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = server.func_184103_al().func_152612_a(args[0]);
        if (player == null) {
            throw new CommandException("Player '" + args[0] + "' does not exist.", new Object[0]);
        }
        IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
        if (cap != null) {
            List<Pair<Enchantment, Integer>> pairs = cap.getEnchants();
            if (pairs.size() == 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString(player.func_70005_c_() + " does not have any enchants."));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(player.func_70005_c_() + " has the following enchants:"));
                StringBuilder output = new StringBuilder();
                for (int i = 0; i < cap.getEnchants().size(); ++i) {
                    output.append(((Enchantment)pairs.get(i).getLeft()).func_77316_c(((Integer)pairs.get(i).getRight()).intValue()));
                    if (i >= pairs.size() - 1) continue;
                    output.append(", ");
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(output.toString()));
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandGetEnchant.func_71530_a((String[])args, (String[])server.func_184103_al().func_72369_d());
        }
        return Collections.emptyList();
    }
}

